/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.model.mem;

import com.sibvisions.rad.model.mem.DataRow;
import java.io.Serializable;
import javax.rad.model.IChangeableDataRow;
import javax.rad.model.IDataPage;
import javax.rad.model.IDataRow;
import javax.rad.model.IRowDefinition;
import javax.rad.model.ModelException;

public class ChangeableDataRow
extends DataRow
implements IChangeableDataRow,
Serializable {
    protected static final int INTERNAL_OFFSET = 3;
    protected static final Integer INSERTING = 1;
    protected static final Integer UPDATING = 2;
    protected static final Integer WRITABLE_COLUMN_CHANGED = 3;
    protected static final Integer DELETING = 4;
    private transient IDataPage dpDataPage = null;
    private transient int iRowIndex = -1;

    protected ChangeableDataRow() {
    }

    public ChangeableDataRow(IRowDefinition iRowDefinition) {
        this(iRowDefinition, null, null, -1);
    }

    protected ChangeableDataRow(IRowDefinition iRowDefinition, Object[] objectArray, IDataPage iDataPage, int n) {
        super(iRowDefinition, objectArray);
        this.dpDataPage = iDataPage;
        this.iRowIndex = n;
    }

    public IDataPage getDataPage() {
        return this.dpDataPage;
    }

    public int getRowIndex() {
        return this.iRowIndex;
    }

    public Object getUID() {
        int n = this.rdRowDefinition.getColumnCount();
        if (this.oaStorage == null || this.oaStorage.length <= n) {
            return null;
        }
        return (Integer)this.oaStorage[n];
    }

    public boolean isInserting() throws ModelException {
        int n = this.rdRowDefinition.getColumnCount() + 1;
        if (this.oaStorage.length <= n) {
            return false;
        }
        return this.oaStorage[n] == INSERTING;
    }

    public boolean isUpdating() throws ModelException {
        int n = this.rdRowDefinition.getColumnCount() + 1;
        if (this.oaStorage.length <= n) {
            return false;
        }
        Integer n2 = (Integer)this.oaStorage[n];
        return n2 == UPDATING || n2 == WRITABLE_COLUMN_CHANGED;
    }

    public boolean isDeleting() throws ModelException {
        int n = this.rdRowDefinition.getColumnCount() + 1;
        if (this.oaStorage.length <= n) {
            return false;
        }
        return this.oaStorage[n] == DELETING;
    }

    public boolean isDetailChanged() throws ModelException {
        int n = this.rdRowDefinition.getColumnCount() + 2;
        if (this.oaStorage.length <= n) {
            return false;
        }
        Object object = this.oaStorage[n];
        return object != null;
    }

    public IDataRow getOriginalRow() throws ModelException {
        int n = this.getRowDefinition().getColumnCount();
        if (this.oaStorage.length < this.rdRowDefinition.getColumnCount() + 1) {
            return null;
        }
        Object object = this.oaStorage[n + 1];
        if (this.oaStorage.length == 3 + n * 2) {
            Object[] objectArray = new Object[n];
            System.arraycopy(this.oaStorage, 3 + n, objectArray, 0, objectArray.length);
            return new DataRow(this.getRowDefinition(), objectArray);
        }
        if (object == DELETING) {
            return this;
        }
        return null;
    }

    public boolean isWritableColumnChanged() {
        int n = this.rdRowDefinition.getColumnCount() + 1;
        if (this.oaStorage.length <= n) {
            return false;
        }
        return this.oaStorage[n] == WRITABLE_COLUMN_CHANGED;
    }

    public String toString() {
        return "Changeable" + super.toString() + ", UID=" + this.getUID();
    }
}

