/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.model;

import com.sibvisions.util.type.CodecUtil;
import com.sibvisions.util.type.FileUtil;
import com.sibvisions.util.type.LocaleUtil;
import com.sibvisions.util.type.StringUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.rad.model.IDataBook;
import javax.rad.model.ModelException;
import javax.rad.model.SortDefinition;
import javax.rad.model.condition.ICondition;
import javax.rad.model.datatype.IDataType;
import javax.rad.persist.ColumnMetaData;

public final class DataBookUtil {
    private DataBookUtil() {
    }

    public static void writeCSV(IDataBook iDataBook, OutputStream outputStream, String[] stringArray, String[] stringArray2, ICondition iCondition, SortDefinition sortDefinition) throws ModelException, IOException {
        DataBookUtil.writeCSV(iDataBook, outputStream, stringArray, stringArray2, iCondition, sortDefinition, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeCSV(IDataBook iDataBook, OutputStream outputStream, String[] stringArray, String[] stringArray2, ICondition iCondition, SortDefinition sortDefinition, String string) throws ModelException, IOException {
        ICondition iCondition2 = iDataBook.getFilter();
        SortDefinition sortDefinition2 = iDataBook.getSort();
        int n = iDataBook.getSelectedRow();
        String string2 = string;
        if (string2 == null) {
            string2 = LocaleUtil.getListSeparator();
        }
        OutputStreamWriter outputStreamWriter = null;
        try {
            int n2;
            outputStreamWriter = new OutputStreamWriter(outputStream, "ISO-8859-1");
            if (iCondition != null) {
                iDataBook.setFilter(iCondition);
            }
            if (sortDefinition != null) {
                iDataBook.setSort(sortDefinition);
            }
            if (stringArray == null) {
                stringArray = iDataBook.getRowDefinition().getColumnView(null).getColumnNames();
            }
            if (stringArray2 == null) {
                stringArray2 = new String[stringArray.length];
                for (n2 = 0; n2 < stringArray.length; ++n2) {
                    stringArray2[n2] = iDataBook.getRowDefinition().getColumnDefinition(stringArray[n2]).getLabel();
                    if (stringArray2[n2] != null) continue;
                    stringArray2[n2] = ColumnMetaData.getDefaultLabel(stringArray[n2]);
                }
            }
            for (n2 = 0; n2 < stringArray2.length; ++n2) {
                if (n2 > 0) {
                    outputStreamWriter.write(string2);
                }
                outputStreamWriter.write(StringUtil.quote(stringArray2[n2], '\"'));
            }
            outputStreamWriter.write("\n");
            iDataBook.fetchAll();
            IDataType[] iDataTypeArray = new IDataType[stringArray.length];
            int n3 = iDataBook.getRowCount();
            for (int i = 0; i < n3; ++i) {
                iDataBook.setSelectedRow(i);
                Object[] objectArray = iDataBook.getValues(stringArray);
                for (int j = 0; j < stringArray.length; ++j) {
                    if (j > 0) {
                        outputStreamWriter.write(string2);
                    }
                    if (objectArray[j] == null) continue;
                    if (iDataTypeArray[j] == null) {
                        iDataTypeArray[j] = iDataBook.getRowDefinition().getColumnDefinition(stringArray[j]).getDataType();
                    }
                    DataBookUtil.writeQuoted(outputStreamWriter, iDataTypeArray[j], objectArray[j], string2);
                }
                outputStreamWriter.write("\n");
            }
            outputStreamWriter.flush();
        }
        finally {
            if (outputStreamWriter != null) {
                try {
                    outputStreamWriter.close();
                }
                catch (Exception exception) {}
            }
            iDataBook.setSort(sortDefinition2);
            iDataBook.setFilter(iCondition2);
            iDataBook.setSelectedRow(n);
        }
    }

    public static String formatCSVFileName(String string) {
        if (string == null) {
            return "Export.csv";
        }
        String string2 = FileUtil.getExtension(string);
        if (string2 == null || "".equals(string2.trim())) {
            string2 = "csv";
        }
        return StringUtil.formatInitCap(FileUtil.removeExtension(string)) + "." + string2;
    }

    public static void writeQuoted(OutputStreamWriter outputStreamWriter, IDataType iDataType, Object object, String string) throws IOException {
        if (object != null) {
            switch (iDataType.getTypeIdentifier()) {
                case 3: 
                case 16: {
                    outputStreamWriter.write(iDataType.convertToString(object));
                    break;
                }
                case -2: {
                    if (!(object instanceof byte[])) break;
                    outputStreamWriter.write(CodecUtil.encodeHex((byte[])object));
                    break;
                }
                case 93: {
                    String string2 = iDataType.convertToString(object);
                    if (string2.indexOf(string) >= 0) {
                        outputStreamWriter.write(StringUtil.quote(string2, '\"'));
                        break;
                    }
                    outputStreamWriter.write(iDataType.convertToString(object));
                    break;
                }
                default: {
                    outputStreamWriter.write(StringUtil.quote(iDataType.convertToString(object), '\"'));
                }
            }
        }
    }
}

