/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.application;

import com.sibvisions.rad.model.mem.MemDataBook;
import com.sibvisions.util.type.CommonUtil;
import javax.rad.application.IContent;
import javax.rad.genui.UIDimension;
import javax.rad.genui.UIImage;
import javax.rad.genui.UIInsets;
import javax.rad.genui.celleditor.UITextCellEditor;
import javax.rad.genui.component.UIButton;
import javax.rad.genui.component.UIIcon;
import javax.rad.genui.component.UITextArea;
import javax.rad.genui.component.UIToggleButton;
import javax.rad.genui.container.UIGroupPanel;
import javax.rad.genui.container.UIInternalFrame;
import javax.rad.genui.control.UIEditor;
import javax.rad.genui.control.UITable;
import javax.rad.genui.layout.UIFormLayout;
import javax.rad.model.ColumnDefinition;
import javax.rad.model.ColumnView;
import javax.rad.model.IRowDefinition;
import javax.rad.model.ModelException;
import javax.rad.model.datatype.ObjectDataType;
import javax.rad.ui.IComponent;
import javax.rad.ui.component.IButton;
import javax.rad.ui.component.ITextArea;
import javax.rad.ui.component.IToggleButton;
import javax.rad.ui.container.IDesktopPanel;
import javax.rad.ui.event.UIActionEvent;
import javax.rad.ui.layout.IFormLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Error
extends UIInternalFrame
implements IContent {
    private Object opener;
    private IFormLayout foMain;
    private UIGroupPanel gpanDetails;
    private ITextArea taMessage;
    private IButton butOK;
    private IToggleButton butDetails;
    private MemDataBook mdbError;

    public Error(IDesktopPanel iDesktopPanel) throws Exception {
        super(iDesktopPanel);
        this.init();
    }

    private void init() throws Exception {
        this.setTitle("Information");
        this.setResizable(true);
        this.setIconImage(null);
        this.setMaximizable(false);
        this.setIconifiable(false);
        this.setModal(true);
        this.setMinimumSize(new UIDimension(200, 140));
        UIIcon uIIcon = new UIIcon();
        uIIcon.setImage(UIImage.getImage("MESSAGE_ERROR_LARGE"));
        uIIcon.setVerticalAlignment(0);
        this.taMessage = new UITextArea();
        this.taMessage.setMinimumSize(new UIDimension(0, 70));
        this.taMessage.setPreferredSize(new UIDimension(470, 70));
        this.taMessage.setWordWrap(true);
        this.taMessage.setEditable(false);
        this.butOK = new UIButton();
        this.butOK.eventAction().addListener(this, "doOk");
        this.butOK.setText("OK");
        this.butOK.setDefaultButton(true);
        this.butDetails = new UIToggleButton();
        this.butDetails.eventAction().addListener(this, "doDetails");
        this.butDetails.setText("Details");
        this.mdbError = new MemDataBook();
        this.mdbError.setName("Error");
        this.mdbError.setUpdateEnabled(false);
        this.mdbError.setDeleteEnabled(false);
        IRowDefinition iRowDefinition = this.mdbError.getRowDefinition();
        iRowDefinition.addColumnDefinition(new ColumnDefinition("ERROR"));
        iRowDefinition.addColumnDefinition(new ColumnDefinition("DETAIL"));
        iRowDefinition.addColumnDefinition(new ColumnDefinition("CAUSE", new ObjectDataType()));
        iRowDefinition.setColumnView(null, new ColumnView("ERROR"));
        iRowDefinition.getColumnDefinition("ERROR").setLabel("Cause(s) of failure");
        this.mdbError.open();
        UITable uITable = new UITable();
        uITable.setDataBook(this.mdbError);
        uITable.setPreferredSize(new UIDimension(0, 90));
        uITable.setMaximumSize(new UIDimension(Integer.MAX_VALUE, 90));
        uITable.setAutoResize(true);
        UITextCellEditor uITextCellEditor = new UITextCellEditor();
        uITextCellEditor.setContentType("text/plain;multiline");
        UIEditor uIEditor = new UIEditor();
        uIEditor.setCellEditor(uITextCellEditor);
        uIEditor.setDataRow(this.mdbError);
        uIEditor.setColumnName("DETAIL");
        uIEditor.setPreferredSize(new UIDimension(0, 200));
        UIFormLayout uIFormLayout = new UIFormLayout();
        uIFormLayout.setMargins(new UIInsets(2, 2, 2, 2));
        this.gpanDetails = new UIGroupPanel();
        this.gpanDetails.setText("Details");
        this.gpanDetails.setLayout(uIFormLayout);
        this.gpanDetails.add((IComponent)uITable, uIFormLayout.getConstraints(uIFormLayout.getTopMarginAnchor(), uIFormLayout.getLeftMarginAnchor(), null, uIFormLayout.getRightMarginAnchor()));
        this.gpanDetails.add((IComponent)uIEditor, uIFormLayout.getConstraints(uIFormLayout.createAnchor(((IFormLayout.IConstraints)uIFormLayout.getConstraints(uITable)).getBottomAnchor(), 5), uIFormLayout.getLeftMarginAnchor(), uIFormLayout.getBottomMarginAnchor(), uIFormLayout.getRightMarginAnchor()));
        this.foMain = new UIFormLayout();
        this.foMain.setVerticalAlignment(0);
        this.foMain.setMargins(new UIInsets(7, 7, 7, 7));
        this.setLayout(this.foMain);
        this.add(uIIcon);
        this.add((IComponent)this.taMessage, this.foMain.getConstraints(this.foMain.getTopMarginAnchor(), this.foMain.createAnchor(((IFormLayout.IConstraints)this.foMain.getConstraints(uIIcon)).getRightAnchor(), 5), null, this.foMain.getRightMarginAnchor()));
        this.add((IComponent)this.butOK, this.foMain.getConstraints(null, null, this.foMain.getBottomMarginAnchor(), this.foMain.getRightMarginAnchor()));
        this.add((IComponent)this.butDetails, this.foMain.getConstraints(null, null, this.foMain.getBottomMarginAnchor(), this.foMain.createAnchor(((IFormLayout.IConstraints)this.foMain.getConstraints(this.butOK)).getLeftAnchor(), -5)));
        this.add((IComponent)this.gpanDetails, this.foMain.getConstraints(null, this.foMain.getLeftMarginAnchor(), this.foMain.getBottomMarginAnchor(), this.foMain.getRightMarginAnchor()));
        this.gpanDetails.setVisible(false);
        ((IFormLayout.IConstraints)this.foMain.getConstraints(this.taMessage)).setBottomAnchor(this.foMain.createAnchor(((IFormLayout.IConstraints)this.foMain.getConstraints(this.butOK)).getTopAnchor(), -7));
    }

    @Override
    public void notifyDestroy() {
    }

    @Override
    public void notifyVisible() {
    }

    @Override
    public <OP> void setOpener(OP OP) {
        this.opener = OP;
    }

    @Override
    public <OP> OP getOpener() {
        return (OP)this.opener;
    }

    public void addError(Throwable throwable) {
        if (throwable != null) {
            this.mdbError.setInsertEnabled(true);
            Throwable throwable2 = throwable;
            try {
                String string;
                do {
                    String string2;
                    if ((string2 = throwable2.getMessage()) == null || string2.trim().length() == 0) {
                        string2 = throwable2.getClass().getName();
                        string = throwable2.getClass().getSimpleName();
                    } else {
                        string = string2;
                    }
                    this.mdbError.insert(true);
                    this.mdbError.setValues(new String[]{"ERROR", "DETAIL", "CAUSE"}, new Object[]{string2, CommonUtil.dump(throwable2, false), throwable2});
                } while ((throwable2 = throwable2.getCause()) != null);
                this.mdbError.saveAllRows();
                this.taMessage.setText(string);
            }
            catch (ModelException modelException) {
                this.debug(modelException);
            }
            this.mdbError.setInsertEnabled(false);
        }
    }

    protected void updateAnchors() {
        IFormLayout.IConstraints iConstraints;
        IFormLayout.IConstraints iConstraints2 = (IFormLayout.IConstraints)this.foMain.getConstraints(this.butOK);
        if (this.gpanDetails.isVisible()) {
            ((IFormLayout.IConstraints)this.foMain.getConstraints(this.taMessage)).setBottomAnchor(null);
            iConstraints2.setTopAnchor(this.foMain.createAnchor(((IFormLayout.IConstraints)this.foMain.getConstraints(this.taMessage)).getBottomAnchor(), 7));
            iConstraints2.setBottomAnchor(null);
            iConstraints = (IFormLayout.IConstraints)this.foMain.getConstraints(this.gpanDetails);
            iConstraints.setTopAnchor(this.foMain.createAnchor(((IFormLayout.IConstraints)this.foMain.getConstraints(this.butOK)).getBottomAnchor(), 5));
        } else {
            iConstraints2.setBottomAnchor(this.foMain.getBottomMarginAnchor());
            iConstraints2.setTopAnchor(null);
            ((IFormLayout.IConstraints)this.foMain.getConstraints(this.taMessage)).setBottomAnchor(this.foMain.createAnchor(iConstraints2.getTopAnchor(), -7));
        }
        iConstraints = (IFormLayout.IConstraints)this.foMain.getConstraints(this.butDetails);
        iConstraints.setTopAnchor(iConstraints2.getTopAnchor());
        iConstraints.setBottomAnchor(iConstraints2.getBottomAnchor());
    }

    protected ITextArea getTextArea() {
        return this.taMessage;
    }

    protected IButton getOKButton() {
        return this.butOK;
    }

    protected IToggleButton getDetailsButton() {
        return this.butDetails;
    }

    protected UIGroupPanel getDetailsGroupPanel() {
        return this.gpanDetails;
    }

    public String getMessage() {
        return this.taMessage.getText();
    }

    public Throwable[] getErrors() {
        try {
            Throwable[] throwableArray = new Throwable[this.mdbError.getRowCount()];
            int n = this.mdbError.getRowCount();
            for (int i = 0; i < n; ++i) {
                throwableArray[i] = (Throwable)this.mdbError.getDataRow(i).getValue("CAUSE");
            }
            return throwableArray;
        }
        catch (ModelException modelException) {
            throw new RuntimeException(modelException);
        }
    }

    public void doOk(UIActionEvent uIActionEvent) {
        this.dispose();
    }

    public void doDetails(UIActionEvent uIActionEvent) {
        IToggleButton iToggleButton = (IToggleButton)uIActionEvent.getSource();
        this.gpanDetails.setVisible(iToggleButton.isSelected());
        this.updateAnchors();
        this.pack();
    }
}

