/*
 * Decompiled with CFR 0.152.
 */
package com.sibvisions.rad.application;

import com.sibvisions.util.type.FileUtil;
import com.sibvisions.util.type.ImageUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import javax.rad.application.ILauncher;
import javax.rad.genui.UIColor;
import javax.rad.genui.celleditor.UIChoiceCellEditor;
import javax.rad.genui.celleditor.UIImageViewer;
import javax.rad.genui.celleditor.UINumberCellEditor;
import javax.rad.genui.celleditor.UITextCellEditor;
import javax.rad.genui.control.UICellFormat;
import javax.rad.io.IFileHandle;
import javax.rad.model.IDataBook;
import javax.rad.model.IRowDefinition;
import javax.rad.model.ModelException;
import javax.rad.model.datatype.BinaryDataType;
import javax.rad.model.ui.IControl;
import javax.rad.model.ui.IEditorControl;
import javax.rad.model.ui.ITableControl;
import javax.rad.ui.IComponent;
import javax.rad.ui.IImage;

public class ApplicationUtil {
    public static final UICellFormat RED_CELL = new UICellFormat(UIColor.red);
    public static final UICellFormat ORANGE_CELL = new UICellFormat(UIColor.orange);
    public static final UICellFormat YELLOW_CELL = new UICellFormat(UIColor.yellow);
    public static final UICellFormat BLUE_CELL = new UICellFormat(new UIColor(50, 150, 255));
    public static final UICellFormat GREEN_CELL = new UICellFormat(UIColor.green);
    public static final UITextCellEditor PASSWORD_EDITOR = new UITextCellEditor("text/plain;password");
    public static final UITextCellEditor CENTERED_TEXT_EDITOR = new UITextCellEditor(1);
    public static final UINumberCellEditor CENTERED_NUMBER_EDITOR = new UINumberCellEditor(1);
    public static final UITextCellEditor MULTILINE_EDITOR = new UITextCellEditor("text/plain;wrappedmultiline");
    public static final UIChoiceCellEditor YESNO_EDITOR = ApplicationUtil.createYNChoiceCellEditor();
    public static final UIChoiceCellEditor TRUEFALSE_EDITOR = ApplicationUtil.createTFChoiceCellEditor();
    public static final UIImageViewer IMAGE_VIEWER = new UIImageViewer();

    protected ApplicationUtil() {
    }

    public static UIChoiceCellEditor createTFChoiceCellEditor() {
        return new UIChoiceCellEditor(new Object[]{Boolean.TRUE, Boolean.FALSE}, new String[]{"CHECK_YES_SMALL", "CHECK_SMALL"}, "CHECK_SMALL");
    }

    public static UIChoiceCellEditor createYNChoiceCellEditor() {
        return new UIChoiceCellEditor(new Object[]{"Y", "N"}, new String[]{"CHECK_YES_SMALL", "CHECK_SMALL"}, "CHECK_SMALL");
    }

    public static String[] getAllVisibleColumns(IDataBook iDataBook) {
        IRowDefinition iRowDefinition = iDataBook.getRowDefinition();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        IControl[] iControlArray = iDataBook.getControls();
        for (int i = 0; i < iControlArray.length; ++i) {
            String[] stringArray;
            IControl iControl = iControlArray[i];
            if (iControl instanceof IEditorControl) {
                try {
                    stringArray = ((IEditorControl)iControl).getColumnName();
                    if (arrayList.contains(stringArray) || iRowDefinition.getColumnDefinition((String)stringArray).getDataType() instanceof BinaryDataType) continue;
                    arrayList.add(stringArray);
                }
                catch (Exception exception) {}
                continue;
            }
            if (!(iControl instanceof ITableControl)) continue;
            stringArray = iDataBook.getRowDefinition().getColumnView(ITableControl.class).getColumnNames();
            for (int j = 0; j < stringArray.length; ++j) {
                String string = stringArray[j];
                try {
                    if (arrayList.contains(string) || iRowDefinition.getColumnDefinition(string).getDataType() instanceof BinaryDataType) continue;
                    arrayList.add(string);
                    continue;
                }
                catch (ModelException modelException) {
                    // empty catch block
                }
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static ILauncher getLauncher(IComponent iComponent) {
        IComponent iComponent2;
        for (iComponent2 = iComponent; iComponent2 != null && !(iComponent2 instanceof ILauncher); iComponent2 = iComponent2.getParent()) {
        }
        return (ILauncher)iComponent2;
    }

    public static byte[] scaleImage(IFileHandle iFileHandle, int n, int n2) throws IOException {
        String string = FileUtil.getExtension(iFileHandle.getFileName().toLowerCase());
        if ("png".equals(string) || "jpg".equals(string) || "gif".equals(string)) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ImageUtil.createScaledImage(iFileHandle.getInputStream(), n, n2, true, byteArrayOutputStream, string);
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        throw new IOException("Image format '" + string + "' not supported. Use 'png', 'jpg' or 'gif'!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getImageData(IImage iImage) throws IOException {
        if (iImage == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            iImage.saveAs(byteArrayOutputStream, IImage.ImageType.PNG);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        finally {
            try {
                byteArrayOutputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    public static int convertAlignment(String string) {
        if (string != null) {
            String string2 = string.toLowerCase();
            if ("left".equals(string2)) {
                return 0;
            }
            if ("right".equals(string2)) {
                return 2;
            }
            if ("top".equals(string2)) {
                return 0;
            }
            if ("bottom".equals(string2)) {
                return 2;
            }
            if ("stretch".equals(string2)) {
                return 3;
            }
        }
        return 1;
    }
}

