/*
 * Copyright 2011 SIB Visions GmbH
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 *
 * History
 *
 * 30.03.2011 - [JR] - creation
 */
package javax.rad.model.ui;

import javax.rad.util.TranslationMap;

/**
 * The <code>ITranslatable</code> is the interface for text oriented objects which needs
 * translation support.
 * 
 * @author Ren Jahn
 */
public interface ITranslatable
{
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// Method definitions
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

	/**
	 * Sets the possible translations for this <code>UIComponent</code>.
	 * 
	 * @param pTranslation the translation mapping
	 */
	public void setTranslation(TranslationMap pTranslation);
	
	/**
	 * Gets the possible translation mapping for this <code>UIComponent</code>.
	 * 
	 * @return the translation mappint
	 */
	public TranslationMap getTranslation();

}	// ITranslatable
