/*
 * Copyright 2009 SIB Visions GmbH
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 *
 * History
 * 
 * 25.06.2009 - [HM] - creation
 */
package javax.rad.model.event;

import javax.rad.model.ModelException;
import javax.rad.util.EventHandler;

/**
 * The <code>ModelEventHandler</code> is a <code>EventHandler</code> that 
 * handles Events, and throws ModelExceptions. 
 * 
 * @author Martin Handsteiner
 * 
 * @param <L> the Listener type
 */
public class ModelEventHandler<L> extends EventHandler<L>
{
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// Initialization
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

	/**
	 * Constructs a new EventHandler, the listener type may only have 1 method.
	 *  
	 * @param pListenerType the listener type interface.
	 */
	public ModelEventHandler(Class<L> pListenerType)
	{
		super(pListenerType);
	}
	
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// Overwritten
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Object dispatchEvent(Object... pEventParameter) throws ModelException
	{
		try
		{
			return super.dispatchEvent(pEventParameter);
		}
		catch (RuntimeException pRuntimeException)
		{
			throw pRuntimeException;
		}
		catch (ModelException pModelException)
		{
			throw pModelException;
		}
		catch (Throwable pThrowable)
		{
			throw new ModelException("Exception in Listenermethod!", pThrowable);
		}
	}
	
}	// ModelEventHandler
