/*
 * Copyright 2009 SIB Visions GmbH
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 *
 * History
 *
 * 02.03.2009 - [HM] - creation
 * 24.10.2012 - [JR] - #604: added constructor
 */
package javax.rad.genui.control;

import javax.rad.genui.UIComponent;
import javax.rad.genui.UIFactoryManager;
import javax.rad.model.IDataBook;
import javax.rad.model.ModelException;
import javax.rad.ui.control.ICellFormatter;
import javax.rad.ui.control.INodeFormatter;
import javax.rad.ui.control.ITree;

/**
 * Platform and technology independent Tree.
 * It is designed for use with AWT, Swing, SWT, JSP, JSF, ... .
 * 
 * @author Martin Handsteiner
 */
public class UITree extends UIComponent<ITree> 
                 implements ITree
{
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// Initialization
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	  
    /**
     * Creates a new instance of <code>UITree</code>.
     *
     * @see ITree
     */
	public UITree()
	{
		super(UIFactoryManager.getFactory().createTree());
	}

    /**
     * Creates a new instance of <code>UITree</code> with the given
     * tree.
     *
     * @param pTree the tree
     * @see ITree
     */
	protected UITree(ITree pTree)
	{
		super(pTree);
	}
	
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // Interface Implementation
    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

	/**
	 * {@inheritDoc}
	 */
    public IDataBook[] getDataBooks()
    {
    	return uiResource.getDataBooks();
    }

	/**
	 * {@inheritDoc}
	 */
    public void setDataBooks(IDataBook... pDataBooks)
    {
    	uiResource.setDataBooks(pDataBooks);
    }

	/**
	 * {@inheritDoc}
	 */
	public boolean isDetectEndNode()
	{
		return uiResource.isDetectEndNode();
	}

	/**
	 * {@inheritDoc}
	 */
	public void setDetectEndNode(boolean pDetectEndNode)
	{
		uiResource.setDetectEndNode(pDetectEndNode);
	}

	/**
	 * {@inheritDoc}
	 */
	public boolean isEditable()
	{
		return uiResource.isEditable();
	}

	/**
	 * {@inheritDoc}
	 */
	public void setEditable(boolean pEditable)
	{
		uiResource.setEditable(pEditable);
	}

	/**
	 * {@inheritDoc}
	 */
	public void notifyRepaint() 
	{
    	uiResource.notifyRepaint();
	}

	/**
	 * {@inheritDoc}
	 */
	public void startEditing() 
	{
    	uiResource.startEditing();
	}
	
	/**
	 * {@inheritDoc}
	 */
	public void saveEditing() throws ModelException 
	{
    	uiResource.saveEditing();
	}
	
	/**
	 * {@inheritDoc}
	 */
	public void cancelEditing() 
	{
    	uiResource.cancelEditing();
	}
    
	/**
	 * {@inheritDoc}
	 */
	public ICellFormatter getCellFormatter()
	{
		return uiResource.getCellFormatter();
	}
	
	/**
	 * {@inheritDoc}
	 */
	public void setCellFormatter(ICellFormatter pCellFormatter)
	{
		uiResource.setCellFormatter(pCellFormatter);
	}
	
    /**
     * Sets the cell formatter.
     *
	 * @param pCellFormatter the cell formatter.
	 * @param pMethodName the method name.
     */
	public void setCellFormatter(Object pCellFormatter, String pMethodName)
	{
		uiResource.setCellFormatter(UIComponent.createCellFormatter(pCellFormatter, pMethodName));
	}
	
	/**
	 * {@inheritDoc}
	 */
	public INodeFormatter getNodeFormatter()
	{
		return uiResource.getNodeFormatter();
	}
	
	/**
	 * {@inheritDoc}
	 */
	public void setNodeFormatter(INodeFormatter pNodeFormatter)
	{
		uiResource.setNodeFormatter(pNodeFormatter);
	}
	
    /**
     * Sets the node formatter.
     *
	 * @param pNodeFormatter the node formatter.
	 * @param pMethodName the method name.
     */
	public void setNodeFormatter(Object pNodeFormatter, String pMethodName)
	{
		uiResource.setNodeFormatter(UIComponent.createNodeFormatter(pNodeFormatter, pMethodName));
	}
	
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// Overwritten methods
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public void updateTranslation()
	{
		boolean bChanged = isTranslationChanged();

		super.updateTranslation();
		
		if (bChanged)
		{
			uiResource.setTranslation(getCurrentTranslation());
		}
	}	
	
}	// UITree
