/*
 * Copyright 2009 SIB Visions GmbH
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 *
 * History
 *
 * 16.11.2008 - [HM] - creation
 * 24.10.2012 - [JR] - #604: added constructor
 */
package javax.rad.genui.control;

import javax.rad.genui.UIComponent;
import javax.rad.genui.UIFactoryManager;
import javax.rad.model.ColumnView;
import javax.rad.model.IDataBook;
import javax.rad.model.ModelException;
import javax.rad.ui.control.ICellFormatter;
import javax.rad.ui.control.ITable;

/**
 * Platform and technology independent Table.
 * It is designed for use with AWT, Swing, SWT, JSP, JSF, ... .
 * 
 * @author Martin Handsteiner
 * @see	javax.swing.JTable
 */
public class UITable extends UIComponent<ITable> 
                     implements ITable
{
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// Initialization
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	  
    /**
     * Creates a new instance of <code>UITable</code>.
     *
     * @see ITable
     */
	public UITable()
	{
		this(UIFactoryManager.getFactory().createTable());
	}

    /**
     * Creates a new instance of <code>UITable</code> with the given
     * table.
     *
     * @param pTable the table
     * @see ITable
     */
	protected UITable(ITable pTable)
	{
		super(pTable);

		setMaximumSize(800, 600);
	}
	
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // Interface Implementation
    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

	/**
	 * {@inheritDoc}
	 */
    public IDataBook getDataBook()
    {
    	return uiResource.getDataBook();
    }

	/**
	 * {@inheritDoc}
	 */
    public void setDataBook(IDataBook pDataBook)
    {
    	uiResource.setDataBook(pDataBook);
    }
	
	/**
	 * {@inheritDoc}
	 */
    public ColumnView getColumnView()
    {
    	return uiResource.getColumnView();
    }

	/**
	 * {@inheritDoc}
	 */
    public void setColumnView(ColumnView pColumnView)
    {
    	uiResource.setColumnView(pColumnView);
    }
	
	/**
	 * {@inheritDoc}
	 */
    public boolean isAutoResize()
    {
    	return uiResource.isAutoResize();
    }
    
	/**
	 * {@inheritDoc}
	 */
    public void setAutoResize(boolean pAutoResize)
    {
    	uiResource.setAutoResize(pAutoResize);
    }
    
	/**
	 * {@inheritDoc}
	 */
	public boolean isTableHeaderVisible()
	{
		return uiResource.isTableHeaderVisible();
	}

	/**
	 * {@inheritDoc}
	 */
	public void setTableHeaderVisible(boolean pTableHeaderVisible)
	{
		uiResource.setTableHeaderVisible(pTableHeaderVisible);
	}

	/**
	 * {@inheritDoc}
	 */
    public boolean isSortOnHeaderEnabled()
	{
		return uiResource.isSortOnHeaderEnabled();
	}

	/**
	 * {@inheritDoc}
	 */
    public void setSortOnHeaderEnabled(boolean pSortOnHeaderEnabled)
	{
		uiResource.setSortOnHeaderEnabled(pSortOnHeaderEnabled);
	}

	/**
	 * {@inheritDoc}
	 */
	public void notifyRepaint() 
	{
    	uiResource.notifyRepaint();
	}

	/**
	 * {@inheritDoc}
	 */
	public void startEditing() 
	{
    	uiResource.startEditing();
	}
	
	/**
	 * {@inheritDoc}
	 */
	public void saveEditing() throws ModelException 
	{
    	uiResource.saveEditing();
	}
	
	/**
	 * {@inheritDoc}
	 */
	public void cancelEditing() 
	{
    	uiResource.cancelEditing();
	}

	/**
	 * {@inheritDoc}
	 */
	public ICellFormatter getCellFormatter()
	{
		return uiResource.getCellFormatter();
	}
	
	/**
	 * {@inheritDoc}
	 */
	public void setCellFormatter(ICellFormatter pCellFormatter)
	{
		uiResource.setCellFormatter(pCellFormatter);
	}
	
    /**
     * Sets the cell formatter.
     *
	 * @param pCellFormatter the cell formatter.
	 * @param pMethodName the method name.
     */
	public void setCellFormatter(Object pCellFormatter, String pMethodName)
	{
		uiResource.setCellFormatter(UIComponent.createCellFormatter(pCellFormatter, pMethodName));
	}
	
	/**
	 * {@inheritDoc}
	 */
	public boolean isEditable()
	{
		return uiResource.isEditable();
	}

	/**
	 * {@inheritDoc}
	 */
	public void setEditable(boolean pEditable)
	{
		uiResource.setEditable(pEditable);
	}

	/**
	 * {@inheritDoc}
	 */
	public boolean isShowSelection()
	{
		return uiResource.isShowSelection();
	}

	/**
	 * {@inheritDoc}
	 */
	public void setShowSelection(boolean pShowSelection)
	{
		uiResource.setShowSelection(pShowSelection);
	}

	/**
	 * {@inheritDoc}
	 */
	public boolean isShowFocusRect()
	{
		return uiResource.isShowFocusRect();
	}

	/**
	 * {@inheritDoc}
	 */
	public void setShowFocusRect(boolean pShowFocusRect)
	{
		uiResource.setShowFocusRect(pShowFocusRect);
	}

	/**
	 * {@inheritDoc}
	 */
	public boolean isShowVerticalLines()
	{
		return uiResource.isShowVerticalLines();
	}

	/**
	 * {@inheritDoc}
	 */
	public void setShowVerticalLines(boolean pShowVerticalLines)
	{
		uiResource.setShowVerticalLines(pShowVerticalLines);
	}

	/**
	 * {@inheritDoc}
	 */
	public boolean isShowHorizontalLines()
	{
		return uiResource.isShowHorizontalLines();
	}

	/**
	 * {@inheritDoc}
	 */
	public void setShowHorizontalLines(boolean pShowHorizontalLines)
	{
		uiResource.setShowHorizontalLines(pShowHorizontalLines);
	}
	
	/**
	 * Gets if the horizontal lines or vertical lines are shown.
	 * @return true, the horizontal lines or vertical lines are shown.
	 */
	public boolean isShowGridLines()
	{
		return uiResource.isShowHorizontalLines() || uiResource.isShowVerticalLines();
	}

	/**
	 * Sets if the horizontal lines or vertical lines are shown.
	 * @param pShowVerticalLines true, the horizontal lines or vertical lines are shown.
	 */
	public void setShowGridLines(boolean pShowVerticalLines)
	{
		uiResource.setShowHorizontalLines(pShowVerticalLines);
		uiResource.setShowVerticalLines(pShowVerticalLines);
	}
	
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// Overwritten methods
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public void updateTranslation()
	{
		boolean bChanged = isTranslationChanged();

		super.updateTranslation();
		
		if (bChanged)
		{
			uiResource.setTranslation(getCurrentTranslation());
		}
	}	
	
}	// UITable
