/*
 * Copyright 2009 SIB Visions GmbH
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 *
 * History
 *
 * 17.11.2008 - [HM] - creation
 * 24.10.2012 - [JR] - #604: added constructor
 */
package javax.rad.genui.celleditor;

import javax.rad.genui.UIFactoryManager;
import javax.rad.model.condition.ICondition;
import javax.rad.model.reference.ColumnMapping;
import javax.rad.model.reference.ReferenceDefinition;
import javax.rad.ui.IDimension;
import javax.rad.ui.celleditor.ILinkedCellEditor;

/**
 * Platform and technology independent linked editor.
 * It is designed for use with AWT, Swing, SWT, JSP, JSF, ... .
 * 
 * @author Martin Handsteiner
 */
public class UILinkedCellEditor extends UICellEditor<ILinkedCellEditor> 
                                implements ILinkedCellEditor
{
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// Initialization
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	  
    /**
     * Creates a new instance of <code>UILinkedCellEditor</code>.
     *
     * @see ILinkedCellEditor
     */
	public UILinkedCellEditor()
	{
		super(UIFactoryManager.getFactory().createLinkedCellEditor());
	}

    /**
     * Creates a new instance of <code>UILinkedCellEditor</code> with the given 
     * linked cell editor.
     * 
     * @param pEditor the linked cell editor
     * @see ILinkedCellEditor
     */
	protected UILinkedCellEditor(ILinkedCellEditor pEditor)
	{
		super(pEditor);
	}
	
    /**
     * Creates a new instance of <code>UILinkedCellEditor</code> with LinkReference.
     *
     * @param pReferenceDefinition the LinkReference.
     * @see ILinkedCellEditor
     */
	public UILinkedCellEditor(ReferenceDefinition pReferenceDefinition)
	{
		super(UIFactoryManager.getFactory().createLinkedCellEditor());
		
		ceResource.setLinkReference(pReferenceDefinition);
	}

	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// Interface implementation
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

	/**
	 * {@inheritDoc}
	 */
	public ReferenceDefinition getLinkReference()
	{
		return ceResource.getLinkReference();
	}

	/**
	 * {@inheritDoc}
	 */
	public void setLinkReference(ReferenceDefinition pReferenceDefinition)
	{
		ceResource.setLinkReference(pReferenceDefinition);
	}

	/**
	 * {@inheritDoc}
	 */
	public ICondition getAdditionalCondition()
	{
		return ceResource.getAdditionalCondition();
	}

	/**
	 * {@inheritDoc}
	 */
	public void setAdditionalCondition(ICondition pCondition)
	{
		ceResource.setAdditionalCondition(pCondition);
	}

	/**
	 * {@inheritDoc}
	 */
	public ColumnMapping getSearchColumnMapping()
	{
		return ceResource.getSearchColumnMapping();
	}

	/**
	 * {@inheritDoc}
	 */
	public void setSearchColumnMapping(ColumnMapping pSearchColumnNames)
	{
		ceResource.setSearchColumnMapping(pSearchColumnNames);
	}
	
	/**
	 * {@inheritDoc}
	 */
	public boolean isSortByColumnName()
	{
		return ceResource.isSortByColumnName();
	}

	/**
	 * {@inheritDoc}
	 */
	public void setSortByColumnName(boolean pSortByColumnName)
	{
		ceResource.setSortByColumnName(pSortByColumnName);
	}

	/**
	 * {@inheritDoc}
	 */
	public boolean isTableReadonly()
	{
		return ceResource.isTableReadonly();
	}

	/**
	 * {@inheritDoc}
	 */
	public void setTableReadonly(boolean pTableReadonly)
	{
		ceResource.setTableReadonly(pTableReadonly);
	}

	/**
	 * Gets whether the table header is visible.
	 *
	 * @return whether the table header is visible.
	 */
	public boolean isTableHeaderVisible()
	{
		return ceResource.isTableHeaderVisible();
	}

	/**
	 * Sets the table header visible.
	 *
	 * @param pTableHeaderVisible the table header visible.
	 */
	public void setTableHeaderVisible(boolean pTableHeaderVisible)
	{
		ceResource.setTableHeaderVisible(pTableHeaderVisible);
	}

	/**
	 * {@inheritDoc}
	 */
	public boolean isValidationEnabled()
	{
		return ceResource.isValidationEnabled();
	}

	/**
	 * {@inheritDoc}
	 */
	public void setValidationEnabled(boolean pValidationEnabled)
	{
		ceResource.setValidationEnabled(pValidationEnabled);
	}
	
	/**
	 * {@inheritDoc}
	 */
	public IDimension getPopupSize()
	{
		return ceResource.getPopupSize();
	}
	
	/**
	 * {@inheritDoc}
	 */
	public void setPopupSize(IDimension pPopupSize)
	{
		ceResource.setPopupSize(pPopupSize);
	}

}	// UILinkedCellEditor
