/*
 * Copyright 2009 SIB Visions GmbH
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 *
 * History
 *
 * 01.10.2008 - [HM] - creation
 * 17.11.2008 - [RH] - clone() added, or/and bug fixed
 * 18.11.2008 - [RH] - class simplified
 */
package javax.rad.model.condition;

import java.io.Serializable;

/**
 * The <code>BaseCondition</code> is the default implementation of <code>ICondition</code>. It
 * offers the possibility to use the <code>Or</code> and <code>And</code> operator with other
 * conditions.
 * 
 * @author Roland Hrmann, Martin Handsteiner
 */
public abstract class BaseCondition implements ICondition, 
                                               Serializable, 
                                               Cloneable
{
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// Interface implementation
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	
	/**
	 * {@inheritDoc}
	 */
	public And and(ICondition pCondition) 
	{
		if (this instanceof And)
		{
			((And)this).add(pCondition);
			
			return (And)this;
		}
		else
		{
			And andCondition = new And(this, pCondition);
			
			return andCondition;
		}
	}

	/**
	 * {@inheritDoc}
	 */
	public Or or(ICondition pCondition) 
	{
		if (this instanceof Or)
		{
			((Or)this).add(pCondition);
			
			return (Or)this;
		}
		else
		{
			Or orCondition = new Or(this, pCondition);
			
			return orCondition;
		}
	}

	/**
	 * {@inheritDoc}
	 */
	public ICondition clone()
	{
		try 
		{
			return (ICondition)super.clone();
		}
		catch (CloneNotSupportedException cloneNotSupportedException)
		{
			// should not occur!
			return null;
		}
	}
		
}	// BaseCondition
