/*
 * Copyright 2009 SIB Visions GmbH
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 *
 * History
 *
 * 17.11.2008 - [HM] - creation
 * 24.10.2012 - [JR] - #604: added constructor
 */
package javax.rad.genui.menu;

import javax.rad.genui.UIComponent;
import javax.rad.genui.UIContainer;
import javax.rad.genui.UIFactoryManager;
import javax.rad.genui.component.UICustomComponent;
import javax.rad.ui.IComponent;
import javax.rad.ui.menu.IPopupMenu;

/**
 * Platform and technology independent popup menu.
 * It is designed for use with AWT, Swing, SWT, JSP, JSF, ... .
 * 
 * @author Martin Handsteiner
 */
public class UIPopupMenu extends UIContainer<IPopupMenu> 
                         implements IPopupMenu
{
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// Initialization
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	  
    /**
     * Creates a new instance of <code>UIPopupMenu</code>.
     *
     * @see IPopupMenu
     */
	public UIPopupMenu()
	{
		super(UIFactoryManager.getFactory().createPopupMenu());
	}

    /**
     * Creates a new instance of <code>UIPopupMenu</code> with the given
     * popup menu.
     *
     * @param pMenu the popup menu
     * @see IPopupMenu
     */
	protected UIPopupMenu(IPopupMenu pMenu)
	{
		super(pMenu);
	}

	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// Interface implementation
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

	/**
	 * {@inheritDoc}
	 */
	public void addSeparator()
    {
    	addSeparator(-1);
    }

	/**
	 * {@inheritDoc}
	 */
    public void addSeparator(int pIndex)
    {
    	uiResource.addSeparator(pIndex);

    	UIComponent separator;
    	if (pIndex < 0)
    	{
    		separator = new UICustomComponent(uiResource.getComponent(getComponentCount()));
        	components.add(separator);
    	}
    	else
    	{
    		separator = new UICustomComponent(uiResource.getComponent(pIndex));
        	components.add(pIndex, separator);
    	}

    	separator.setParent(this);
    }

	/**
	 * {@inheritDoc}
	 */
    public void show(IComponent pOrigin, int pX, int pY)
    {
    	uiResource.show(pOrigin, pX, pY);
    }
    
}	// UIPopupMenu
