/*
 * Copyright 2009 SIB Visions GmbH
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 *
 * History
 * 
 * 03.06.2009 - [JR] - creation
 * 06.10.2009 - [JR] - set/getRegistryKey implemented
 */
package javax.rad.application.genui;

import javax.rad.application.IFileHandleReceiver;
import javax.rad.application.ILauncher;
import javax.rad.genui.container.AbstractFrame;
import javax.rad.genui.layout.UIBorderLayout;
import javax.rad.io.IFileHandle;
import javax.rad.ui.IRectangle;
import javax.rad.util.EventHandler;

/**
 * The <code>UILauncher</code> is an {@link AbstractFrame} extension. It will be
 * used for platform and technology dependent {@link ILauncher} implementations.
 * 
 * @author Ren Jahn
 */
public class UILauncher extends AbstractFrame<ILauncher> 
                        implements ILauncher
{
    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// Class members
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

	/** The file handle receiver provider. */
	private static EventHandler<IFileHandleReceiver> fileHandleReceiverProvider = new EventHandler<IFileHandleReceiver>(IFileHandleReceiver.class);

	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// Initialization
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

	/**
	 * Creates a new instance of UILauncher with an {@link ILauncher} implementation.
	 * 
	 * @param pLauncher the {@link ILauncher}
	 */
	public UILauncher(ILauncher pLauncher)
	{
		super(pLauncher);
		
		setLayout(new UIBorderLayout());
	}
	
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// Interface implementation
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	
	/**
	 * {@inheritDoc}
	 */
	public void getFileHandle(IFileHandleReceiver pFileHandleReceiver, String pTitle) throws Throwable
	{
		uiResource.getFileHandle(pFileHandleReceiver, pTitle);
	}

	/**
	 * {@inheritDoc}
	 */
	public String getParameter(String pName)
	{
		return uiResource.getParameter(pName);
	}

	/**
	 * {@inheritDoc}
	 */
	public void saveFileHandle(IFileHandle pFileHandle, String pTitle) throws Throwable
	{
		uiResource.saveFileHandle(pFileHandle, pTitle);
	}

	/**
	 * {@inheritDoc}
	 */
	public void setParameter(String pName, String pValue)
	{
		uiResource.setParameter(pName, pValue);
	}

	/**
	 * {@inheritDoc}
	 */
	public void showDocument(String pDocumentName, IRectangle pBounds, String pTarget) throws Throwable
	{
		uiResource.showDocument(pDocumentName, pBounds, pTarget);
	}

	/**
	 * {@inheritDoc}
	 */
	public void showFileHandle(IFileHandle pFileHandle, IRectangle pBounds, String pTarget) throws Throwable
	{
		uiResource.showFileHandle(pFileHandle, pBounds, pTarget);
	}

	/**
	 * {@inheritDoc}
	 */
	public void showFileHandle(IFileHandle pFileHandle) throws Throwable
	{
		uiResource.showFileHandle(pFileHandle);
	}

    /**
     * {@inheritDoc}
     */
    public void cancelPendingThreads()
    {
    	uiResource.cancelPendingThreads();
    }
	
	/**
	 * {@inheritDoc}
	 */
	public void handleException(Throwable pThrowable)
	{
		uiResource.handleException(pThrowable);
	}
	
	/**
	 * {@inheritDoc}
	 */
    public void setRegistryKey(String pKey, String pValue)
    {
    	uiResource.setRegistryKey(pKey, pValue);
    }
    
	/**
	 * {@inheritDoc}
	 */
    public String getRegistryKey(String pKey)
    {
    	return uiResource.getRegistryKey(pKey); 
    }

	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// User-defined methods
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	
    /**
     * Technology independent saveFileHandle.
     * A file chooser dialog should occur. This Function returns immediate. 
     * 
     * @param pFileHandle the IFileHandle to save.
     * @throws Throwable if an error occurs during saving the file.
     */
	public void saveFileHandle(IFileHandle pFileHandle) throws Throwable
	{
		uiResource.saveFileHandle(pFileHandle, null);
	}

    /**
     * Technology independent getFileHandle.
     * A file chooser dialog should occur, and as result this function informs the IFileHandle receiver. 
     * 
     * @param pFileHandleReceiver the IFileHandle receiver that should receive the file.
     * @throws Throwable if an error occurs during getting the file.
     */
	public void getFileHandle(IFileHandleReceiver pFileHandleReceiver) throws Throwable
	{
		getFileHandle(pFileHandleReceiver, null);
	}

    /**
     * Technology independent getFileHandle.
     * A file chooser dialog should occur, and as result this function informs the IFileHandle receiver. 
     * 
     * @param pFileHandleReceiver the IFileHandle receiver that should receive the file.
     * @param pMethodName the method that is invoked.
     * @param pTitle the title.
     * @throws Throwable if an error occurs during getting the file.
     */
	public void getFileHandle(Object pFileHandleReceiver, String pMethodName, String pTitle) throws Throwable
	{
		getFileHandle(createFileHandleReceiver(pFileHandleReceiver, pMethodName), pTitle);
	}

    /**
     * Technology independent getFileHandle.
     * A file chooser dialog should occur, and as result this function informs the IFileHandle receiver. 
     * 
     * @param pFileHandleReceiver the IFileHandle receiver that should receive the file.
     * @param pMethodName the method that is invoked.
     * @throws Throwable if an error occurs during getting the file.
     */
	public void getFileHandle(Object pFileHandleReceiver, String pMethodName) throws Throwable
	{
		getFileHandle(pFileHandleReceiver, pMethodName, null);
	}

    /**
     * Creates a file handle receiver instance with the given object and method name.
     * @param pFileHandleReceiver the object.
     * @param pMethodName the method name.
     * @return the file handle receiver.
     */
	public static IFileHandleReceiver createFileHandleReceiver(Object pFileHandleReceiver, String pMethodName)
	{
		return fileHandleReceiverProvider.createListener(pFileHandleReceiver, pMethodName);
	}
	
}	// UILauncher
