/*
 * Copyright 2009 SIB Visions GmbH
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 *
 * History
 *
 * 20.11.2008 - [HM] - creation
 * 28.01.2009 - [JR] - getApplication returns IWorkScreenApplication instead of IApplication
 */
package javax.rad.application;

/**
 * Platform and technology independent work screen definition.
 * It is designed for use with AWT, Swing, SWT, JSP, JSF, ... .
 * 
 * @author Martin Handsteiner
 */
public interface IWorkScreen extends IContent,
									 IMessageConstants
{
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// Method definitions
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	
	/**
	 * Gets the main application of this work-screen.
	 * 
	 * @return the main application base
	 */
	public IWorkScreenApplication getApplication();

	/**
	 * Saves the workscreen changes.
	 * 
	 * @throws Exception if the save process failed
	 */
	public void save() throws Exception;
	
	/**
	 * Reloads the workscreen and discard changes.
	 * 
	 * @throws Exception if the save process failed
	 */
	public void reload() throws Exception;
	
	/**
	 * Returns the modal state of this workscreen.
	 * 
	 * @return <code>true</code> if this workscreen should be modal, otherwise <code>false</code>
	 */
	public boolean isModal();
	
	/**
	 * Sets whether this workscreen should be modal.
	 * 
	 * @param pModal <code>true</code> if this workscreen should be modal, otherwise <code>false</code>
	 */
	public void setModal(boolean pModal);
	
}	// IWorkScreen
