/*
 * Copyright 2009 SIB Visions GmbH
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 *
 * History
 *
 * 01.10.2008 - [HM] - creation
 * 24.11.2008 - [JR] - STRETCH constant included
 *                   - used JVxConstants instead of SwingConstants                   
 */
package com.sibvisions.rad.ui.swing.impl;

import javax.rad.ui.IColor;
import javax.rad.ui.IImage;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

import com.sibvisions.rad.ui.awt.impl.AwtContainer;

/**
 * The <code>SwingComponent</code> extends AwtComponent with setting the 
 * alignment.
 * 
 * @author Martin Handsteiner
 * @param <C> an instance of {@link JComponent}
 */
public class SwingComponent<C extends JComponent> extends AwtContainer<C>
{
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // Initialization
    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

	/**
	 * Creates a new instance of <code>SwingComponent</code>.
	 * 
	 * @param pJComponent An instance of {@link JComponent}
	 */
	public SwingComponent(C pJComponent)
	{
		super(pJComponent);
	}

	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // Overwritten methods
    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setBackground(IColor pBackground)
	{
		super.setBackground(pBackground);
		
		resource.setOpaque(pBackground != null);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setToolTipText(String pText)
	{
		resource.setToolTipText(pText);
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getToolTipText()
	{
		return resource.getToolTipText();
	}
	
	/**
	 * {@inheritDoc}
	 */
	public IImage capture(int pWidth, int pHeight)
	{
		return new SwingImage(new ImageIcon(createImage(resource, pWidth, pHeight)));
	}
	
}	// SwingComponent
