/*
 * Decompiled with CFR 0.152.
 */
package com.sianav.superflipcheckbox;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Checkable;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import com.sianav.superflipcheckbox.FlipAnimation;
import com.sianav.superflipcheckbox.R;

public class FlipCheckbox
extends FrameLayout
implements Checkable {
    private final int ANIMATION_DURATION = 500;
    private final int BASE_TEXT_SIZE = 30;
    private boolean mChecked;
    private int mCheckedDrawable;
    private int mUncheckedDrawable;
    private String mCheckedText;
    private String mUncheckedText;
    private int mCheckedSource;
    private int mUncheckedSource;
    private int mCheckedTint;
    private int mUncheckedBackgroundTint;
    private int mCheckedBackgroundTint;
    private int mUncheckedTint;
    private int mImageCheckedPadding;
    private int mImageUncheckedPadding;
    private View mCheckedView;
    private View mUncheckedView;
    private OnCheckedChangeListener mOnCheckedChangeListener;

    public FlipCheckbox(Context context) {
        super(context);
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlipCheckbox(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.FlipCheckbox, 0, 0);
        try {
            this.mCheckedDrawable = a.getResourceId(R.styleable.FlipCheckbox_checkedBackground, 0);
            this.mUncheckedDrawable = a.getResourceId(R.styleable.FlipCheckbox_uncheckedBackground, 0);
            this.mCheckedSource = a.getResourceId(R.styleable.FlipCheckbox_checkedSrc, 0);
            this.mUncheckedSource = a.getResourceId(R.styleable.FlipCheckbox_uncheckedSrc, 0);
            this.mCheckedTint = a.getColor(R.styleable.FlipCheckbox_checkedTint, 0);
            this.mUncheckedTint = a.getColor(R.styleable.FlipCheckbox_uncheckedTint, 0);
            this.mCheckedBackgroundTint = a.getColor(R.styleable.FlipCheckbox_checkedBackgroundTint, 0);
            this.mUncheckedBackgroundTint = a.getColor(R.styleable.FlipCheckbox_uncheckedBackgroundTint, 0);
            this.mChecked = a.getBoolean(R.styleable.FlipCheckbox_checked, false);
            this.mImageCheckedPadding = a.getLayoutDimension(R.styleable.FlipCheckbox_imageCheckedPadding, 0);
            this.mImageUncheckedPadding = a.getLayoutDimension(R.styleable.FlipCheckbox_imageUncheckedPadding, 0);
            this.mCheckedText = a.getString(R.styleable.FlipCheckbox_checkedText);
            this.mUncheckedText = a.getString(R.styleable.FlipCheckbox_uncheckedText);
        }
        finally {
            a.recycle();
        }
        this.init();
    }

    private void init() {
        this.setCheckedImage(this.mCheckedSource);
        this.setUncheckedImage(this.mUncheckedSource);
        if (this.mUncheckedText != null) {
            this.setUncheckedText(this.mUncheckedText);
        }
        if (this.mCheckedText != null) {
            this.setCheckedText(this.mCheckedText);
        }
        this.setClickable(true);
        this.setFocusable(true);
        if (this.mChecked) {
            this.mCheckedView.setVisibility(0);
            this.mUncheckedView.setVisibility(8);
        }
        this.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                FlipCheckbox.this.toggle();
            }
        });
    }

    private void check(int duration) {
        FlipAnimation flipAnimation = new FlipAnimation(this.mUncheckedView, this.mCheckedView, duration);
        this.startAnimation(flipAnimation);
    }

    private void uncheck(int duration) {
        FlipAnimation flipAnimation = new FlipAnimation(this.mUncheckedView, this.mCheckedView, duration);
        flipAnimation.reverse();
        this.startAnimation(flipAnimation);
    }

    public void setChecked(boolean checked, int animationDuration) {
        if (checked != this.mChecked) {
            if (checked) {
                this.check(animationDuration);
            } else {
                this.uncheck(animationDuration);
            }
        }
        this.mChecked = checked;
        if (this.mOnCheckedChangeListener != null) {
            this.mOnCheckedChangeListener.onCheckedChanged(this.mChecked);
        }
    }

    public boolean isChecked() {
        return this.mChecked;
    }

    public void setChecked(boolean checked) {
        if (checked != this.mChecked) {
            if (checked) {
                this.check(500);
            } else {
                this.uncheck(500);
            }
        }
        this.mChecked = checked;
        if (this.mOnCheckedChangeListener != null) {
            this.mOnCheckedChangeListener.onCheckedChanged(this.mChecked);
        }
    }

    public void setCheckedInmediate(boolean checked) {
        if (checked != this.mChecked) {
            if (checked) {
                this.check(500);
            } else {
                this.uncheck(500);
            }
        }
        this.mChecked = checked;
    }

    public void setCheckedInmediate(boolean checked, int animationDuration) {
        if (checked != this.mChecked) {
            if (checked) {
                this.check(animationDuration);
            } else {
                this.uncheck(animationDuration);
            }
        }
        this.mChecked = checked;
    }

    public void toggle() {
        this.setChecked(!this.mChecked);
    }

    public void setOnCheckedChangeListener(OnCheckedChangeListener onCheckedChangeListener) {
        this.mOnCheckedChangeListener = onCheckedChangeListener;
    }

    public View getCheckedView() {
        return this.mCheckedView;
    }

    public View getUncheckedView() {
        return this.mUncheckedView;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.mUncheckedView.setEnabled(enabled);
        this.mCheckedView.setEnabled(enabled);
    }

    public void setUncheckedImage(int resId) {
        boolean newView;
        int index = this.indexOfChild(this.mUncheckedView);
        boolean bl = newView = this.mUncheckedView == null || !(this.mUncheckedView instanceof ImageView);
        if (newView) {
            this.removeView(this.mUncheckedView);
            this.mUncheckedView = new ImageView(this.getContext());
        }
        ((ImageView)this.mUncheckedView).setImageResource(resId);
        ((ImageView)this.mUncheckedView).setColorFilter(this.mUncheckedTint);
        ((ImageView)this.mUncheckedView).setScaleType(ImageView.ScaleType.FIT_CENTER);
        this.mUncheckedView.setBackgroundResource(this.mUncheckedDrawable);
        this.mUncheckedView.setPadding(this.mImageUncheckedPadding, this.mImageUncheckedPadding, this.mImageUncheckedPadding, this.mImageUncheckedPadding);
        if (this.mUncheckedBackgroundTint != 0) {
            this.mUncheckedView.getBackground().setColorFilter(this.mUncheckedBackgroundTint, PorterDuff.Mode.SRC_IN);
        }
        if (newView) {
            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1);
            if (index != -1) {
                this.addView(this.mUncheckedView, index, (ViewGroup.LayoutParams)params);
            } else {
                this.addView(this.mUncheckedView, (ViewGroup.LayoutParams)params);
            }
        }
    }

    public void setCheckedImage(int resId) {
        boolean newView;
        int index = this.indexOfChild(this.mCheckedView);
        boolean bl = newView = this.mCheckedView == null || !(this.mCheckedView instanceof ImageView);
        if (newView) {
            this.removeView(this.mCheckedView);
            this.mCheckedView = new ImageView(this.getContext());
        }
        ((ImageView)this.mCheckedView).setImageResource(resId);
        ((ImageView)this.mCheckedView).setColorFilter(this.mCheckedTint);
        ((ImageView)this.mCheckedView).setScaleType(ImageView.ScaleType.FIT_CENTER);
        this.mCheckedView.setBackgroundResource(this.mCheckedDrawable);
        this.mCheckedView.setPadding(this.mImageCheckedPadding, this.mImageCheckedPadding, this.mImageCheckedPadding, this.mImageCheckedPadding);
        if (this.mCheckedBackgroundTint != 0) {
            this.mCheckedView.getBackground().setColorFilter(this.mCheckedBackgroundTint, PorterDuff.Mode.SRC_IN);
        }
        if (newView) {
            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1);
            if (index != -1) {
                this.addView(this.mCheckedView, index, (ViewGroup.LayoutParams)params);
            } else {
                this.addView(this.mCheckedView, (ViewGroup.LayoutParams)params);
            }
        }
    }

    public String getUncheckedText() {
        return this.mUncheckedText;
    }

    public void setUncheckedText(String text) {
        boolean newView;
        int index = this.indexOfChild(this.mUncheckedView);
        boolean bl = newView = this.mUncheckedView == null || !(this.mUncheckedView instanceof TextView);
        if (newView) {
            this.removeView(this.mUncheckedView);
            this.mUncheckedView = new TextView(this.getContext());
        }
        ((TextView)this.mUncheckedView).setTextColor(this.mUncheckedTint);
        ((TextView)this.mUncheckedView).setText((CharSequence)text);
        ((TextView)this.mUncheckedView).setGravity(17);
        ((TextView)this.mUncheckedView).setTextSize(30.0f);
        this.mUncheckedView.setBackgroundResource(this.mUncheckedDrawable);
        if (this.mUncheckedBackgroundTint != 0) {
            this.mUncheckedView.getBackground().setColorFilter(this.mUncheckedBackgroundTint, PorterDuff.Mode.SRC_IN);
        }
        if (newView) {
            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1);
            if (index != -1) {
                this.addView(this.mUncheckedView, index, (ViewGroup.LayoutParams)params);
            } else {
                this.addView(this.mUncheckedView, (ViewGroup.LayoutParams)params);
            }
        }
    }

    public String getCheckedText() {
        return this.mCheckedText;
    }

    public void setCheckedText(String text) {
        boolean newView;
        int index = this.indexOfChild(this.mCheckedView);
        boolean bl = newView = this.mCheckedView == null || !(this.mCheckedView instanceof TextView);
        if (newView) {
            if (this.mCheckedView != null) {
                this.removeView(this.mCheckedView);
            }
            this.mCheckedView = new TextView(this.getContext());
        }
        ((TextView)this.mCheckedView).setTextColor(this.mCheckedTint);
        ((TextView)this.mCheckedView).setText((CharSequence)text);
        ((TextView)this.mCheckedView).setGravity(17);
        ((TextView)this.mCheckedView).setTextSize(30.0f);
        this.mCheckedView.setBackgroundResource(this.mCheckedDrawable);
        if (this.mCheckedBackgroundTint != 0) {
            this.mCheckedView.getBackground().setColorFilter(this.mCheckedBackgroundTint, PorterDuff.Mode.SRC_IN);
        }
        if (newView) {
            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1);
            if (index != -1) {
                this.addView(this.mCheckedView, index, (ViewGroup.LayoutParams)params);
            } else {
                this.addView(this.mCheckedView, (ViewGroup.LayoutParams)params);
            }
        }
    }

    public int getCheckedTint() {
        return this.mCheckedTint;
    }

    public void setCheckedTint(int checkedTint) {
        this.mCheckedTint = checkedTint;
        this.init();
    }

    public int getUncheckedBackgroundTint() {
        return this.mUncheckedBackgroundTint;
    }

    public void setUncheckedBackgroundTint(int uncheckedBackgroundTint) {
        this.mUncheckedBackgroundTint = uncheckedBackgroundTint;
        this.init();
    }

    public int getCheckedBackgroundTint() {
        return this.mCheckedBackgroundTint;
    }

    public void setCheckedBackgroundTint(int checkedBackgroundTint) {
        this.mCheckedBackgroundTint = checkedBackgroundTint;
        this.init();
    }

    public int getUncheckedTint() {
        return this.mUncheckedTint;
    }

    public void setUncheckedTint(int uncheckedTint) {
        this.mUncheckedTint = uncheckedTint;
        this.init();
    }

    public int getImageCheckedPadding() {
        return this.mImageCheckedPadding;
    }

    public void setImageCheckedPadding(int imageCheckedPadding) {
        this.mImageCheckedPadding = imageCheckedPadding;
        this.init();
    }

    public int getImageUncheckedPadding() {
        return this.mImageUncheckedPadding;
    }

    public void setImageUncheckedPadding(int imageUncheckedPadding) {
        this.mImageUncheckedPadding = imageUncheckedPadding;
        this.init();
    }

    public static interface OnCheckedChangeListener {
        public void onCheckedChanged(boolean var1);
    }
}

