/*
 * Decompiled with CFR 0.152.
 */
package com.sianav.superflipcheckbox;

import android.graphics.Camera;
import android.graphics.Matrix;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.Transformation;

public class FlipAnimation
extends Animation {
    private Camera camera;
    private View fromView;
    private View toView;
    private float centerX;
    private float centerY;
    private boolean forward = true;

    public FlipAnimation(View fromView, View toView, int duration) {
        this.fromView = fromView;
        this.toView = toView;
        this.setDuration(duration);
        this.setFillAfter(false);
        this.setInterpolator((Interpolator)new AccelerateDecelerateInterpolator());
    }

    public void reverse() {
        this.forward = false;
        View switchView = this.toView;
        this.toView = this.fromView;
        this.fromView = switchView;
    }

    public void initialize(int width, int height, int parentWidth, int parentHeight) {
        super.initialize(width, height, parentWidth, parentHeight);
        this.centerX = width / 2;
        this.centerY = height / 2;
        this.camera = new Camera();
    }

    protected void applyTransformation(float interpolatedTime, Transformation t) {
        double radians = Math.PI * (double)interpolatedTime;
        float degrees = (float)(180.0 * radians / Math.PI);
        if (interpolatedTime >= 0.5f) {
            degrees -= 180.0f;
            this.fromView.setVisibility(8);
            this.toView.setVisibility(0);
        }
        if (this.forward) {
            degrees = -degrees;
        }
        Matrix matrix = t.getMatrix();
        this.camera.save();
        this.camera.rotateY(degrees);
        this.camera.getMatrix(matrix);
        this.camera.restore();
        matrix.preTranslate(-this.centerX, -this.centerY);
        matrix.postTranslate(this.centerX, this.centerY);
    }
}

