/*
 * Decompiled with CFR 0.152.
 */
package com.shuyu.gsyvideoplayer.cache;

import android.content.Context;
import android.net.Uri;
import com.shuyu.gsyvideoplayer.cache.ICacheManager;
import java.io.File;
import java.util.Map;
import tv.danmaku.ijk.media.exo2.ExoSourceManager;
import tv.danmaku.ijk.media.exo2.IjkExo2MediaPlayer;
import tv.danmaku.ijk.media.player.IMediaPlayer;

public class ExoPlayerCacheManager
implements ICacheManager {
    protected ExoSourceManager mExoSourceManager;

    @Override
    public void doCacheLogic(Context context, IMediaPlayer mediaPlayer, String url, Map<String, String> header, File cachePath) {
        if (!(mediaPlayer instanceof IjkExo2MediaPlayer)) {
            throw new UnsupportedOperationException("ExoPlayerCacheManager only support IjkExo2MediaPlayer");
        }
        IjkExo2MediaPlayer exoPlayer = (IjkExo2MediaPlayer)mediaPlayer;
        this.mExoSourceManager = exoPlayer.getExoHelper();
        exoPlayer.setCache(true);
        exoPlayer.setCacheDir(cachePath);
        exoPlayer.setDataSource(context, Uri.parse((String)url), header);
    }

    @Override
    public void clearCache(Context context, File cachePath, String url) {
        ExoSourceManager.clearCache((Context)context, (File)cachePath, (String)url);
    }

    @Override
    public void release() {
        this.mExoSourceManager = null;
    }

    @Override
    public boolean hadCached() {
        return this.mExoSourceManager != null && this.mExoSourceManager.hadCached();
    }

    @Override
    public boolean cachePreview(Context context, File cacheDir, String url) {
        return ExoSourceManager.cachePreView((Context)context, (File)cacheDir, (String)url);
    }

    @Override
    public void setCacheAvailableListener(ICacheManager.ICacheAvailableListener cacheAvailableListener) {
    }
}

