/*
 * Decompiled with CFR 0.152.
 */
package com.shuyu.gsyvideoplayer.player;

import android.content.Context;
import android.net.Uri;
import android.os.Message;
import android.view.Surface;
import com.shuyu.gsyvideoplayer.model.GSYModel;
import com.shuyu.gsyvideoplayer.model.VideoOptionModel;
import com.shuyu.gsyvideoplayer.player.IPlayerManager;
import java.util.List;
import tv.danmaku.ijk.media.exo2.IjkExo2MediaPlayer;
import tv.danmaku.ijk.media.player.IMediaPlayer;

public class EXO2PlayerManager
implements IPlayerManager {
    private IjkExo2MediaPlayer mediaPlayer;
    private Surface surface;

    @Override
    public IMediaPlayer getMediaPlayer() {
        return this.mediaPlayer;
    }

    @Override
    public void initVideoPlayer(Context context, Message msg, List<VideoOptionModel> optionModelList) {
        this.mediaPlayer = new IjkExo2MediaPlayer(context);
        this.mediaPlayer.setAudioStreamType(3);
        try {
            this.mediaPlayer.setDataSource(context, Uri.parse((String)((GSYModel)msg.obj).getUrl()), ((GSYModel)msg.obj).getMapHeadData());
            if (((GSYModel)msg.obj).getSpeed() != 1.0f && ((GSYModel)msg.obj).getSpeed() > 0.0f) {
                this.mediaPlayer.setSpeed(((GSYModel)msg.obj).getSpeed(), 1.0f);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void showDisplay(Message msg) {
        if (this.mediaPlayer == null) {
            return;
        }
        if (msg.obj == null) {
            this.mediaPlayer.setSurface(null);
            if (this.surface != null) {
                this.surface.release();
                this.surface = null;
            }
        } else {
            Surface holder;
            this.surface = holder = (Surface)msg.obj;
            this.mediaPlayer.setSurface(holder);
        }
    }

    @Override
    public void setSpeed(float speed, boolean soundTouch) {
        try {
            this.mediaPlayer.setSpeed(speed, 1.0f);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setNeedMute(boolean needMute) {
        if (this.mediaPlayer != null) {
            if (needMute) {
                this.mediaPlayer.setVolume(0.0f, 0.0f);
            } else {
                this.mediaPlayer.setVolume(1.0f, 1.0f);
            }
        }
    }

    @Override
    public void releaseSurface() {
    }

    @Override
    public void release() {
        if (this.mediaPlayer != null) {
            this.mediaPlayer.release();
        }
    }
}

