/*
 * Decompiled with CFR 0.152.
 */
package com.shuyu.gsyvideoplayer.player;

import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.os.Message;
import android.text.TextUtils;
import android.view.Surface;
import com.shuyu.gsyvideoplayer.model.GSYModel;
import com.shuyu.gsyvideoplayer.model.VideoOptionModel;
import com.shuyu.gsyvideoplayer.player.IPlayerManager;
import com.shuyu.gsyvideoplayer.utils.Debuger;
import com.shuyu.gsyvideoplayer.utils.GSYVideoType;
import com.shuyu.gsyvideoplayer.utils.RawDataSourceProvider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import tv.danmaku.ijk.media.player.IMediaPlayer;
import tv.danmaku.ijk.media.player.IjkLibLoader;
import tv.danmaku.ijk.media.player.IjkMediaPlayer;
import tv.danmaku.ijk.media.player.misc.IMediaDataSource;

public class IJKPlayerManager
implements IPlayerManager {
    private static int logLevel = 1;
    private static IjkLibLoader ijkLibLoader;
    private IjkMediaPlayer mediaPlayer;
    private List<VideoOptionModel> optionModelList;
    private Surface surface;

    @Override
    public IMediaPlayer getMediaPlayer() {
        return this.mediaPlayer;
    }

    @Override
    public void initVideoPlayer(Context context, Message msg, List<VideoOptionModel> optionModelList) {
        this.mediaPlayer = ijkLibLoader == null ? new IjkMediaPlayer() : new IjkMediaPlayer(ijkLibLoader);
        this.mediaPlayer.setAudioStreamType(3);
        this.mediaPlayer.setOnNativeInvokeListener(new IjkMediaPlayer.OnNativeInvokeListener(){

            public boolean onNativeInvoke(int i, Bundle bundle) {
                return true;
            }
        });
        try {
            String url;
            if (GSYVideoType.isMediaCodec()) {
                Debuger.printfLog("enable mediaCodec");
                this.mediaPlayer.setOption(4, "mediacodec", 1L);
                this.mediaPlayer.setOption(4, "mediacodec-auto-rotate", 1L);
                this.mediaPlayer.setOption(4, "mediacodec-handle-resolution-change", 1L);
            }
            if (!TextUtils.isEmpty((CharSequence)(url = ((GSYModel)msg.obj).getUrl()))) {
                Uri uri = Uri.parse((String)url);
                if (uri.getScheme().equals("android.resource")) {
                    RawDataSourceProvider rawDataSourceProvider = RawDataSourceProvider.create(context, uri);
                    this.mediaPlayer.setDataSource((IMediaDataSource)rawDataSourceProvider);
                } else {
                    this.mediaPlayer.setDataSource(url, ((GSYModel)msg.obj).getMapHeadData());
                }
            } else {
                this.mediaPlayer.setDataSource(url, ((GSYModel)msg.obj).getMapHeadData());
            }
            this.mediaPlayer.setLooping(((GSYModel)msg.obj).isLooping());
            if (((GSYModel)msg.obj).getSpeed() != 1.0f && ((GSYModel)msg.obj).getSpeed() > 0.0f) {
                this.mediaPlayer.setSpeed(((GSYModel)msg.obj).getSpeed());
            }
            IjkMediaPlayer.native_setLogLevel((int)logLevel);
            this.initIJKOption(this.mediaPlayer, optionModelList);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void showDisplay(Message msg) {
        if (msg.obj == null && this.mediaPlayer != null) {
            this.mediaPlayer.setSurface(null);
        } else {
            Surface holder;
            this.surface = holder = (Surface)msg.obj;
            if (this.mediaPlayer != null && holder.isValid()) {
                this.mediaPlayer.setSurface(holder);
            }
        }
    }

    @Override
    public void setSpeed(float speed, boolean soundTouch) {
        if (speed > 0.0f) {
            try {
                if (this.mediaPlayer != null) {
                    this.mediaPlayer.setSpeed(speed);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (soundTouch) {
                VideoOptionModel videoOptionModel = new VideoOptionModel(4, "soundtouch", 1);
                List<VideoOptionModel> list = this.getOptionModelList();
                if (list != null) {
                    list.add(videoOptionModel);
                } else {
                    list = new ArrayList<VideoOptionModel>();
                    list.add(videoOptionModel);
                }
                this.setOptionModelList(list);
            }
        }
    }

    @Override
    public void setNeedMute(boolean needMute) {
        if (this.mediaPlayer != null) {
            if (needMute) {
                this.mediaPlayer.setVolume(0.0f, 0.0f);
            } else {
                this.mediaPlayer.setVolume(1.0f, 1.0f);
            }
        }
    }

    @Override
    public void releaseSurface() {
        if (this.surface != null) {
            this.surface.release();
            this.surface = null;
        }
    }

    @Override
    public void release() {
        if (this.mediaPlayer != null) {
            this.mediaPlayer.release();
        }
    }

    private void initIJKOption(IjkMediaPlayer ijkMediaPlayer, List<VideoOptionModel> optionModelList) {
        if (optionModelList != null && optionModelList.size() > 0) {
            for (VideoOptionModel videoOptionModel : optionModelList) {
                if (videoOptionModel.getValueType() == 0) {
                    ijkMediaPlayer.setOption(videoOptionModel.getCategory(), videoOptionModel.getName(), (long)videoOptionModel.getValueInt());
                    continue;
                }
                ijkMediaPlayer.setOption(videoOptionModel.getCategory(), videoOptionModel.getName(), videoOptionModel.getValueString());
            }
        }
    }

    public List<VideoOptionModel> getOptionModelList() {
        return this.optionModelList;
    }

    public void setOptionModelList(List<VideoOptionModel> optionModelList) {
        this.optionModelList = optionModelList;
    }

    public static IjkLibLoader getIjkLibLoader() {
        return ijkLibLoader;
    }

    public static void setIjkLibLoader(IjkLibLoader ijkLibLoader) {
        IJKPlayerManager.ijkLibLoader = ijkLibLoader;
    }

    public static int getLogLevel() {
        return logLevel;
    }

    public static void setLogLevel(int logLevel) {
        IJKPlayerManager.logLevel = logLevel;
    }
}

