/*
 * Decompiled with CFR 0.152.
 */
package com.shuyu.gsyvideoplayer;

import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import android.view.Surface;
import com.danikula.videocache.CacheListener;
import com.danikula.videocache.HttpProxyCacheServer;
import com.danikula.videocache.file.Md5FileNameGenerator;
import com.danikula.videocache.headers.HeaderInjector;
import com.shuyu.gsyvideoplayer.listener.GSYMediaPlayerListener;
import com.shuyu.gsyvideoplayer.model.GSYModel;
import com.shuyu.gsyvideoplayer.model.VideoOptionModel;
import com.shuyu.gsyvideoplayer.player.EXO2PlayerManager;
import com.shuyu.gsyvideoplayer.player.IJKPlayerManager;
import com.shuyu.gsyvideoplayer.player.IPlayerManager;
import com.shuyu.gsyvideoplayer.player.SystemPlayerManager;
import com.shuyu.gsyvideoplayer.utils.CommonUtil;
import com.shuyu.gsyvideoplayer.utils.Debuger;
import com.shuyu.gsyvideoplayer.utils.FileUtils;
import com.shuyu.gsyvideoplayer.utils.StorageUtils;
import com.shuyu.gsyvideoplayer.video.base.GSYVideoViewBridge;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import tv.danmaku.ijk.media.player.IMediaPlayer;
import tv.danmaku.ijk.media.player.IjkLibLoader;

public abstract class GSYVideoBaseManager
implements IMediaPlayer.OnPreparedListener,
IMediaPlayer.OnCompletionListener,
IMediaPlayer.OnBufferingUpdateListener,
IMediaPlayer.OnSeekCompleteListener,
IMediaPlayer.OnErrorListener,
IMediaPlayer.OnVideoSizeChangedListener,
IMediaPlayer.OnInfoListener,
CacheListener,
GSYVideoViewBridge {
    public static String TAG = "GSYVideoBaseManager";
    private static final int HANDLER_PREPARE = 0;
    private static final int HANDLER_SETDISPLAY = 1;
    private static final int HANDLER_RELEASE = 2;
    private static final int HANDLER_RELEASE_SURFACE = 3;
    private static final int BUFFER_TIME_OUT_ERROR = -192;
    protected static IjkLibLoader ijkLibLoader;
    protected MediaHandler mMediaHandler;
    protected Handler mainThreadHandler;
    protected WeakReference<GSYMediaPlayerListener> listener;
    protected WeakReference<GSYMediaPlayerListener> lastListener;
    protected List<VideoOptionModel> optionModelList;
    protected HttpProxyCacheServer proxy;
    protected File cacheFile;
    protected String playTag = "";
    protected Map<String, String> mMapHeadData;
    protected Context context;
    protected IPlayerManager playerManager;
    protected int currentVideoWidth = 0;
    protected int currentVideoHeight = 0;
    protected int lastState;
    protected int playPosition = -22;
    protected int buffterPoint;
    protected int timeOut = 8000;
    protected int videoType = 0;
    protected boolean needMute = false;
    protected boolean needTimeOutOther;
    private Runnable mTimeOutRunnable = new Runnable(){

        @Override
        public void run() {
            if (GSYVideoBaseManager.this.listener != null) {
                Debuger.printfError("time out for error listener");
                GSYVideoBaseManager.this.listener().onError(-192, -192);
            }
        }
    };

    public static void setIjkLibLoader(IjkLibLoader libLoader) {
        IJKPlayerManager.setIjkLibLoader(libLoader);
        ijkLibLoader = libLoader;
    }

    public static IjkLibLoader getIjkLibLoader() {
        return ijkLibLoader;
    }

    public static void clearAllDefaultCache(Context context) {
        String path = StorageUtils.getIndividualCacheDirectory(context.getApplicationContext()).getAbsolutePath();
        FileUtils.deleteFiles(new File(path));
    }

    public static void clearDefaultCache(Context context, String url) {
        Md5FileNameGenerator md5FileNameGenerator = new Md5FileNameGenerator();
        String name = md5FileNameGenerator.generate(url);
        String pathTmp = StorageUtils.getIndividualCacheDirectory(context.getApplicationContext()).getAbsolutePath() + File.separator + name + ".download";
        String path = StorageUtils.getIndividualCacheDirectory(context.getApplicationContext()).getAbsolutePath() + File.separator + name;
        CommonUtil.deleteFile(pathTmp);
        CommonUtil.deleteFile(path);
    }

    protected void init(IjkLibLoader libLoader) {
        this.playerManager = this.getPlayManager(0);
        IJKPlayerManager.setIjkLibLoader(libLoader);
        HandlerThread mediaHandlerThread = new HandlerThread(TAG);
        mediaHandlerThread.start();
        this.mMediaHandler = new MediaHandler(mediaHandlerThread.getLooper());
        this.mainThreadHandler = new Handler();
    }

    protected IPlayerManager getPlayManager(int videoType) {
        switch (videoType) {
            case 2: {
                return new EXO2PlayerManager();
            }
            case 4: {
                return new SystemPlayerManager();
            }
        }
        return new IJKPlayerManager();
    }

    public HttpProxyCacheServer newProxy(Context context, File file) {
        if (!file.exists()) {
            file.mkdirs();
        }
        HttpProxyCacheServer.Builder builder = new HttpProxyCacheServer.Builder(context);
        builder.cacheDirectory(file);
        builder.headerInjector((HeaderInjector)new UserAgentHeadersInjector());
        this.cacheFile = file;
        return builder.build();
    }

    public void setProxy(HttpProxyCacheServer proxy) {
        this.proxy = proxy;
    }

    public HttpProxyCacheServer newProxy(Context context) {
        return new HttpProxyCacheServer.Builder(context.getApplicationContext()).headerInjector((HeaderInjector)new UserAgentHeadersInjector()).build();
    }

    @Override
    public GSYMediaPlayerListener listener() {
        if (this.listener == null) {
            return null;
        }
        return (GSYMediaPlayerListener)this.listener.get();
    }

    @Override
    public GSYMediaPlayerListener lastListener() {
        if (this.lastListener == null) {
            return null;
        }
        return (GSYMediaPlayerListener)this.lastListener.get();
    }

    @Override
    public void setListener(GSYMediaPlayerListener listener) {
        this.listener = listener == null ? null : new WeakReference<GSYMediaPlayerListener>(listener);
    }

    @Override
    public void setLastListener(GSYMediaPlayerListener lastListener) {
        this.lastListener = lastListener == null ? null : new WeakReference<GSYMediaPlayerListener>(lastListener);
    }

    @Override
    public void setSpeed(float speed, boolean soundTouch) {
        if (this.playerManager != null) {
            this.playerManager.setSpeed(speed, soundTouch);
        }
    }

    @Override
    public void prepare(String url, Map<String, String> mapHeadData, boolean loop, float speed) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return;
        }
        Message msg = new Message();
        msg.what = 0;
        this.mMapHeadData = mapHeadData;
        GSYModel fb = new GSYModel(url, mapHeadData, loop, speed);
        msg.obj = fb;
        this.mMediaHandler.sendMessage(msg);
        if (this.needTimeOutOther) {
            this.startTimeOutBuffer();
        }
    }

    @Override
    public void releaseMediaPlayer() {
        Message msg = new Message();
        msg.what = 2;
        this.mMediaHandler.sendMessage(msg);
        this.playTag = "";
        this.playPosition = -22;
    }

    @Override
    public void setDisplay(Surface holder) {
        Message msg = new Message();
        msg.what = 1;
        msg.obj = holder;
        this.mMediaHandler.sendMessage(msg);
    }

    @Override
    public void releaseSurface(Surface holder) {
        Message msg = new Message();
        msg.what = 3;
        msg.obj = holder;
        this.mMediaHandler.sendMessage(msg);
    }

    public void onPrepared(IMediaPlayer mp) {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                GSYVideoBaseManager.this.cancelTimeOutBuffer();
                if (GSYVideoBaseManager.this.listener() != null) {
                    GSYVideoBaseManager.this.listener().onPrepared();
                }
            }
        });
    }

    public void onCompletion(IMediaPlayer mp) {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                GSYVideoBaseManager.this.cancelTimeOutBuffer();
                if (GSYVideoBaseManager.this.listener() != null) {
                    GSYVideoBaseManager.this.listener().onAutoCompletion();
                }
            }
        });
    }

    public void onBufferingUpdate(IMediaPlayer mp, final int percent) {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                if (GSYVideoBaseManager.this.listener() != null) {
                    if (percent > GSYVideoBaseManager.this.buffterPoint) {
                        GSYVideoBaseManager.this.listener().onBufferingUpdate(percent);
                    } else {
                        GSYVideoBaseManager.this.listener().onBufferingUpdate(GSYVideoBaseManager.this.buffterPoint);
                    }
                }
            }
        });
    }

    public void onSeekComplete(IMediaPlayer mp) {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                GSYVideoBaseManager.this.cancelTimeOutBuffer();
                if (GSYVideoBaseManager.this.listener() != null) {
                    GSYVideoBaseManager.this.listener().onSeekComplete();
                }
            }
        });
    }

    public boolean onError(IMediaPlayer mp, final int what, final int extra) {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                GSYVideoBaseManager.this.cancelTimeOutBuffer();
                if (GSYVideoBaseManager.this.listener() != null) {
                    GSYVideoBaseManager.this.listener().onError(what, extra);
                }
            }
        });
        return true;
    }

    public boolean onInfo(IMediaPlayer mp, final int what, final int extra) {
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                if (GSYVideoBaseManager.this.needTimeOutOther) {
                    if (what == 701) {
                        GSYVideoBaseManager.this.startTimeOutBuffer();
                    } else if (what == 702) {
                        GSYVideoBaseManager.this.cancelTimeOutBuffer();
                    }
                }
                if (GSYVideoBaseManager.this.listener() != null) {
                    GSYVideoBaseManager.this.listener().onInfo(what, extra);
                }
            }
        });
        return false;
    }

    public void onVideoSizeChanged(IMediaPlayer mp, int width, int height, int sar_num, int sar_den) {
        this.currentVideoWidth = mp.getVideoWidth();
        this.currentVideoHeight = mp.getVideoHeight();
        this.mainThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                if (GSYVideoBaseManager.this.listener() != null) {
                    GSYVideoBaseManager.this.listener().onVideoSizeChanged();
                }
            }
        });
    }

    public void onCacheAvailable(File cacheFile, String url, int percentsAvailable) {
        this.buffterPoint = percentsAvailable;
    }

    @Override
    public IMediaPlayer getMediaPlayer() {
        if (this.playerManager != null) {
            return this.playerManager.getMediaPlayer();
        }
        return null;
    }

    @Override
    public CacheListener getCacheListener() {
        return this;
    }

    @Override
    public int getLastState() {
        return this.lastState;
    }

    @Override
    public void setLastState(int lastState) {
        this.lastState = lastState;
    }

    @Override
    public int getCurrentVideoWidth() {
        return this.currentVideoWidth;
    }

    @Override
    public int getCurrentVideoHeight() {
        return this.currentVideoHeight;
    }

    @Override
    public void setCurrentVideoHeight(int currentVideoHeight) {
        this.currentVideoHeight = currentVideoHeight;
    }

    @Override
    public void setCurrentVideoWidth(int currentVideoWidth) {
        this.currentVideoWidth = currentVideoWidth;
    }

    @Override
    public String getPlayTag() {
        return this.playTag;
    }

    @Override
    public void setPlayTag(String playTag) {
        this.playTag = playTag;
    }

    @Override
    public int getPlayPosition() {
        return this.playPosition;
    }

    @Override
    public void setPlayPosition(int playPosition) {
        this.playPosition = playPosition;
    }

    private void initVideo(Message msg) {
        try {
            this.currentVideoWidth = 0;
            this.currentVideoHeight = 0;
            if (this.playerManager != null) {
                this.playerManager.release();
            }
            this.playerManager = this.getPlayManager(this.videoType);
            this.playerManager.initVideoPlayer(this.context, msg, this.optionModelList);
            this.setNeedMute(this.needMute);
            IMediaPlayer mediaPlayer = this.playerManager.getMediaPlayer();
            mediaPlayer.setOnCompletionListener((IMediaPlayer.OnCompletionListener)this);
            mediaPlayer.setOnBufferingUpdateListener((IMediaPlayer.OnBufferingUpdateListener)this);
            mediaPlayer.setScreenOnWhilePlaying(true);
            mediaPlayer.setOnPreparedListener((IMediaPlayer.OnPreparedListener)this);
            mediaPlayer.setOnSeekCompleteListener((IMediaPlayer.OnSeekCompleteListener)this);
            mediaPlayer.setOnErrorListener((IMediaPlayer.OnErrorListener)this);
            mediaPlayer.setOnInfoListener((IMediaPlayer.OnInfoListener)this);
            mediaPlayer.setOnVideoSizeChangedListener((IMediaPlayer.OnVideoSizeChangedListener)this);
            mediaPlayer.prepareAsync();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void startTimeOutBuffer() {
        Debuger.printfError("startTimeOutBuffer");
        this.mainThreadHandler.postDelayed(this.mTimeOutRunnable, (long)this.timeOut);
    }

    private void cancelTimeOutBuffer() {
        Debuger.printfError("cancelTimeOutBuffer");
        if (this.needTimeOutOther) {
            this.mainThreadHandler.removeCallbacks(this.mTimeOutRunnable);
        }
    }

    private void releaseSurface(Message msg) {
        if (msg.obj != null && this.playerManager != null) {
            this.playerManager.releaseSurface();
        }
    }

    private void showDisplay(Message msg) {
        if (this.playerManager != null) {
            this.playerManager.showDisplay(msg);
        }
    }

    public int getVideoType() {
        return this.videoType;
    }

    public void setVideoType(Context context, int videoType) {
        this.context = context.getApplicationContext();
        this.videoType = videoType;
    }

    public void enableRawPlay(Context context) {
        this.context = context.getApplicationContext();
    }

    public List<VideoOptionModel> getOptionModelList() {
        return this.optionModelList;
    }

    public void setOptionModelList(List<VideoOptionModel> optionModelList) {
        this.optionModelList = optionModelList;
    }

    public boolean isNeedMute() {
        return this.needMute;
    }

    public void setNeedMute(boolean needMute) {
        this.needMute = needMute;
        if (this.playerManager != null) {
            this.playerManager.setNeedMute(needMute);
        }
    }

    public int getTimeOut() {
        return this.timeOut;
    }

    public boolean isNeedTimeOutOther() {
        return this.needTimeOutOther;
    }

    public void setTimeOut(int timeOut, boolean needTimeOutOther) {
        this.timeOut = timeOut;
        this.needTimeOutOther = needTimeOutOther;
    }

    public void setLogLevel(int logLevel) {
        IJKPlayerManager.setLogLevel(logLevel);
    }

    private class UserAgentHeadersInjector
    implements HeaderInjector {
        private UserAgentHeadersInjector() {
        }

        public Map<String, String> addHeaders(String url) {
            return GSYVideoBaseManager.this.mMapHeadData == null ? new HashMap() : GSYVideoBaseManager.this.mMapHeadData;
        }
    }

    private class MediaHandler
    extends Handler {
        MediaHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            switch (msg.what) {
                case 0: {
                    GSYVideoBaseManager.this.initVideo(msg);
                    break;
                }
                case 1: {
                    GSYVideoBaseManager.this.showDisplay(msg);
                    break;
                }
                case 2: {
                    if (GSYVideoBaseManager.this.playerManager != null) {
                        GSYVideoBaseManager.this.playerManager.release();
                    }
                    GSYVideoBaseManager.this.setNeedMute(false);
                    if (GSYVideoBaseManager.this.proxy != null) {
                        GSYVideoBaseManager.this.proxy.unregisterCacheListener((CacheListener)GSYVideoBaseManager.this);
                    }
                    GSYVideoBaseManager.this.buffterPoint = 0;
                    GSYVideoBaseManager.this.cancelTimeOutBuffer();
                    break;
                }
                case 3: {
                    GSYVideoBaseManager.this.releaseSurface(msg);
                }
            }
        }
    }
}

