/*
 * Decompiled with CFR 0.152.
 */
package com.shuyu.gsyvideoplayer.render.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.opengl.GLSurfaceView;
import android.util.AttributeSet;
import android.view.Surface;
import android.view.View;
import android.view.ViewGroup;
import com.shuyu.gsyvideoplayer.listener.GSYVideoShotListener;
import com.shuyu.gsyvideoplayer.listener.GSYVideoShotSaveListener;
import com.shuyu.gsyvideoplayer.render.GSYRenderView;
import com.shuyu.gsyvideoplayer.render.effect.NoEffect;
import com.shuyu.gsyvideoplayer.render.glrender.GSYVideoGLViewBaseRender;
import com.shuyu.gsyvideoplayer.render.glrender.GSYVideoGLViewSimpleRender;
import com.shuyu.gsyvideoplayer.render.view.IGSYRenderView;
import com.shuyu.gsyvideoplayer.render.view.listener.GLSurfaceListener;
import com.shuyu.gsyvideoplayer.render.view.listener.GSYVideoGLRenderErrorListener;
import com.shuyu.gsyvideoplayer.render.view.listener.IGSYSurfaceListener;
import com.shuyu.gsyvideoplayer.utils.Debuger;
import com.shuyu.gsyvideoplayer.utils.FileUtils;
import com.shuyu.gsyvideoplayer.utils.MeasureHelper;
import java.io.File;

@SuppressLint(value={"ViewConstructor"})
public class GSYVideoGLView
extends GLSurfaceView
implements GLSurfaceListener,
IGSYRenderView,
MeasureHelper.MeasureFormVideoParamsListener {
    private static final String TAG = GSYVideoGLView.class.getName();
    public static final int MODE_LAYOUT_SIZE = 0;
    public static final int MODE_RENDER_SIZE = 1;
    private GSYVideoGLViewBaseRender mRenderer;
    private Context mContext;
    private ShaderInterface mEffect = new NoEffect();
    private MeasureHelper.MeasureFormVideoParamsListener mVideoParamsListener;
    private MeasureHelper measureHelper;
    private GLSurfaceListener mOnGSYSurfaceListener;
    private IGSYSurfaceListener mIGSYSurfaceListener;
    private float[] mMVPMatrix;
    private int mMode = 0;

    public GSYVideoGLView(Context context) {
        super(context);
        this.init(context);
    }

    public GSYVideoGLView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    private void init(Context context) {
        this.mContext = context;
        this.setEGLContextClientVersion(2);
        this.mRenderer = new GSYVideoGLViewSimpleRender();
        this.measureHelper = new MeasureHelper((View)this, this);
        this.mRenderer.setSurfaceView(this);
    }

    public void onResume() {
        super.onResume();
        if (this.mRenderer != null) {
            this.mRenderer.initRenderSize();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mMode == 1) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            this.measureHelper.prepareMeasure(widthMeasureSpec, heightMeasureSpec, (int)this.getRotation());
            this.initRenderMeasure();
        } else {
            this.measureHelper.prepareMeasure(widthMeasureSpec, heightMeasureSpec, (int)this.getRotation());
            this.setMeasuredDimension(this.measureHelper.getMeasuredWidth(), this.measureHelper.getMeasuredHeight());
        }
    }

    @Override
    public IGSYSurfaceListener getIGSYSurfaceListener() {
        return this.mIGSYSurfaceListener;
    }

    @Override
    public void setIGSYSurfaceListener(IGSYSurfaceListener surfaceListener) {
        this.setOnGSYSurfaceListener(this);
        this.mIGSYSurfaceListener = surfaceListener;
    }

    @Override
    public void onSurfaceAvailable(Surface surface) {
        if (this.mIGSYSurfaceListener != null) {
            this.mIGSYSurfaceListener.onSurfaceAvailable(surface);
        }
    }

    @Override
    public int getSizeH() {
        return this.measureHelper.getMeasuredHeight();
    }

    @Override
    public int getSizeW() {
        return this.measureHelper.getMeasuredWidth();
    }

    @Override
    public Bitmap initCover() {
        Debuger.printfLog(this.getClass().getSimpleName() + " not support initCover now");
        return null;
    }

    @Override
    public Bitmap initCoverHigh() {
        Debuger.printfLog(this.getClass().getSimpleName() + " not support initCoverHigh now");
        return null;
    }

    @Override
    public void taskShotPic(GSYVideoShotListener gsyVideoShotListener, boolean shotHigh) {
        if (gsyVideoShotListener != null) {
            this.setGSYVideoShotListener(gsyVideoShotListener, shotHigh);
            this.takeShotPic();
        }
    }

    @Override
    public void saveFrame(final File file, boolean high, final GSYVideoShotSaveListener gsyVideoShotSaveListener) {
        GSYVideoShotListener gsyVideoShotListener = new GSYVideoShotListener(){

            @Override
            public void getBitmap(Bitmap bitmap) {
                if (bitmap == null) {
                    gsyVideoShotSaveListener.result(false, file);
                } else {
                    FileUtils.saveBitmap(bitmap, file);
                    gsyVideoShotSaveListener.result(true, file);
                }
            }
        };
        this.setGSYVideoShotListener(gsyVideoShotListener, high);
        this.takeShotPic();
    }

    @Override
    public View getRenderView() {
        return this;
    }

    @Override
    public void onRenderResume() {
        this.requestLayout();
        this.onResume();
    }

    @Override
    public void onRenderPause() {
        this.requestLayout();
        this.onPause();
    }

    @Override
    public void releaseRenderAll() {
        this.requestLayout();
        this.releaseAll();
    }

    @Override
    public void setRenderMode(int mode) {
        this.setMode(mode);
    }

    @Override
    public void setRenderTransform(Matrix transform) {
        Debuger.printfLog(this.getClass().getSimpleName() + " not support setRenderTransform now");
    }

    @Override
    public void setGLRenderer(GSYVideoGLViewBaseRender renderer) {
        this.setCustomRenderer(renderer);
    }

    @Override
    public void setGLMVPMatrix(float[] MVPMatrix) {
        this.setMVPMatrix(MVPMatrix);
    }

    @Override
    public void setGLEffectFilter(ShaderInterface effectFilter) {
        this.setEffect(effectFilter);
    }

    @Override
    public void setVideoParamsListener(MeasureHelper.MeasureFormVideoParamsListener listener) {
        this.mVideoParamsListener = listener;
    }

    @Override
    public int getCurrentVideoWidth() {
        if (this.mVideoParamsListener != null) {
            return this.mVideoParamsListener.getCurrentVideoWidth();
        }
        return 0;
    }

    @Override
    public int getCurrentVideoHeight() {
        if (this.mVideoParamsListener != null) {
            return this.mVideoParamsListener.getCurrentVideoHeight();
        }
        return 0;
    }

    @Override
    public int getVideoSarNum() {
        if (this.mVideoParamsListener != null) {
            return this.mVideoParamsListener.getVideoSarNum();
        }
        return 0;
    }

    @Override
    public int getVideoSarDen() {
        if (this.mVideoParamsListener != null) {
            return this.mVideoParamsListener.getVideoSarDen();
        }
        return 0;
    }

    protected void initRenderMeasure() {
        if (this.mVideoParamsListener != null && this.mMode == 1) {
            try {
                int videoWidth = this.mVideoParamsListener.getCurrentVideoWidth();
                int videoHeight = this.mVideoParamsListener.getCurrentVideoHeight();
                if (this.mRenderer != null) {
                    this.mRenderer.setCurrentViewWidth(this.measureHelper.getMeasuredWidth());
                    this.mRenderer.setCurrentViewHeight(this.measureHelper.getMeasuredHeight());
                    this.mRenderer.setCurrentVideoWidth(videoWidth);
                    this.mRenderer.setCurrentVideoHeight(videoHeight);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void initRender() {
        this.setRenderer(this.mRenderer);
    }

    public void setGSYVideoGLRenderErrorListener(GSYVideoGLRenderErrorListener videoGLRenderErrorListener) {
        this.mRenderer.setGSYVideoGLRenderErrorListener(videoGLRenderErrorListener);
    }

    public void setCustomRenderer(GSYVideoGLViewBaseRender CustomRender) {
        this.mRenderer = CustomRender;
        this.mRenderer.setSurfaceView(this);
        this.initRenderMeasure();
    }

    public void setOnGSYSurfaceListener(GLSurfaceListener mGSYSurfaceListener) {
        this.mOnGSYSurfaceListener = mGSYSurfaceListener;
        this.mRenderer.setGSYSurfaceListener(this.mOnGSYSurfaceListener);
    }

    public void setEffect(ShaderInterface shaderEffect) {
        if (shaderEffect != null) {
            this.mEffect = shaderEffect;
            this.mRenderer.setEffect(this.mEffect);
        }
    }

    public void setMVPMatrix(float[] MVPMatrix) {
        if (MVPMatrix != null) {
            this.mMVPMatrix = MVPMatrix;
            this.mRenderer.setMVPMatrix(MVPMatrix);
        }
    }

    public void takeShotPic() {
        this.mRenderer.takeShotPic();
    }

    public void setGSYVideoShotListener(GSYVideoShotListener listener, boolean high) {
        this.mRenderer.setGSYVideoShotListener(listener, high);
    }

    public int getMode() {
        return this.mMode;
    }

    public void setMode(int mode) {
        this.mMode = mode;
    }

    public void releaseAll() {
        if (this.mRenderer != null) {
            this.mRenderer.releaseAll();
        }
    }

    public GSYVideoGLViewBaseRender getRenderer() {
        return this.mRenderer;
    }

    public ShaderInterface getEffect() {
        return this.mEffect;
    }

    public float[] getMVPMatrix() {
        return this.mMVPMatrix;
    }

    public static GSYVideoGLView addGLView(final Context context, final ViewGroup textureViewContainer, final int rotate, final IGSYSurfaceListener gsySurfaceListener, final MeasureHelper.MeasureFormVideoParamsListener videoParamsListener, ShaderInterface effect, float[] transform, GSYVideoGLViewBaseRender customRender, final int renderMode) {
        if (textureViewContainer.getChildCount() > 0) {
            textureViewContainer.removeAllViews();
        }
        GSYVideoGLView gsyVideoGLView = new GSYVideoGLView(context);
        if (customRender != null) {
            gsyVideoGLView.setCustomRenderer(customRender);
        }
        gsyVideoGLView.setEffect(effect);
        gsyVideoGLView.setVideoParamsListener(videoParamsListener);
        gsyVideoGLView.setRenderMode(renderMode);
        gsyVideoGLView.setIGSYSurfaceListener(gsySurfaceListener);
        gsyVideoGLView.setRotation(rotate);
        gsyVideoGLView.initRender();
        gsyVideoGLView.setGSYVideoGLRenderErrorListener(new GSYVideoGLRenderErrorListener(){

            @Override
            public void onError(GSYVideoGLViewBaseRender render, String Error, int code, boolean byChangedRenderError) {
                if (byChangedRenderError) {
                    GSYVideoGLView.addGLView(context, textureViewContainer, rotate, gsySurfaceListener, videoParamsListener, render.getEffect(), render.getMVPMatrix(), render, renderMode);
                }
            }
        });
        if (transform != null && transform.length == 16) {
            gsyVideoGLView.setMVPMatrix(transform);
        }
        GSYRenderView.addToParent(textureViewContainer, (View)gsyVideoGLView);
        return gsyVideoGLView;
    }

    public static interface ShaderInterface {
        public String getShader(GLSurfaceView var1);
    }
}

