/*
 * Decompiled with CFR 0.152.
 */
package com.shuyu.gsyvideoplayer;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import android.view.Surface;
import com.shuyu.gsyvideoplayer.GSYVideoManager;
import com.shuyu.gsyvideoplayer.model.GSYModel;
import java.io.IOException;
import java.util.Map;
import tv.danmaku.ijk.media.player.IMediaPlayer;
import tv.danmaku.ijk.media.player.IjkLibLoader;
import tv.danmaku.ijk.media.player.IjkMediaPlayer;

@Deprecated
public class GSYPreViewManager
implements IMediaPlayer.OnPreparedListener,
IMediaPlayer.OnSeekCompleteListener {
    public static String TAG = "GSYPreViewManager";
    private static GSYPreViewManager videoManager;
    private static final int HANDLER_PREPARE = 0;
    private static final int HANDLER_SETDISPLAY = 1;
    private static final int HANDLER_RELEASE = 2;
    private IjkMediaPlayer mediaPlayer;
    private HandlerThread mMediaHandlerThread;
    private MediaHandler mMediaHandler;
    private boolean seekToComplete = true;
    private static IjkLibLoader ijkLibLoader;

    public static synchronized GSYPreViewManager instance() {
        if (videoManager == null) {
            videoManager = new GSYPreViewManager();
        }
        return videoManager;
    }

    private GSYPreViewManager() {
        IjkLibLoader libLoader = GSYVideoManager.getIjkLibLoader();
        this.mediaPlayer = libLoader == null ? new IjkMediaPlayer() : new IjkMediaPlayer(libLoader);
        ijkLibLoader = libLoader;
        this.mMediaHandlerThread = new HandlerThread(TAG);
        this.mMediaHandlerThread.start();
        this.mMediaHandler = new MediaHandler(this.mMediaHandlerThread.getLooper());
    }

    private void initVideo(Message msg) {
        try {
            this.mediaPlayer.release();
            this.initIJKPlayer(msg);
            this.mediaPlayer.setOnPreparedListener((IMediaPlayer.OnPreparedListener)this);
            this.mediaPlayer.setOnSeekCompleteListener((IMediaPlayer.OnSeekCompleteListener)this);
            this.mediaPlayer.setVolume(0.0f, 0.0f);
            this.mediaPlayer.prepareAsync();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initIJKPlayer(Message msg) {
        this.mediaPlayer = ijkLibLoader == null ? new IjkMediaPlayer() : new IjkMediaPlayer(ijkLibLoader);
        this.mediaPlayer.setAudioStreamType(3);
        try {
            this.mediaPlayer.setDataSource(((GSYModel)msg.obj).getUrl(), ((GSYModel)msg.obj).getMapHeadData());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void showDisplay(Message msg) {
        if (msg.obj == null && this.mediaPlayer != null) {
            this.mediaPlayer.setSurface(null);
        } else {
            Surface holder = (Surface)msg.obj;
            if (this.mediaPlayer != null && holder.isValid()) {
                this.mediaPlayer.setSurface(holder);
            }
        }
    }

    public void onPrepared(IMediaPlayer mp) {
        mp.pause();
        this.seekToComplete = true;
    }

    public void onSeekComplete(IMediaPlayer mp) {
        this.seekToComplete = true;
    }

    public void prepare(String url, Map<String, String> mapHeadData, boolean loop, float speed) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return;
        }
        Message msg = new Message();
        msg.what = 0;
        GSYModel fb = new GSYModel(url, mapHeadData, loop, speed);
        msg.obj = fb;
        this.mMediaHandler.sendMessage(msg);
    }

    public void releaseMediaPlayer() {
        Message msg = new Message();
        msg.what = 2;
        this.mMediaHandler.sendMessage(msg);
    }

    public void setDisplay(Surface holder) {
        Message msg = new Message();
        msg.what = 1;
        msg.obj = holder;
        this.mMediaHandler.sendMessage(msg);
    }

    public IjkMediaPlayer getMediaPlayer() {
        return this.mediaPlayer;
    }

    public boolean isSeekToComplete() {
        return this.seekToComplete;
    }

    public void setSeekToComplete(boolean seekToComplete) {
        this.seekToComplete = seekToComplete;
    }

    private class MediaHandler
    extends Handler {
        MediaHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            switch (msg.what) {
                case 0: {
                    GSYPreViewManager.this.initVideo(msg);
                    break;
                }
                case 1: {
                    GSYPreViewManager.this.showDisplay(msg);
                    break;
                }
                case 2: {
                    if (GSYPreViewManager.this.mediaPlayer == null) break;
                    GSYPreViewManager.this.mediaPlayer.release();
                }
            }
        }
    }
}

