/*
 * Decompiled with CFR 0.152.
 */
package com.shuyu.gsyvideoplayer.render.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.opengl.GLSurfaceView;
import android.util.AttributeSet;
import android.view.Surface;
import android.view.View;
import com.shuyu.gsyvideoplayer.GSYVideoManager;
import com.shuyu.gsyvideoplayer.listener.GSYVideoGLRenderErrorListener;
import com.shuyu.gsyvideoplayer.listener.GSYVideoShotListener;
import com.shuyu.gsyvideoplayer.render.effect.NoEffect;
import com.shuyu.gsyvideoplayer.render.glrender.GSYVideoGLViewBaseRender;
import com.shuyu.gsyvideoplayer.render.glrender.GSYVideoGLViewSimpleRender;
import com.shuyu.gsyvideoplayer.utils.MeasureHelper;

@SuppressLint(value={"ViewConstructor"})
public class GSYVideoGLView
extends GLSurfaceView {
    private static final String TAG = GSYVideoGLView.class.getName();
    public static final int MODE_LAYOUT_SIZE = 0;
    public static final int MODE_RENDER_SIZE = 1;
    private GSYVideoGLViewBaseRender mRenderer;
    private Context mContext;
    private ShaderInterface mEffect = new NoEffect();
    private float[] mMVPMatrix;
    private MeasureHelper measureHelper;
    private onGSYSurfaceListener mGSYSurfaceListener;
    private int mMode = 0;

    public GSYVideoGLView(Context context) {
        super(context);
        this.init(context);
    }

    public GSYVideoGLView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    private void init(Context context) {
        this.mContext = context;
        this.setEGLContextClientVersion(2);
        this.mRenderer = new GSYVideoGLViewSimpleRender();
        this.measureHelper = new MeasureHelper((View)this);
        this.mRenderer.setSurfaceView(this);
    }

    public void initRender() {
        this.setRenderer(this.mRenderer);
    }

    public void setCustomRenderer(GSYVideoGLViewBaseRender CustomRender) {
        this.mRenderer = CustomRender;
        this.mRenderer.setSurfaceView(this);
        this.initRenderMeasure();
    }

    public void setGSYSurfaceListener(onGSYSurfaceListener mGSYSurfaceListener) {
        this.mGSYSurfaceListener = mGSYSurfaceListener;
        this.mRenderer.setGSYSurfaceListener(this.mGSYSurfaceListener);
    }

    public void setEffect(ShaderInterface shaderEffect) {
        if (shaderEffect != null) {
            this.mEffect = shaderEffect;
            this.mRenderer.setEffect(this.mEffect);
        }
    }

    public void setMVPMatrix(float[] MVPMatrix) {
        if (MVPMatrix != null) {
            this.mMVPMatrix = MVPMatrix;
            this.mRenderer.setMVPMatrix(MVPMatrix);
        }
    }

    public void takeShotPic() {
        this.mRenderer.takeShotPic();
    }

    public void setGSYVideoShotListener(GSYVideoShotListener listener, boolean high) {
        this.mRenderer.setGSYVideoShotListener(listener, high);
    }

    public void setGSYVideoGLRenderErrorListener(GSYVideoGLRenderErrorListener videoGLRenderErrorListener) {
        this.mRenderer.setGSYVideoGLRenderErrorListener(videoGLRenderErrorListener);
    }

    public void onResume() {
        super.onResume();
        if (this.mRenderer != null) {
            this.mRenderer.initRenderSize();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mMode == 1) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            this.measureHelper.prepareMeasure(widthMeasureSpec, heightMeasureSpec, (int)this.getRotation());
            this.initRenderMeasure();
        } else {
            this.measureHelper.prepareMeasure(widthMeasureSpec, heightMeasureSpec, (int)this.getRotation());
            this.setMeasuredDimension(this.measureHelper.getMeasuredWidth(), this.measureHelper.getMeasuredHeight());
        }
    }

    protected void initRenderMeasure() {
        if (GSYVideoManager.instance().getMediaPlayer() != null && this.mMode == 1) {
            try {
                int videoWidth = GSYVideoManager.instance().getCurrentVideoWidth();
                int videoHeight = GSYVideoManager.instance().getCurrentVideoHeight();
                if (this.mRenderer != null) {
                    this.mRenderer.setCurrentViewWidth(this.measureHelper.getMeasuredWidth());
                    this.mRenderer.setCurrentViewHeight(this.measureHelper.getMeasuredHeight());
                    this.mRenderer.setCurrentVideoWidth(videoWidth);
                    this.mRenderer.setCurrentVideoHeight(videoHeight);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public int getSizeH() {
        return this.measureHelper.getMeasuredHeight();
    }

    public int getSizeW() {
        return this.measureHelper.getMeasuredWidth();
    }

    public int getMode() {
        return this.mMode;
    }

    public void setMode(int mode) {
        this.mMode = mode;
    }

    public void releaseAll() {
        if (this.mRenderer != null) {
            this.mRenderer.releaseAll();
        }
    }

    public static interface ShaderInterface {
        public String getShader(GLSurfaceView var1);
    }

    public static interface onGSYSurfaceListener {
        public void onSurfaceAvailable(Surface var1);
    }
}

