/*
 * Decompiled with CFR 0.152.
 */
package com.shuyu.gsyvideoplayer.render;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.view.SurfaceHolder;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.shuyu.gsyvideoplayer.listener.GSYVideoShotListener;
import com.shuyu.gsyvideoplayer.listener.GSYVideoShotSaveListener;
import com.shuyu.gsyvideoplayer.render.glrender.GSYVideoGLViewBaseRender;
import com.shuyu.gsyvideoplayer.render.view.GSYSurfaceView;
import com.shuyu.gsyvideoplayer.render.view.GSYTextureView;
import com.shuyu.gsyvideoplayer.render.view.GSYVideoGLView;
import com.shuyu.gsyvideoplayer.utils.FileUtils;
import com.shuyu.gsyvideoplayer.utils.GSYVideoType;
import java.io.File;

public class GSYRenderView {
    private View mShowView;

    public void setTransform(Matrix transform) {
        if (this.mShowView instanceof TextureView) {
            ((TextureView)this.mShowView).setTransform(transform);
        }
    }

    public void requestLayout() {
        if (this.mShowView != null) {
            this.mShowView.requestLayout();
        }
    }

    public float getRotation() {
        return this.mShowView.getRotation();
    }

    public void setRotation(float rotation) {
        if (this.mShowView != null) {
            this.mShowView.setRotation(rotation);
        }
    }

    public void invalidate() {
        if (this.mShowView != null) {
            this.mShowView.invalidate();
        }
    }

    public int getWidth() {
        return this.mShowView != null ? this.mShowView.getWidth() : 0;
    }

    public int getHeight() {
        return this.mShowView != null ? this.mShowView.getHeight() : 0;
    }

    public View getShowView() {
        return this.mShowView;
    }

    public Bitmap initCover() {
        if (this.mShowView != null && this.mShowView instanceof GSYTextureView) {
            GSYTextureView textureView = (GSYTextureView)this.mShowView;
            Bitmap bitmap = Bitmap.createBitmap((int)textureView.getSizeW(), (int)textureView.getSizeH(), (Bitmap.Config)Bitmap.Config.RGB_565);
            return textureView.getBitmap(bitmap);
        }
        return null;
    }

    public Bitmap initCoverHigh() {
        if (this.mShowView != null && this.mShowView instanceof GSYTextureView) {
            GSYTextureView textureView = (GSYTextureView)this.mShowView;
            Bitmap bitmap = Bitmap.createBitmap((int)textureView.getSizeW(), (int)textureView.getSizeH(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            return textureView.getBitmap(bitmap);
        }
        return null;
    }

    public void taskShotPic(GSYVideoShotListener gsyVideoShotListener) {
        this.taskShotPic(gsyVideoShotListener, false);
    }

    public void taskShotPic(GSYVideoShotListener gsyVideoShotListener, boolean shotHigh) {
        if (gsyVideoShotListener != null) {
            if (this.mShowView instanceof GSYVideoGLView) {
                GSYVideoGLView gsyVideoGLView = (GSYVideoGLView)this.mShowView;
                gsyVideoGLView.setGSYVideoShotListener(gsyVideoShotListener, shotHigh);
                gsyVideoGLView.takeShotPic();
            } else if (this.mShowView instanceof GSYTextureView) {
                if (shotHigh) {
                    gsyVideoShotListener.getBitmap(this.initCoverHigh());
                } else {
                    gsyVideoShotListener.getBitmap(this.initCover());
                }
            }
        }
    }

    public void saveFrame(File file, GSYVideoShotSaveListener gsyVideoShotSaveListener) {
        this.saveFrame(file, false, gsyVideoShotSaveListener);
    }

    public void saveFrame(final File file, boolean high, final GSYVideoShotSaveListener gsyVideoShotSaveListener) {
        GSYVideoShotListener gsyVideoShotListener = new GSYVideoShotListener(){

            @Override
            public void getBitmap(Bitmap bitmap) {
                if (bitmap == null) {
                    gsyVideoShotSaveListener.result(false, file);
                } else {
                    FileUtils.saveBitmap(bitmap, file);
                    gsyVideoShotSaveListener.result(true, file);
                }
            }
        };
        if (this.mShowView instanceof GSYVideoGLView) {
            GSYVideoGLView gsyVideoGLView = (GSYVideoGLView)this.mShowView;
            gsyVideoGLView.setGSYVideoShotListener(gsyVideoShotListener, high);
            gsyVideoGLView.takeShotPic();
        } else if (this.mShowView instanceof GSYTextureView) {
            if (high) {
                gsyVideoShotListener.getBitmap(this.initCoverHigh());
            } else {
                gsyVideoShotListener.getBitmap(this.initCover());
            }
        }
    }

    public ViewGroup.LayoutParams getLayoutParams() {
        return this.mShowView.getLayoutParams();
    }

    public void setLayoutParams(ViewGroup.LayoutParams layoutParams) {
        if (this.mShowView != null) {
            this.mShowView.setLayoutParams(layoutParams);
        }
    }

    public void onResume() {
        if (this.mShowView instanceof GSYVideoGLView) {
            GSYVideoGLView gsyVideoGLView = (GSYVideoGLView)this.mShowView;
            gsyVideoGLView.requestLayout();
            gsyVideoGLView.onResume();
        }
    }

    public void onPause() {
        if (this.mShowView instanceof GSYVideoGLView) {
            GSYVideoGLView gsyVideoGLView = (GSYVideoGLView)this.mShowView;
            gsyVideoGLView.requestLayout();
            gsyVideoGLView.onPause();
        }
    }

    public void releaseAll() {
        if (this.mShowView instanceof GSYVideoGLView) {
            GSYVideoGLView gsyVideoGLView = (GSYVideoGLView)this.mShowView;
            gsyVideoGLView.requestLayout();
            gsyVideoGLView.releaseAll();
        }
    }

    public void setGLRenderMode(int mode) {
        if (this.mShowView instanceof GSYVideoGLView) {
            GSYVideoGLView gsyVideoGLView = (GSYVideoGLView)this.mShowView;
            gsyVideoGLView.setMode(mode);
        }
    }

    public void addTextureView(Context context, ViewGroup textureViewContainer, int rotate, TextureView.SurfaceTextureListener listener) {
        if (textureViewContainer.getChildCount() > 0) {
            textureViewContainer.removeAllViews();
        }
        GSYTextureView gsyTextureView = new GSYTextureView(context);
        gsyTextureView.setSurfaceTextureListener(listener);
        gsyTextureView.setRotation(rotate);
        this.mShowView = gsyTextureView;
        this.addToParent(textureViewContainer, (View)gsyTextureView);
    }

    public void addSurfaceView(Context context, ViewGroup textureViewContainer, int rotate, SurfaceHolder.Callback2 callback2) {
        if (textureViewContainer.getChildCount() > 0) {
            textureViewContainer.removeAllViews();
        }
        GSYSurfaceView showSurfaceView = new GSYSurfaceView(context);
        showSurfaceView.getHolder().addCallback((SurfaceHolder.Callback)callback2);
        showSurfaceView.setRotation(rotate);
        this.mShowView = showSurfaceView;
        this.addToParent(textureViewContainer, (View)showSurfaceView);
    }

    public void addGLView(Context context, ViewGroup textureViewContainer, int rotate, GSYVideoGLView.onGSYSurfaceListener gsySurfaceListener, GSYVideoGLView.ShaderInterface effect, float[] transform, GSYVideoGLViewBaseRender customRender) {
        if (textureViewContainer.getChildCount() > 0) {
            textureViewContainer.removeAllViews();
        }
        GSYVideoGLView gsyVideoGLView = new GSYVideoGLView(context);
        if (customRender != null) {
            gsyVideoGLView.setCustomRenderer(customRender);
        }
        gsyVideoGLView.setEffect(effect);
        gsyVideoGLView.setGSYSurfaceListener(gsySurfaceListener);
        gsyVideoGLView.setRotation(rotate);
        gsyVideoGLView.initRender();
        this.mShowView = gsyVideoGLView;
        if (transform != null && transform.length == 16) {
            gsyVideoGLView.setMVPMatrix(transform);
        }
        this.addToParent(textureViewContainer, (View)gsyVideoGLView);
    }

    private void addToParent(ViewGroup textureViewContainer, View render) {
        int params = this.getTextureParams();
        if (textureViewContainer instanceof RelativeLayout) {
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(params, params);
            layoutParams.addRule(13);
            textureViewContainer.addView(render, (ViewGroup.LayoutParams)layoutParams);
        } else if (textureViewContainer instanceof FrameLayout) {
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(params, params);
            layoutParams.gravity = 17;
            textureViewContainer.addView(render, (ViewGroup.LayoutParams)layoutParams);
        }
    }

    protected int getTextureParams() {
        boolean typeChanged = GSYVideoType.getShowType() != 0;
        return typeChanged ? -2 : -1;
    }
}

