/*
 * Decompiled with CFR 0.152.
 */
package com.shuyu.gsyvideoplayer.video.base;

import android.app.Activity;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.RectF;
import android.media.AudioManager;
import android.support.annotation.AttrRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.InflateException;
import android.view.View;
import android.view.ViewGroup;
import com.danikula.videocache.CacheListener;
import com.danikula.videocache.HttpProxyCacheServer;
import com.danikula.videocache.file.Md5FileNameGenerator;
import com.shuyu.gsyvideoplayer.GSYVideoManager;
import com.shuyu.gsyvideoplayer.R;
import com.shuyu.gsyvideoplayer.listener.GSYMediaPlayerListener;
import com.shuyu.gsyvideoplayer.listener.VideoAllCallBack;
import com.shuyu.gsyvideoplayer.model.VideoOptionModel;
import com.shuyu.gsyvideoplayer.utils.CommonUtil;
import com.shuyu.gsyvideoplayer.utils.Debuger;
import com.shuyu.gsyvideoplayer.utils.NetInfoModule;
import com.shuyu.gsyvideoplayer.utils.StorageUtils;
import com.shuyu.gsyvideoplayer.video.base.GSYTextureRenderView;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import tv.danmaku.ijk.media.player.IjkLibLoader;
import tv.danmaku.ijk.media.player.IjkMediaPlayer;

public abstract class GSYVideoView
extends GSYTextureRenderView
implements GSYMediaPlayerListener {
    public static final int CURRENT_STATE_NORMAL = 0;
    public static final int CURRENT_STATE_PREPAREING = 1;
    public static final int CURRENT_STATE_PLAYING = 2;
    public static final int CURRENT_STATE_PLAYING_BUFFERING_START = 3;
    public static final int CURRENT_STATE_PAUSE = 5;
    public static final int CURRENT_STATE_AUTO_COMPLETE = 6;
    public static final int CURRENT_STATE_ERROR = 7;
    public static final int CHANGE_DELAY_TIME = 2000;
    protected int mCurrentState = -1;
    protected int mPlayPosition = -22;
    protected int mScreenWidth;
    protected int mScreenHeight;
    protected int mBuffterPoint;
    protected int mBackUpPlayingBufferState = -1;
    protected long mSeekOnStart = -1L;
    protected long mCurrentPosition;
    protected long mSaveChangeViewTIme = 0L;
    protected float mSpeed = 1.0f;
    protected boolean mCache = false;
    protected boolean mIfCurrentIsFullscreen = false;
    protected boolean mLooping = false;
    protected boolean mHadPlay = false;
    protected boolean mCacheFile = false;
    protected boolean mNetChanged = false;
    protected boolean mSoundTouch = false;
    protected boolean mShowPauseCover = true;
    protected boolean mPauseBeforePrepared = false;
    protected AudioManager mAudioManager;
    protected String mPlayTag = "";
    protected Context mContext;
    protected String mOriginUrl;
    protected String mUrl;
    protected String mTitle;
    protected String mNetSate = "NORMAL";
    protected File mCachePath;
    protected VideoAllCallBack mVideoAllCallBack;
    protected Map<String, String> mMapHeadData = new HashMap<String, String>();
    protected NetInfoModule mNetInfoModule;
    protected AudioManager.OnAudioFocusChangeListener onAudioFocusChangeListener = new AudioManager.OnAudioFocusChangeListener(){

        public void onAudioFocusChange(int focusChange) {
            switch (focusChange) {
                case 1: {
                    break;
                }
                case -1: {
                    GSYVideoView.this.post(new Runnable(){

                        @Override
                        public void run() {
                            GSYVideoView.releaseAllVideos();
                        }
                    });
                    break;
                }
                case -2: {
                    try {
                        if (!GSYVideoManager.instance().getMediaPlayer().isPlaying()) break;
                        GSYVideoManager.instance().getMediaPlayer().pause();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break;
                }
            }
        }
    };

    public GSYVideoView(@NonNull Context context) {
        super(context);
        this.init(context);
    }

    public GSYVideoView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public GSYVideoView(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    public GSYVideoView(Context context, Boolean fullFlag) {
        super(context);
        this.mIfCurrentIsFullscreen = fullFlag;
        this.init(context);
    }

    @Override
    protected void showPauseCover() {
        if (this.mCurrentState == 5 && this.mFullPauseBitmap != null && !this.mFullPauseBitmap.isRecycled() && this.mShowPauseCover && this.mSurface != null && this.mSurface.isValid()) {
            RectF rectF = new RectF(0.0f, 0.0f, (float)this.mTextureView.getWidth(), (float)this.mTextureView.getHeight());
            Canvas canvas = this.mSurface.lockCanvas(new Rect(0, 0, this.mTextureView.getWidth(), this.mTextureView.getHeight()));
            if (canvas != null) {
                canvas.drawBitmap(this.mFullPauseBitmap, null, rectF, null);
                this.mSurface.unlockCanvasAndPost(canvas);
            }
        }
    }

    @Override
    protected void releasePauseCover() {
        try {
            if (this.mCurrentState != 5 && this.mFullPauseBitmap != null && !this.mFullPauseBitmap.isRecycled() && this.mShowPauseCover) {
                this.mFullPauseBitmap.recycle();
                this.mFullPauseBitmap = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void updatePauseCover() {
        if ((this.mFullPauseBitmap == null || this.mFullPauseBitmap.isRecycled()) && this.mShowPauseCover) {
            try {
                this.initCover();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.mFullPauseBitmap = null;
            }
        }
    }

    protected Context getActivityContext() {
        return CommonUtil.getActivityContext(this.getContext());
    }

    protected void init(Context context) {
        this.mContext = this.getActivityContext() != null ? this.getActivityContext() : context;
        this.initInflate(this.mContext);
        this.mTextureViewContainer = (ViewGroup)this.findViewById(R.id.surface_container);
        if (this.isInEditMode()) {
            return;
        }
        this.mScreenWidth = this.getActivityContext().getResources().getDisplayMetrics().widthPixels;
        this.mScreenHeight = this.getActivityContext().getResources().getDisplayMetrics().heightPixels;
        this.mAudioManager = (AudioManager)this.getActivityContext().getApplicationContext().getSystemService("audio");
    }

    protected void initInflate(Context context) {
        try {
            View.inflate((Context)context, (int)this.getLayoutId(), (ViewGroup)this);
        }
        catch (InflateException e) {
            if (e.toString().contains("GSYImageCover")) {
                Debuger.printfError("********************\n*****   \u6ce8\u610f   *************************\n*\u8be5\u7248\u672c\u9700\u8981\u6e05\u9664\u5e03\u5c40\u6587\u4ef6\u4e2d\u7684GSYImageCover\n****  Attention  ***\n*Please remove GSYImageCover from Layout in this Version\n********************\n");
                e.printStackTrace();
                throw new InflateException("\u8be5\u7248\u672c\u9700\u8981\u6e05\u9664\u5e03\u5c40\u6587\u4ef6\u4e2d\u7684GSYImageCover\uff0cplease remove GSYImageCover from your layout");
            }
            e.printStackTrace();
        }
    }

    protected void startButtonLogic() {
        if (this.mVideoAllCallBack != null && this.mCurrentState == 0) {
            Debuger.printfLog("onClickStartIcon");
            this.mVideoAllCallBack.onClickStartIcon(this.mOriginUrl, this.mTitle, this);
        } else if (this.mVideoAllCallBack != null) {
            Debuger.printfLog("onClickStartError");
            this.mVideoAllCallBack.onClickStartError(this.mOriginUrl, this.mTitle, this);
        }
        this.prepareVideo();
    }

    protected void prepareVideo() {
        this.startPrepare();
        this.addTextureView();
    }

    protected void startPrepare() {
        if (GSYVideoManager.instance().listener() != null) {
            GSYVideoManager.instance().listener().onCompletion();
        }
        GSYVideoManager.instance().setListener(this);
        GSYVideoManager.instance().setPlayTag(this.mPlayTag);
        GSYVideoManager.instance().setPlayPosition(this.mPlayPosition);
        this.mAudioManager.requestAudioFocus(this.onAudioFocusChangeListener, 3, 2);
        ((Activity)this.getContext()).getWindow().addFlags(128);
        this.mBackUpPlayingBufferState = -1;
        GSYVideoManager.instance().prepare(this.mUrl, this.mMapHeadData, this.mLooping, this.mSpeed);
        this.setStateAndUi(1);
    }

    public boolean setUp(String url, boolean cacheWithPlay, String title) {
        return this.setUp(url, cacheWithPlay, null, title);
    }

    public boolean setUp(String url, boolean cacheWithPlay, File cachePath, Map<String, String> mapHeadData, String title) {
        if (this.setUp(url, cacheWithPlay, cachePath, title)) {
            this.mMapHeadData.clear();
            if (mapHeadData != null) {
                this.mMapHeadData.putAll(mapHeadData);
            }
            return true;
        }
        return false;
    }

    public boolean setUp(String url, boolean cacheWithPlay, File cachePath, String title) {
        this.mCache = cacheWithPlay;
        this.mCachePath = cachePath;
        this.mOriginUrl = url;
        if (this.isCurrentMediaListener() && System.currentTimeMillis() - this.mSaveChangeViewTIme < 2000L) {
            return false;
        }
        this.mCurrentState = 0;
        if (cacheWithPlay && url.startsWith("http") && !url.contains("127.0.0.1") && !url.contains(".m3u8")) {
            HttpProxyCacheServer proxy = GSYVideoManager.getProxy(this.getActivityContext().getApplicationContext(), cachePath);
            url = proxy.getProxyUrl(url);
            boolean bl = this.mCacheFile = !url.startsWith("http");
            if (!this.mCacheFile && GSYVideoManager.instance() != null) {
                proxy.registerCacheListener((CacheListener)GSYVideoManager.instance(), this.mOriginUrl);
            }
        } else if (!(cacheWithPlay || url.startsWith("http") || url.startsWith("rtmp") || url.startsWith("rtsp") || url.contains(".m3u8"))) {
            this.mCacheFile = true;
        }
        this.mUrl = url;
        this.mTitle = title;
        this.setStateAndUi(0);
        return true;
    }

    public void onVideoReset() {
        this.setStateAndUi(0);
    }

    @Override
    public void onVideoPause() {
        if (this.mCurrentState == 1) {
            this.mPauseBeforePrepared = true;
        }
        try {
            if (GSYVideoManager.instance().getMediaPlayer() != null && GSYVideoManager.instance().getMediaPlayer().isPlaying()) {
                this.setStateAndUi(5);
                this.mCurrentPosition = GSYVideoManager.instance().getMediaPlayer().getCurrentPosition();
                if (GSYVideoManager.instance().getMediaPlayer() != null) {
                    GSYVideoManager.instance().getMediaPlayer().pause();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onVideoResume() {
        this.mPauseBeforePrepared = false;
        if (this.mCurrentState == 5) {
            try {
                if (this.mCurrentPosition > 0L && GSYVideoManager.instance().getMediaPlayer() != null) {
                    GSYVideoManager.instance().getMediaPlayer().seekTo(this.mCurrentPosition);
                    GSYVideoManager.instance().getMediaPlayer().start();
                    this.setStateAndUi(2);
                    this.mCurrentPosition = 0L;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void netWorkErrorLogic() {
        final long currentPosition = this.getCurrentPositionWhenPlaying();
        Debuger.printfError("******* Net State Changed. renew player to connect *******" + currentPosition);
        GSYVideoManager.instance().releaseMediaPlayer();
        this.postDelayed(new Runnable(){

            @Override
            public void run() {
                GSYVideoView.this.setSeekOnStart(currentPosition);
                GSYVideoView.this.startPlayLogic();
            }
        }, 500L);
    }

    protected void deleteCacheFileWhenError() {
        this.clearCurrentCache();
        Debuger.printfError("Link Or mCache Error, Please Try Again " + this.mOriginUrl);
        if (this.mCache) {
            Debuger.printfError("mCache Link " + this.mUrl);
        }
        this.mUrl = this.mOriginUrl;
    }

    @Override
    public void onPrepared() {
        if (this.mCurrentState != 1) {
            return;
        }
        try {
            if (GSYVideoManager.instance().getMediaPlayer() != null) {
                GSYVideoManager.instance().getMediaPlayer().start();
            }
            this.setStateAndUi(2);
            if (this.mVideoAllCallBack != null && this.isCurrentMediaListener()) {
                Debuger.printfLog("onPrepared");
                this.mVideoAllCallBack.onPrepared(this.mOriginUrl, this.mTitle, this);
            }
            if (GSYVideoManager.instance().getMediaPlayer() != null && this.mSeekOnStart > 0L) {
                GSYVideoManager.instance().getMediaPlayer().seekTo(this.mSeekOnStart);
                this.mSeekOnStart = 0L;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.createNetWorkState();
        this.listenerNetWorkState();
        this.mHadPlay = true;
        if (this.mTextureView != null) {
            this.mTextureView.onResume();
        }
        if (this.mPauseBeforePrepared) {
            this.onVideoPause();
            this.mPauseBeforePrepared = false;
        }
    }

    @Override
    public void onAutoCompletion() {
        this.setStateAndUi(6);
        this.mSaveChangeViewTIme = 0L;
        if (this.mTextureViewContainer.getChildCount() > 0) {
            this.mTextureViewContainer.removeAllViews();
        }
        if (!this.mIfCurrentIsFullscreen) {
            GSYVideoManager.instance().setLastListener(null);
        }
        this.mAudioManager.abandonAudioFocus(this.onAudioFocusChangeListener);
        ((Activity)this.getContext()).getWindow().clearFlags(128);
        this.releaseNetWorkState();
        if (this.mVideoAllCallBack != null && this.isCurrentMediaListener()) {
            Debuger.printfLog("onAutoComplete");
            this.mVideoAllCallBack.onAutoComplete(this.mOriginUrl, this.mTitle, this);
        }
    }

    @Override
    public void onCompletion() {
        this.setStateAndUi(0);
        this.mSaveChangeViewTIme = 0L;
        if (this.mTextureViewContainer.getChildCount() > 0) {
            this.mTextureViewContainer.removeAllViews();
        }
        if (!this.mIfCurrentIsFullscreen) {
            GSYVideoManager.instance().setListener(null);
            GSYVideoManager.instance().setLastListener(null);
        }
        GSYVideoManager.instance().setCurrentVideoHeight(0);
        GSYVideoManager.instance().setCurrentVideoWidth(0);
        this.mAudioManager.abandonAudioFocus(this.onAudioFocusChangeListener);
        ((Activity)this.getContext()).getWindow().clearFlags(128);
        this.releaseNetWorkState();
    }

    @Override
    public void onSeekComplete() {
    }

    @Override
    public void onError(int what, int extra) {
        if (this.mNetChanged) {
            this.mNetChanged = false;
            this.netWorkErrorLogic();
            if (this.mVideoAllCallBack != null) {
                this.mVideoAllCallBack.onPlayError(this.mOriginUrl, this.mTitle, this);
            }
            return;
        }
        if (what != 38 && what != -38) {
            this.setStateAndUi(7);
            this.deleteCacheFileWhenError();
            if (this.mVideoAllCallBack != null) {
                this.mVideoAllCallBack.onPlayError(this.mOriginUrl, this.mTitle, this);
            }
        }
    }

    @Override
    public void onInfo(int what, int extra) {
        if (what == 701) {
            this.mBackUpPlayingBufferState = this.mCurrentState;
            if (this.mHadPlay && this.mCurrentState != 1 && this.mCurrentState > 0) {
                this.setStateAndUi(3);
            }
        } else if (what == 702) {
            if (this.mBackUpPlayingBufferState != -1) {
                if (this.mHadPlay && this.mCurrentState != 1 && this.mCurrentState > 0) {
                    this.setStateAndUi(this.mBackUpPlayingBufferState);
                }
                this.mBackUpPlayingBufferState = -1;
            }
        } else if (what == 10001) {
            this.mRotate = extra;
            Debuger.printfLog("Video Rotate Info " + extra);
            if (this.mTextureView != null) {
                this.mTextureView.setRotation(this.mRotate);
            }
        }
    }

    @Override
    public void onVideoSizeChanged() {
        int mVideoWidth = GSYVideoManager.instance().getCurrentVideoWidth();
        int mVideoHeight = GSYVideoManager.instance().getCurrentVideoHeight();
        if (mVideoWidth != 0 && mVideoHeight != 0 && this.mTextureView != null) {
            this.mTextureView.requestLayout();
        }
    }

    public void clearCurrentCache() {
        if (this.mCacheFile && this.mCache) {
            Debuger.printfError(" mCacheFile Local Error " + this.mUrl);
            CommonUtil.deleteFile(this.mUrl.replace("file://", ""));
            this.mUrl = this.mOriginUrl;
        } else if (this.mUrl.contains("127.0.0.1")) {
            Md5FileNameGenerator md5FileNameGenerator = new Md5FileNameGenerator();
            String name = md5FileNameGenerator.generate(this.mOriginUrl);
            if (this.mCachePath != null) {
                String path = this.mCachePath.getAbsolutePath() + File.separator + name + ".download";
                CommonUtil.deleteFile(path);
            } else {
                String path = StorageUtils.getIndividualCacheDirectory(this.getActivityContext().getApplicationContext()).getAbsolutePath() + File.separator + name + ".download";
                CommonUtil.deleteFile(path);
            }
        }
    }

    public int getCurrentPositionWhenPlaying() {
        int position = 0;
        if (this.mCurrentState == 2 || this.mCurrentState == 5) {
            try {
                position = (int)GSYVideoManager.instance().getMediaPlayer().getCurrentPosition();
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
                return position;
            }
        }
        if (position == 0 && this.mCurrentPosition > 0L) {
            return (int)this.mCurrentPosition;
        }
        return position;
    }

    public int getDuration() {
        int duration = 0;
        try {
            duration = (int)GSYVideoManager.instance().getMediaPlayer().getDuration();
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
            return duration;
        }
        return duration;
    }

    public static void releaseAllVideos() {
        if (GSYVideoManager.instance().listener() != null) {
            GSYVideoManager.instance().listener().onCompletion();
        }
        GSYVideoManager.instance().releaseMediaPlayer();
    }

    public void release() {
        this.mSaveChangeViewTIme = 0L;
        if (this.isCurrentMediaListener() && System.currentTimeMillis() - this.mSaveChangeViewTIme > 2000L) {
            GSYVideoView.releaseAllVideos();
        }
    }

    protected boolean isCurrentMediaListener() {
        return GSYVideoManager.instance().listener() != null && GSYVideoManager.instance().listener() == this;
    }

    protected void createNetWorkState() {
        if (this.mNetInfoModule == null) {
            this.mNetInfoModule = new NetInfoModule(this.getActivityContext().getApplicationContext(), new NetInfoModule.NetChangeListener(){

                @Override
                public void changed(String state) {
                    if (!GSYVideoView.this.mNetSate.equals(state)) {
                        Debuger.printfError("******* change network state ******* " + state);
                        GSYVideoView.this.mNetChanged = true;
                    }
                    GSYVideoView.this.mNetSate = state;
                }
            });
            this.mNetSate = this.mNetInfoModule.getCurrentConnectionType();
        }
    }

    protected void listenerNetWorkState() {
        if (this.mNetInfoModule != null) {
            this.mNetInfoModule.onHostResume();
        }
    }

    protected void unListenerNetWorkState() {
        if (this.mNetInfoModule != null) {
            this.mNetInfoModule.onHostPause();
        }
    }

    protected void releaseNetWorkState() {
        if (this.mNetInfoModule != null) {
            this.mNetInfoModule.onHostPause();
            this.mNetInfoModule = null;
        }
    }

    protected abstract void setStateAndUi(int var1);

    public abstract int getLayoutId();

    public abstract void startPlayLogic();

    public void setIjkLibLoader(IjkLibLoader libLoader) {
        GSYVideoManager.setIjkLibLoader(libLoader);
    }

    public int getCurrentState() {
        return this.mCurrentState;
    }

    public String getPlayTag() {
        return this.mPlayTag;
    }

    public void setPlayTag(String playTag) {
        this.mPlayTag = playTag;
    }

    public int getPlayPosition() {
        return this.mPlayPosition;
    }

    public void setPlayPosition(int playPosition) {
        this.mPlayPosition = playPosition;
    }

    public long getNetSpeed() {
        if (GSYVideoManager.instance().getMediaPlayer() != null && GSYVideoManager.instance().getMediaPlayer() instanceof IjkMediaPlayer) {
            try {
                return ((IjkMediaPlayer)GSYVideoManager.instance().getMediaPlayer()).getTcpSpeed();
            }
            catch (Exception e) {
                e.printStackTrace();
                return -1L;
            }
        }
        return -1L;
    }

    public String getNetSpeedText() {
        long speed = this.getNetSpeed();
        return CommonUtil.getTextSpeed(speed);
    }

    public long getSeekOnStart() {
        return this.mSeekOnStart;
    }

    public void setSeekOnStart(long seekOnStart) {
        this.mSeekOnStart = seekOnStart;
    }

    public int getBuffterPoint() {
        return this.mBuffterPoint;
    }

    public boolean isIfCurrentIsFullscreen() {
        return this.mIfCurrentIsFullscreen;
    }

    public void setIfCurrentIsFullscreen(boolean ifCurrentIsFullscreen) {
        this.mIfCurrentIsFullscreen = ifCurrentIsFullscreen;
    }

    public boolean isLooping() {
        return this.mLooping;
    }

    public void setLooping(boolean looping) {
        this.mLooping = looping;
    }

    public void setVideoAllCallBack(VideoAllCallBack mVideoAllCallBack) {
        this.mVideoAllCallBack = mVideoAllCallBack;
    }

    public float getSpeed() {
        return this.mSpeed;
    }

    public void setSpeed(float speed) {
        this.setSpeed(speed, false);
    }

    public void setSpeed(float speed, boolean soundTouch) {
        this.mSpeed = speed;
        this.mSoundTouch = soundTouch;
        if (GSYVideoManager.instance().getMediaPlayer() != null && GSYVideoManager.instance().getMediaPlayer() instanceof IjkMediaPlayer && speed > 0.0f) {
            try {
                ((IjkMediaPlayer)GSYVideoManager.instance().getMediaPlayer()).setSpeed(speed);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (this.mSoundTouch) {
                VideoOptionModel videoOptionModel = new VideoOptionModel(4, "soundtouch", 1);
                List<VideoOptionModel> list = GSYVideoManager.instance().getOptionModelList();
                if (list != null) {
                    list.add(videoOptionModel);
                } else {
                    list = new ArrayList<VideoOptionModel>();
                    list.add(videoOptionModel);
                }
                GSYVideoManager.instance().setOptionModelList(list);
            }
        }
    }

    public void setSpeedPlaying(float speed, boolean soundTouch) {
        this.setSpeed(speed, soundTouch);
        if (GSYVideoManager.instance().getMediaPlayer() != null) {
            IjkMediaPlayer ijkMediaPlayer = (IjkMediaPlayer)GSYVideoManager.instance().getMediaPlayer();
            try {
                ijkMediaPlayer.setSpeed(speed);
                ijkMediaPlayer.setOption(4, "soundtouch", soundTouch ? 1L : 0L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isShowPauseCover() {
        return this.mShowPauseCover;
    }

    public void setShowPauseCover(boolean showPauseCover) {
        this.mShowPauseCover = showPauseCover;
    }

    public void seekTo(long position) {
        try {
            if (GSYVideoManager.instance().getMediaPlayer() != null && position > 0L) {
                GSYVideoManager.instance().getMediaPlayer().seekTo(position);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

