/*
 * Decompiled with CFR 0.152.
 */
package com.shuyu.gsyvideoplayer.video;

import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.shuyu.gsyvideoplayer.model.GSYVideoModel;
import com.shuyu.gsyvideoplayer.video.StandardGSYVideoPlayer;
import com.shuyu.gsyvideoplayer.video.base.GSYBaseVideoPlayer;
import com.shuyu.gsyvideoplayer.video.base.GSYVideoPlayer;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import moe.codeest.enviews.ENDownloadView;

public class ListGSYVideoPlayer
extends StandardGSYVideoPlayer {
    protected List<GSYVideoModel> mUriList = new ArrayList<GSYVideoModel>();
    protected int mPlayPosition;

    public ListGSYVideoPlayer(Context context, Boolean fullFlag) {
        super(context, fullFlag);
    }

    public ListGSYVideoPlayer(Context context) {
        super(context);
    }

    public ListGSYVideoPlayer(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public boolean setUp(List<GSYVideoModel> url, boolean cacheWithPlay, int position) {
        this.mUriList = url;
        this.mPlayPosition = position;
        GSYVideoModel gsyVideoModel = url.get(position);
        boolean set = this.setUp(gsyVideoModel.getUrl(), cacheWithPlay, gsyVideoModel.getTitle());
        if (!TextUtils.isEmpty((CharSequence)gsyVideoModel.getTitle())) {
            this.mTitleTextView.setText((CharSequence)gsyVideoModel.getTitle());
        }
        return set;
    }

    public boolean setUp(List<GSYVideoModel> url, boolean cacheWithPlay, int position, File cachePath) {
        this.mUriList = url;
        this.mPlayPosition = position;
        GSYVideoModel gsyVideoModel = url.get(position);
        boolean set = this.setUp(gsyVideoModel.getUrl(), cacheWithPlay, cachePath, gsyVideoModel.getTitle());
        if (!TextUtils.isEmpty((CharSequence)gsyVideoModel.getTitle())) {
            this.mTitleTextView.setText((CharSequence)gsyVideoModel.getTitle());
        }
        return set;
    }

    @Override
    public GSYBaseVideoPlayer startWindowFullscreen(Context context, boolean actionBar, boolean statusBar) {
        GSYBaseVideoPlayer gsyBaseVideoPlayer = super.startWindowFullscreen(context, actionBar, statusBar);
        if (gsyBaseVideoPlayer != null) {
            ListGSYVideoPlayer listGSYVideoPlayer = (ListGSYVideoPlayer)gsyBaseVideoPlayer;
            listGSYVideoPlayer.mPlayPosition = this.mPlayPosition;
            listGSYVideoPlayer.mUriList = this.mUriList;
            GSYVideoModel gsyVideoModel = this.mUriList.get(this.mPlayPosition);
            if (!TextUtils.isEmpty((CharSequence)gsyVideoModel.getTitle())) {
                listGSYVideoPlayer.mTitleTextView.setText((CharSequence)gsyVideoModel.getTitle());
            }
        }
        return gsyBaseVideoPlayer;
    }

    @Override
    protected void resolveNormalVideoShow(View oldF, ViewGroup vp, GSYVideoPlayer gsyVideoPlayer) {
        if (gsyVideoPlayer != null) {
            ListGSYVideoPlayer listGSYVideoPlayer = (ListGSYVideoPlayer)gsyVideoPlayer;
            this.mPlayPosition = listGSYVideoPlayer.mPlayPosition;
            this.mUriList = listGSYVideoPlayer.mUriList;
            GSYVideoModel gsyVideoModel = this.mUriList.get(this.mPlayPosition);
            if (!TextUtils.isEmpty((CharSequence)gsyVideoModel.getTitle())) {
                this.mTitleTextView.setText((CharSequence)gsyVideoModel.getTitle());
            }
        }
        super.resolveNormalVideoShow(oldF, vp, gsyVideoPlayer);
    }

    @Override
    public void onCompletion() {
        if (this.mPlayPosition < this.mUriList.size() - 1) {
            return;
        }
        super.onCompletion();
    }

    @Override
    public void onAutoCompletion() {
        if (this.mPlayPosition < this.mUriList.size() - 1) {
            ++this.mPlayPosition;
            GSYVideoModel gsyVideoModel = this.mUriList.get(this.mPlayPosition);
            this.setUp(gsyVideoModel.getUrl(), this.mCache, this.mCachePath, gsyVideoModel.getTitle());
            if (!TextUtils.isEmpty((CharSequence)gsyVideoModel.getTitle())) {
                this.mTitleTextView.setText((CharSequence)gsyVideoModel.getTitle());
            }
            this.startPlayLogic();
            return;
        }
        super.onAutoCompletion();
    }

    @Override
    protected void prepareVideo() {
        this.startPrepare();
    }

    @Override
    public void onPrepared() {
        super.onPrepared();
        this.addTextureView();
    }

    @Override
    protected void changeUiToNormal() {
        super.changeUiToNormal();
        if (this.mHadPlay && this.mPlayPosition < this.mUriList.size() - 1) {
            this.setViewShowState((View)this.mThumbImageViewLayout, 8);
            this.setViewShowState((View)this.mTopContainer, 4);
            this.setViewShowState((View)this.mBottomContainer, 4);
            this.setViewShowState(this.mStartButton, 8);
            this.setViewShowState(this.mLoadingProgressBar, 0);
            this.setViewShowState((View)this.mBottomProgressBar, 4);
            this.setViewShowState((View)this.mLockScreen, 8);
            if (this.mLoadingProgressBar instanceof ENDownloadView) {
                ((ENDownloadView)this.mLoadingProgressBar).start();
            }
        }
    }
}

