/*
 * Decompiled with CFR 0.152.
 */
package com.shuyu.gsyvideoplayer;

import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.view.View;
import com.shuyu.gsyvideoplayer.builder.GSYVideoOptionBuilder;
import com.shuyu.gsyvideoplayer.listener.StandardVideoAllCallBack;
import com.shuyu.gsyvideoplayer.utils.OrientationUtils;
import com.shuyu.gsyvideoplayer.video.StandardGSYVideoPlayer;
import com.shuyu.gsyvideoplayer.video.base.GSYBaseVideoPlayer;

public abstract class GSYBaseActivityDetail
extends AppCompatActivity
implements StandardVideoAllCallBack {
    protected boolean isPlay;
    protected boolean isPause;
    protected OrientationUtils orientationUtils;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    public void initVideo() {
        this.orientationUtils = new OrientationUtils((Activity)this, this.getGSYVideoPlayer());
        this.orientationUtils.setEnable(false);
        if (this.getGSYVideoPlayer().getFullscreenButton() != null) {
            this.getGSYVideoPlayer().getFullscreenButton().setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    GSYBaseActivityDetail.this.orientationUtils.resolveByClick();
                    GSYBaseActivityDetail.this.getGSYVideoPlayer().startWindowFullscreen((Context)GSYBaseActivityDetail.this, true, true);
                    GSYBaseActivityDetail.this.clickForFullScreen();
                }
            });
        }
    }

    public void initVideoBuilderMode() {
        this.initVideo();
        this.getGSYVideoOptionBuilder().setVideoAllCallBack(this).build(this.getGSYVideoPlayer());
    }

    public void onBackPressed() {
        if (this.orientationUtils != null) {
            this.orientationUtils.backToProtVideo();
        }
        if (StandardGSYVideoPlayer.backFromWindowFull((Context)this)) {
            return;
        }
        super.onBackPressed();
    }

    protected void onPause() {
        super.onPause();
        this.getGSYVideoPlayer().getCurrentPlayer().onVideoPause();
        this.isPause = true;
    }

    protected void onResume() {
        super.onResume();
        this.getGSYVideoPlayer().getCurrentPlayer().onVideoResume();
        this.isPause = false;
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.isPlay) {
            this.getGSYVideoPlayer().getCurrentPlayer().release();
        }
        if (this.orientationUtils != null) {
            this.orientationUtils.releaseListener();
        }
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (this.isPlay && !this.isPause) {
            this.getGSYVideoPlayer().onConfigurationChanged((Activity)this, newConfig, this.orientationUtils);
        }
    }

    @Override
    public void onPrepared(String url, Object ... objects) {
        if (this.orientationUtils == null) {
            throw new NullPointerException("initVideo() or initVideoBuilderMode() first");
        }
        this.orientationUtils.setEnable(this.getDetailOrientationRotateAuto());
        this.isPlay = true;
    }

    @Override
    public void onClickStartIcon(String url, Object ... objects) {
    }

    @Override
    public void onClickStartError(String url, Object ... objects) {
    }

    @Override
    public void onClickStop(String url, Object ... objects) {
    }

    @Override
    public void onClickStopFullscreen(String url, Object ... objects) {
    }

    @Override
    public void onClickResume(String url, Object ... objects) {
    }

    @Override
    public void onClickResumeFullscreen(String url, Object ... objects) {
    }

    @Override
    public void onClickSeekbar(String url, Object ... objects) {
    }

    @Override
    public void onClickSeekbarFullscreen(String url, Object ... objects) {
    }

    @Override
    public void onAutoComplete(String url, Object ... objects) {
    }

    @Override
    public void onEnterFullscreen(String url, Object ... objects) {
    }

    @Override
    public void onQuitFullscreen(String url, Object ... objects) {
        if (this.orientationUtils != null) {
            this.orientationUtils.backToProtVideo();
        }
    }

    @Override
    public void onQuitSmallWidget(String url, Object ... objects) {
    }

    @Override
    public void onEnterSmallWidget(String url, Object ... objects) {
    }

    @Override
    public void onTouchScreenSeekVolume(String url, Object ... objects) {
    }

    @Override
    public void onTouchScreenSeekPosition(String url, Object ... objects) {
    }

    @Override
    public void onTouchScreenSeekLight(String url, Object ... objects) {
    }

    @Override
    public void onPlayError(String url, Object ... objects) {
    }

    @Override
    public void onClickStartThumb(String url, Object ... objects) {
    }

    @Override
    public void onClickBlank(String url, Object ... objects) {
    }

    @Override
    public void onClickBlankFullscreen(String url, Object ... objects) {
    }

    public abstract GSYBaseVideoPlayer getGSYVideoPlayer();

    public abstract GSYVideoOptionBuilder getGSYVideoOptionBuilder();

    public abstract void clickForFullScreen();

    public abstract boolean getDetailOrientationRotateAuto();
}

