/*
 * Decompiled with CFR 0.152.
 */
package com.shuyu.gsyvideoplayer;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.view.SurfaceHolder;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.shuyu.gsyvideoplayer.GSYSurfaceView;
import com.shuyu.gsyvideoplayer.GSYTextureView;
import com.shuyu.gsyvideoplayer.utils.GSYVideoType;

public class GSYRenderView {
    private View mShowView;

    public void setTransform(Matrix transform) {
        if (this.mShowView instanceof TextureView) {
            ((TextureView)this.mShowView).setTransform(transform);
        }
    }

    public void requestLayout() {
        this.mShowView.requestLayout();
    }

    public float getRotation() {
        return this.mShowView.getRotation();
    }

    public void setRotation(float rotation) {
        this.mShowView.setRotation(rotation);
    }

    public void invalidate() {
        this.mShowView.invalidate();
    }

    public int getWidth() {
        return this.mShowView.getWidth();
    }

    public int getHeight() {
        return this.mShowView.getHeight();
    }

    public Bitmap initCover() {
        if (this.mShowView != null && this.mShowView instanceof GSYTextureView) {
            GSYTextureView textureView = (GSYTextureView)this.mShowView;
            Bitmap bitmap = Bitmap.createBitmap((int)textureView.getSizeW(), (int)textureView.getSizeH(), (Bitmap.Config)Bitmap.Config.RGB_565);
            return textureView.getBitmap(bitmap);
        }
        return null;
    }

    public ViewGroup.LayoutParams getLayoutParams() {
        return this.mShowView.getLayoutParams();
    }

    public void setLayoutParams(ViewGroup.LayoutParams layoutParams) {
        this.mShowView.setLayoutParams(layoutParams);
    }

    public void addTextureView(Context context, ViewGroup textureViewContainer, int rotate, TextureView.SurfaceTextureListener listener) {
        if (textureViewContainer.getChildCount() > 0) {
            textureViewContainer.removeAllViews();
        }
        GSYTextureView gsyTextureView = new GSYTextureView(context);
        gsyTextureView.setSurfaceTextureListener(listener);
        gsyTextureView.setRotation(rotate);
        this.mShowView = gsyTextureView;
        int params = this.getTextureParams();
        if (textureViewContainer instanceof RelativeLayout) {
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(params, params);
            layoutParams.addRule(13);
            textureViewContainer.addView((View)gsyTextureView, (ViewGroup.LayoutParams)layoutParams);
        } else if (textureViewContainer instanceof FrameLayout) {
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(params, params);
            layoutParams.gravity = 17;
            textureViewContainer.addView((View)gsyTextureView, (ViewGroup.LayoutParams)layoutParams);
        }
    }

    public void addSurfaceView(Context context, ViewGroup textureViewContainer, int rotate, SurfaceHolder.Callback2 callback2) {
        if (textureViewContainer.getChildCount() > 0) {
            textureViewContainer.removeAllViews();
        }
        GSYSurfaceView showSurfaceView = new GSYSurfaceView(context);
        showSurfaceView.getHolder().addCallback((SurfaceHolder.Callback)callback2);
        showSurfaceView.setRotation(rotate);
        this.mShowView = showSurfaceView;
        int params = this.getTextureParams();
        if (textureViewContainer instanceof RelativeLayout) {
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(params, params);
            layoutParams.addRule(13);
            textureViewContainer.addView((View)showSurfaceView, (ViewGroup.LayoutParams)layoutParams);
        } else if (textureViewContainer instanceof FrameLayout) {
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(params, params);
            layoutParams.gravity = 17;
            textureViewContainer.addView((View)showSurfaceView, (ViewGroup.LayoutParams)layoutParams);
        }
    }

    protected int getTextureParams() {
        boolean typeChanged = GSYVideoType.getShowType() != 0;
        return typeChanged ? -2 : -1;
    }
}

