/*
 * Decompiled with CFR 0.152.
 */
package com.shuyu.gsyvideoplayer.utils;

import android.app.Activity;
import android.content.Context;
import android.graphics.Point;
import android.os.Handler;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.shuyu.gsyvideoplayer.listener.StandardVideoAllCallBack;
import com.shuyu.gsyvideoplayer.utils.CommonUtil;
import com.shuyu.gsyvideoplayer.utils.Debuger;
import com.shuyu.gsyvideoplayer.utils.OrientationUtils;
import com.shuyu.gsyvideoplayer.video.GSYBaseVideoPlayer;
import com.shuyu.gsyvideoplayer.video.GSYVideoPlayer;
import com.shuyu.gsyvideoplayer.video.StandardGSYVideoPlayer;
import com.transitionseverywhere.TransitionManager;
import java.io.File;
import java.util.Map;

public class ListVideoUtil {
    private String TAG = "NULL";
    private StandardGSYVideoPlayer gsyVideoPlayer;
    private ViewGroup fullViewContainer;
    private ViewGroup listParent;
    private ViewGroup.LayoutParams listParams;
    private OrientationUtils orientationUtils;
    private StandardVideoAllCallBack videoAllCallBack;
    private String url;
    private Context context;
    private File cachePath;
    private String mTitle;
    private Map<String, String> mapHeadData;
    private int playPosition = -1;
    private int speed = 1;
    private int systemUiVisibility;
    private boolean isFull;
    private boolean isSmall;
    private boolean hideStatusBar;
    private boolean hideActionBar;
    private boolean isLoop;
    private boolean hideKey = true;
    private boolean needLockFull = true;
    protected boolean needShowWifiTip = true;
    private int[] listItemRect;
    private int[] listItemSize;
    private boolean fullLandFrist = true;
    private boolean autoRotation = true;
    private boolean showFullAnimation = true;
    private Handler handler = new Handler();

    public ListVideoUtil(Context context) {
        this.gsyVideoPlayer = new StandardGSYVideoPlayer(context);
        this.context = context;
    }

    public void addVideoPlayer(int position, View imgView, String tag, ViewGroup container, View playBtn) {
        container.removeAllViews();
        if (this.isCurrentViewPlaying(position, tag)) {
            if (!this.isFull) {
                ViewGroup viewGroup = (ViewGroup)this.gsyVideoPlayer.getParent();
                if (viewGroup != null) {
                    viewGroup.removeAllViews();
                }
                container.addView((View)this.gsyVideoPlayer);
                playBtn.setVisibility(4);
            }
        } else {
            playBtn.setVisibility(0);
            container.removeAllViews();
            container.addView(imgView);
        }
    }

    public void setPlayPositionAndTag(int playPosition, String tag) {
        this.playPosition = playPosition;
        this.TAG = tag;
    }

    public void startPlay(String url) {
        if (this.isSmall()) {
            this.smallVideoToNormal();
        }
        this.url = url;
        this.gsyVideoPlayer.release();
        this.gsyVideoPlayer.setLooping(this.isLoop);
        this.gsyVideoPlayer.setSpeed(this.speed);
        this.gsyVideoPlayer.setNeedShowWifiTip(this.needShowWifiTip);
        this.gsyVideoPlayer.setNeedLockFull(this.needLockFull);
        this.gsyVideoPlayer.setUp(url, true, this.cachePath, this.mapHeadData, this.mTitle);
        if (!TextUtils.isEmpty((CharSequence)this.mTitle)) {
            this.gsyVideoPlayer.getTitleTextView().setText((CharSequence)this.mTitle);
        }
        this.gsyVideoPlayer.getTitleTextView().setVisibility(8);
        this.gsyVideoPlayer.getBackButton().setVisibility(8);
        this.gsyVideoPlayer.getFullscreenButton().setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ListVideoUtil.this.resolveFullBtn();
            }
        });
        this.gsyVideoPlayer.startPlayLogic();
    }

    public void resolveFullBtn() {
        if (this.fullViewContainer == null) {
            return;
        }
        if (!this.isFull) {
            this.resolveToFull();
        } else {
            this.resolveMaterialToNormal(this.gsyVideoPlayer);
        }
    }

    private void resolveToFull() {
        this.systemUiVisibility = ((Activity)this.context).getWindow().getDecorView().getSystemUiVisibility();
        CommonUtil.hideSupportActionBar(this.context, this.hideActionBar, this.hideStatusBar);
        if (this.hideKey) {
            CommonUtil.hideNavKey(this.context);
        }
        this.isFull = true;
        ViewGroup viewGroup = (ViewGroup)this.gsyVideoPlayer.getParent();
        this.listParams = this.gsyVideoPlayer.getLayoutParams();
        if (viewGroup != null) {
            this.listParent = viewGroup;
            viewGroup.removeView((View)this.gsyVideoPlayer);
        }
        this.gsyVideoPlayer.setIfCurrentIsFullscreen(true);
        this.gsyVideoPlayer.getFullscreenButton().setImageResource(this.gsyVideoPlayer.getShrinkImageRes());
        this.gsyVideoPlayer.getBackButton().setVisibility(0);
        this.orientationUtils = new OrientationUtils((Activity)this.context, this.gsyVideoPlayer);
        this.orientationUtils.setEnable(this.isAutoRotation());
        this.gsyVideoPlayer.getBackButton().setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ListVideoUtil.this.resolveMaterialToNormal(ListVideoUtil.this.gsyVideoPlayer);
            }
        });
        if (this.showFullAnimation) {
            if (this.fullViewContainer instanceof FrameLayout) {
                this.resolveMaterialAnimation();
            } else {
                this.resolveFullAdd();
            }
        } else {
            this.resolveFullAdd();
        }
    }

    private void resolveFullAdd() {
        this.fullViewContainer.setBackgroundColor(-16777216);
        this.fullViewContainer.addView((View)this.gsyVideoPlayer);
        this.resolveChangeFirstLogic(50);
    }

    private void resolveMaterialAnimation() {
        this.listItemRect = new int[2];
        this.listItemSize = new int[2];
        this.saveLocationStatus(this.context, this.hideStatusBar, this.hideActionBar);
        FrameLayout.LayoutParams lpParent = new FrameLayout.LayoutParams(-1, -1);
        FrameLayout frameLayout = new FrameLayout(this.context);
        frameLayout.setBackgroundColor(-16777216);
        FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(this.listItemSize[0], this.listItemSize[1]);
        lp.setMargins(this.listItemRect[0], this.listItemRect[1], 0, 0);
        frameLayout.addView((View)this.gsyVideoPlayer, (ViewGroup.LayoutParams)lp);
        this.fullViewContainer.addView((View)frameLayout, (ViewGroup.LayoutParams)lpParent);
        this.handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                TransitionManager.beginDelayedTransition((ViewGroup)ListVideoUtil.this.fullViewContainer);
                ListVideoUtil.this.resolveMaterialFullVideoShow(ListVideoUtil.this.gsyVideoPlayer);
                ListVideoUtil.this.resolveChangeFirstLogic(600);
            }
        }, 300L);
    }

    private void resolveMaterialFullVideoShow(GSYBaseVideoPlayer gsyVideoPlayer) {
        FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)gsyVideoPlayer.getLayoutParams();
        lp.setMargins(0, 0, 0, 0);
        lp.height = -1;
        lp.width = -1;
        lp.gravity = 17;
        gsyVideoPlayer.setLayoutParams((ViewGroup.LayoutParams)lp);
        gsyVideoPlayer.setIfCurrentIsFullscreen(true);
    }

    private void resolveToNormal() {
        int delay = this.orientationUtils.backToProtVideo();
        this.handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                ListVideoUtil.this.isFull = false;
                ListVideoUtil.this.fullViewContainer.removeAllViews();
                if (ListVideoUtil.this.gsyVideoPlayer.getParent() != null) {
                    ((ViewGroup)ListVideoUtil.this.gsyVideoPlayer.getParent()).removeView((View)ListVideoUtil.this.gsyVideoPlayer);
                }
                ListVideoUtil.this.orientationUtils.setEnable(false);
                ListVideoUtil.this.gsyVideoPlayer.setIfCurrentIsFullscreen(false);
                ListVideoUtil.this.fullViewContainer.setBackgroundColor(0);
                ListVideoUtil.this.listParent.addView((View)ListVideoUtil.this.gsyVideoPlayer, ListVideoUtil.this.listParams);
                ListVideoUtil.this.gsyVideoPlayer.getFullscreenButton().setImageResource(ListVideoUtil.this.gsyVideoPlayer.getEnlargeImageRes());
                ListVideoUtil.this.gsyVideoPlayer.getBackButton().setVisibility(8);
                ListVideoUtil.this.gsyVideoPlayer.setIfCurrentIsFullscreen(false);
                if (ListVideoUtil.this.videoAllCallBack != null) {
                    Debuger.printfLog("onQuitFullscreen");
                    ListVideoUtil.this.videoAllCallBack.onQuitFullscreen(ListVideoUtil.this.url, ListVideoUtil.this.mTitle, ListVideoUtil.this.gsyVideoPlayer);
                }
                if (ListVideoUtil.this.hideKey) {
                    CommonUtil.showNavKey(ListVideoUtil.this.context, ListVideoUtil.this.systemUiVisibility);
                }
                CommonUtil.showSupportActionBar(ListVideoUtil.this.context, ListVideoUtil.this.hideActionBar, ListVideoUtil.this.hideStatusBar);
            }
        }, (long)delay);
    }

    private void resolveMaterialToNormal(final GSYVideoPlayer gsyVideoPlayer) {
        if (this.showFullAnimation && this.fullViewContainer instanceof FrameLayout) {
            int delay = this.orientationUtils.backToProtVideo();
            this.handler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    TransitionManager.beginDelayedTransition((ViewGroup)ListVideoUtil.this.fullViewContainer);
                    FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)gsyVideoPlayer.getLayoutParams();
                    lp.setMargins(ListVideoUtil.this.listItemRect[0], ListVideoUtil.this.listItemRect[1], 0, 0);
                    lp.width = ListVideoUtil.this.listItemSize[0];
                    lp.height = ListVideoUtil.this.listItemSize[1];
                    lp.gravity = 0;
                    gsyVideoPlayer.setLayoutParams((ViewGroup.LayoutParams)lp);
                    ListVideoUtil.this.handler.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            ListVideoUtil.this.resolveToNormal();
                        }
                    }, 400L);
                }
            }, (long)delay);
        } else {
            this.resolveToNormal();
        }
    }

    private void resolveChangeFirstLogic(int time) {
        if (this.isFullLandFrist()) {
            this.handler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (ListVideoUtil.this.orientationUtils.getIsLand() != 1) {
                        ListVideoUtil.this.orientationUtils.resolveByClick();
                    }
                }
            }, (long)time);
        }
        this.gsyVideoPlayer.setIfCurrentIsFullscreen(true);
        if (this.videoAllCallBack != null) {
            Debuger.printfLog("onEnterFullscreen");
            this.videoAllCallBack.onEnterFullscreen(this.url, this.mTitle, this.gsyVideoPlayer);
        }
    }

    private void saveLocationStatus(Context context, boolean statusBar, boolean actionBar) {
        this.listParent.getLocationOnScreen(this.listItemRect);
        int statusBarH = CommonUtil.getStatusBarHeight(context);
        int actionBerH = CommonUtil.getActionBarHeight((Activity)context);
        if (statusBar) {
            this.listItemRect[1] = this.listItemRect[1] - statusBarH;
        }
        if (actionBar) {
            this.listItemRect[1] = this.listItemRect[1] - actionBerH;
        }
        this.listItemSize[0] = this.listParent.getWidth();
        this.listItemSize[1] = this.listParent.getHeight();
    }

    private boolean isPlayView(int position, String tag) {
        return this.playPosition == position && this.TAG.equals(tag);
    }

    private boolean isCurrentViewPlaying(int position, String tag) {
        return this.isPlayView(position, tag);
    }

    public boolean backFromFull() {
        boolean isFull = false;
        if (this.fullViewContainer.getChildCount() > 0) {
            isFull = true;
            this.resolveMaterialToNormal(this.gsyVideoPlayer);
        }
        return isFull;
    }

    public void releaseVideoPlayer() {
        ViewGroup viewGroup = (ViewGroup)this.gsyVideoPlayer.getParent();
        if (viewGroup != null) {
            viewGroup.removeAllViews();
        }
        this.playPosition = -1;
        this.TAG = "NULL";
        if (this.orientationUtils != null) {
            this.orientationUtils.releaseListener();
        }
    }

    public void showSmallVideo(Point size, boolean actionBar, boolean statusBar) {
        if (this.gsyVideoPlayer.getCurrentState() == 2) {
            this.gsyVideoPlayer.showSmallVideo(size, actionBar, statusBar);
            this.isSmall = true;
        }
    }

    public void smallVideoToNormal() {
        this.isSmall = false;
        this.gsyVideoPlayer.hideSmallVideo();
    }

    public void setFullViewContainer(ViewGroup fullViewContainer) {
        this.fullViewContainer = fullViewContainer;
    }

    public boolean isFull() {
        return this.isFull;
    }

    public void setAutoRotation(boolean autoRotation) {
        this.autoRotation = autoRotation;
    }

    public boolean isAutoRotation() {
        return this.autoRotation;
    }

    public void setFullLandFrist(boolean fullLandFrist) {
        this.fullLandFrist = fullLandFrist;
    }

    public boolean isFullLandFrist() {
        return this.fullLandFrist;
    }

    public void setShowFullAnimation(boolean showFullAnimation) {
        this.showFullAnimation = showFullAnimation;
    }

    public boolean isShowFullAnimation() {
        return this.showFullAnimation;
    }

    public boolean isHideStatusBar() {
        return this.hideStatusBar;
    }

    public void setHideStatusBar(boolean hideStatusBar) {
        this.hideStatusBar = hideStatusBar;
    }

    public boolean isHideActionBar() {
        return this.hideActionBar;
    }

    public void setHideActionBar(boolean hideActionBar) {
        this.hideActionBar = hideActionBar;
    }

    public void setVideoAllCallBack(StandardVideoAllCallBack videoAllCallBack) {
        this.videoAllCallBack = videoAllCallBack;
        this.gsyVideoPlayer.setStandardVideoAllCallBack(videoAllCallBack);
    }

    public int getPlayPosition() {
        return this.playPosition;
    }

    public String getPlayTAG() {
        return this.TAG;
    }

    public boolean isSmall() {
        return this.isSmall;
    }

    public boolean isLoop() {
        return this.isLoop;
    }

    public void setLoop(boolean loop) {
        this.isLoop = loop;
    }

    public int getDuration() {
        return this.gsyVideoPlayer.getDuration();
    }

    public int getSpeed() {
        return this.speed;
    }

    public void setSpeed(int speed) {
        this.speed = speed;
    }

    public File getCachePath() {
        return this.cachePath;
    }

    public void setCachePath(File cachePath) {
        this.cachePath = cachePath;
    }

    public String getTitle() {
        return this.mTitle;
    }

    public void setTitle(String title) {
        this.mTitle = title;
    }

    public Map<String, String> getMapHeadData() {
        return this.mapHeadData;
    }

    public void setMapHeadData(Map<String, String> mapHeadData) {
        this.mapHeadData = mapHeadData;
    }

    public int getCurrentPositionWhenPlaying() {
        return this.gsyVideoPlayer.getCurrentPositionWhenPlaying();
    }

    public StandardGSYVideoPlayer getGsyVideoPlayer() {
        return this.gsyVideoPlayer;
    }

    public boolean isHideKey() {
        return this.hideKey;
    }

    public void setHideKey(boolean hideKey) {
        this.hideKey = hideKey;
    }

    public boolean isNeedLockFull() {
        return this.needLockFull;
    }

    public void setNeedLockFull(boolean needLoadFull) {
        this.needLockFull = needLoadFull;
    }

    public boolean isNeedShowWifiTip() {
        return this.needShowWifiTip;
    }

    public void setNeedShowWifiTip(boolean needShowWifiTip) {
        this.needShowWifiTip = needShowWifiTip;
    }
}

