/*
 * Decompiled with CFR 0.152.
 */
package com.shuyu.gsyvideoplayer.builder;

import android.graphics.drawable.Drawable;
import android.view.View;
import com.shuyu.gsyvideoplayer.listener.LockClickListener;
import com.shuyu.gsyvideoplayer.listener.StandardVideoAllCallBack;
import com.shuyu.gsyvideoplayer.listener.VideoAllCallBack;
import com.shuyu.gsyvideoplayer.video.GSYBaseVideoPlayer;
import com.shuyu.gsyvideoplayer.video.GSYVideoPlayer;
import com.shuyu.gsyvideoplayer.video.StandardGSYVideoPlayer;
import java.io.File;
import java.util.Map;

public class GSYVideoBuilder {
    protected boolean mHideKey = true;
    protected boolean mShowFullAnimation = true;
    protected boolean mNeedShowWifiTip = true;
    protected boolean mRotateViewAuto = true;
    protected boolean mLockLand = false;
    protected boolean mLooping = false;
    protected boolean mIsTouchWiget = true;
    protected boolean mIsTouchWigetFull = true;
    protected boolean mShowPauseCover = true;
    protected boolean mRotateWithSystem = true;
    protected float mSeekRatio = 1.0f;
    protected float mSpeed = 1.0f;
    protected int mShrinkImageRes = -1;
    protected int mEnlargeImageRes = -1;
    protected VideoAllCallBack mVideoAllCallBack;
    protected String mPlayTag = "";
    protected String mUrl;
    protected String mVideoTitle = null;
    protected int mPlayPosition = -22;
    protected long mSeekOnStart = -1L;
    protected boolean mCacheWithPlay;
    protected File mCachePath;
    protected Map<String, String> mMapHeadData;
    protected View mThumbImageView;
    protected StandardVideoAllCallBack mStandardVideoAllCallBack;
    protected LockClickListener mLockClickListener;
    protected Drawable mBottomProgressDrawable;
    protected Drawable mBottomShowProgressDrawable;
    protected Drawable mBottomShowProgressThumbDrawable;
    protected Drawable mVolumeProgressDrawable;
    protected Drawable mDialogProgressBarDrawable;
    protected int mDialogProgressHighLightColor = -11;
    protected int mDialogProgressNormalColor = -11;
    protected int mDismissControlTime = 2500;
    protected boolean mNeedLockFull;
    protected boolean mThumbPlay;

    public GSYVideoBuilder setShowFullAnimation(boolean showFullAnimation) {
        this.mShowFullAnimation = showFullAnimation;
        return this;
    }

    public GSYVideoBuilder setLooping(boolean looping) {
        this.mLooping = looping;
        return this;
    }

    public GSYVideoBuilder setVideoAllCallBack(VideoAllCallBack mVideoAllCallBack) {
        this.mVideoAllCallBack = mVideoAllCallBack;
        return this;
    }

    public GSYVideoBuilder setRotateViewAuto(boolean rotateViewAuto) {
        this.mRotateViewAuto = rotateViewAuto;
        return this;
    }

    public GSYVideoBuilder setLockLand(boolean lockLand) {
        this.mLockLand = lockLand;
        return this;
    }

    public GSYVideoBuilder setSpeed(float speed) {
        this.mSpeed = speed;
        return this;
    }

    public GSYVideoBuilder setHideKey(boolean hideKey) {
        this.mHideKey = hideKey;
        return this;
    }

    public GSYVideoBuilder setIsTouchWiget(boolean isTouchWiget) {
        this.mIsTouchWiget = isTouchWiget;
        return this;
    }

    public GSYVideoBuilder setIsTouchWigetFull(boolean isTouchWigetFull) {
        this.mIsTouchWigetFull = isTouchWigetFull;
        return this;
    }

    public GSYVideoBuilder setNeedShowWifiTip(boolean needShowWifiTip) {
        this.mNeedShowWifiTip = needShowWifiTip;
        return this;
    }

    public GSYVideoBuilder setEnlargeImageRes(int mEnlargeImageRes) {
        this.mEnlargeImageRes = mEnlargeImageRes;
        return this;
    }

    public GSYVideoBuilder setShrinkImageRes(int mShrinkImageRes) {
        this.mShrinkImageRes = mShrinkImageRes;
        return this;
    }

    public GSYVideoBuilder setShowPauseCover(boolean showPauseCover) {
        this.mShowPauseCover = showPauseCover;
        return this;
    }

    public GSYVideoBuilder setSeekRatio(float seekRatio) {
        if (seekRatio < 0.0f) {
            return this;
        }
        this.mSeekRatio = seekRatio;
        return this;
    }

    public GSYVideoBuilder setRotateWithSystem(boolean rotateWithSystem) {
        this.mRotateWithSystem = rotateWithSystem;
        return this;
    }

    public GSYVideoBuilder setPlayTag(String playTag) {
        this.mPlayTag = playTag;
        return this;
    }

    public GSYVideoBuilder setPlayPosition(int playPosition) {
        this.mPlayPosition = playPosition;
        return this;
    }

    public GSYVideoBuilder setSeekOnStart(long seekOnStart) {
        this.mSeekOnStart = seekOnStart;
        return this;
    }

    public GSYVideoBuilder setUrl(String url) {
        this.mUrl = url;
        return this;
    }

    public GSYVideoBuilder setVideoTitle(String videoTitle) {
        this.mVideoTitle = videoTitle;
        return this;
    }

    public GSYVideoBuilder setCacheWithPlay(boolean cacheWithPlay) {
        this.mCacheWithPlay = cacheWithPlay;
        return this;
    }

    public GSYVideoBuilder setCachePath(File cachePath) {
        this.mCachePath = cachePath;
        return this;
    }

    public GSYVideoBuilder setMapHeadData(Map<String, String> mapHeadData) {
        this.mMapHeadData = mapHeadData;
        return this;
    }

    public GSYVideoBuilder setStandardVideoAllCallBack(StandardVideoAllCallBack standardVideoAllCallBack) {
        this.mStandardVideoAllCallBack = standardVideoAllCallBack;
        return this;
    }

    public GSYVideoBuilder setThumbImageView(View view) {
        this.mThumbImageView = view;
        return this;
    }

    public GSYVideoBuilder setBottomShowProgressBarDrawable(Drawable drawable, Drawable thumb) {
        this.mBottomShowProgressDrawable = drawable;
        this.mBottomShowProgressThumbDrawable = thumb;
        return this;
    }

    public GSYVideoBuilder setBottomProgressBarDrawable(Drawable drawable) {
        this.mBottomProgressDrawable = drawable;
        return this;
    }

    public GSYVideoBuilder setDialogVolumeProgressBar(Drawable drawable) {
        this.mVolumeProgressDrawable = drawable;
        return this;
    }

    public GSYVideoBuilder setDialogProgressBar(Drawable drawable) {
        this.mDialogProgressBarDrawable = drawable;
        return this;
    }

    public GSYVideoBuilder setDialogProgressColor(int highLightColor, int normalColor) {
        this.mDialogProgressHighLightColor = highLightColor;
        this.mDialogProgressNormalColor = normalColor;
        return this;
    }

    public GSYVideoBuilder setThumbPlay(boolean thumbPlay) {
        this.mThumbPlay = thumbPlay;
        return this;
    }

    public GSYVideoBuilder setNeedLockFull(boolean needLoadFull) {
        this.mNeedLockFull = needLoadFull;
        return this;
    }

    public GSYVideoBuilder setLockClickListener(LockClickListener lockClickListener) {
        this.mLockClickListener = lockClickListener;
        return this;
    }

    public GSYVideoBuilder setDismissControlTime(int dismissControlTime) {
        this.mDismissControlTime = dismissControlTime;
        return this;
    }

    public void build(StandardGSYVideoPlayer gsyVideoPlayer) {
        if (this.mStandardVideoAllCallBack != null) {
            gsyVideoPlayer.setStandardVideoAllCallBack(this.mStandardVideoAllCallBack);
        }
        if (this.mThumbImageView != null) {
            gsyVideoPlayer.setThumbImageView(this.mThumbImageView);
        }
        if (this.mBottomShowProgressDrawable != null && this.mBottomShowProgressThumbDrawable != null) {
            gsyVideoPlayer.setBottomShowProgressBarDrawable(this.mBottomShowProgressDrawable, this.mBottomShowProgressThumbDrawable);
        }
        if (this.mBottomProgressDrawable != null) {
            gsyVideoPlayer.setBottomProgressBarDrawable(this.mBottomProgressDrawable);
        }
        if (this.mVolumeProgressDrawable != null) {
            gsyVideoPlayer.setDialogVolumeProgressBar(this.mVolumeProgressDrawable);
        }
        if (this.mDialogProgressBarDrawable != null) {
            gsyVideoPlayer.setDialogProgressBar(this.mDialogProgressBarDrawable);
        }
        if (this.mDialogProgressHighLightColor > 0 && this.mDialogProgressNormalColor > 0) {
            gsyVideoPlayer.setDialogProgressColor(this.mDialogProgressHighLightColor, this.mDialogProgressNormalColor);
        }
        gsyVideoPlayer.setThumbPlay(this.mThumbPlay);
        gsyVideoPlayer.setNeedLockFull(this.mNeedLockFull);
        if (this.mLockClickListener != null) {
            gsyVideoPlayer.setLockClickListener(this.mLockClickListener);
        }
        gsyVideoPlayer.setDismissControlTime(this.mDismissControlTime);
        this.build((GSYVideoPlayer)gsyVideoPlayer);
    }

    public void build(GSYVideoPlayer gsyVideoPlayer) {
        this.build((GSYBaseVideoPlayer)gsyVideoPlayer);
        gsyVideoPlayer.setPlayTag(this.mPlayTag);
        gsyVideoPlayer.setPlayPosition(this.mPlayPosition);
        if (this.mSeekOnStart > 0L) {
            gsyVideoPlayer.setSeekOnStart(this.mSeekOnStart);
        }
        gsyVideoPlayer.setUp(this.mUrl, this.mCacheWithPlay, this.mCachePath, this.mMapHeadData, this.mVideoTitle);
    }

    public void build(GSYBaseVideoPlayer gsyVideoPlayer) {
        gsyVideoPlayer.setShowFullAnimation(this.mShowFullAnimation);
        gsyVideoPlayer.setLooping(this.mLooping);
        if (this.mStandardVideoAllCallBack == null) {
            gsyVideoPlayer.setVideoAllCallBack(this.mVideoAllCallBack);
        }
        gsyVideoPlayer.setRotateViewAuto(this.mRotateViewAuto);
        gsyVideoPlayer.setLockLand(this.mLockLand);
        gsyVideoPlayer.setSpeed(this.mSpeed);
        gsyVideoPlayer.setHideKey(this.mHideKey);
        gsyVideoPlayer.setIsTouchWiget(this.mIsTouchWiget);
        gsyVideoPlayer.setIsTouchWigetFull(this.mIsTouchWigetFull);
        gsyVideoPlayer.setNeedShowWifiTip(this.mNeedShowWifiTip);
        if (this.mEnlargeImageRes > 0) {
            gsyVideoPlayer.setEnlargeImageRes(this.mEnlargeImageRes);
        }
        if (this.mShrinkImageRes > 0) {
            gsyVideoPlayer.setShrinkImageRes(this.mShrinkImageRes);
        }
        gsyVideoPlayer.setShowPauseCover(this.mShowPauseCover);
        gsyVideoPlayer.setSeekRatio(this.mSeekRatio);
        gsyVideoPlayer.setRotateWithSystem(this.mRotateWithSystem);
    }
}

