/*
 * Decompiled with CFR 0.152.
 */
package com.shuyu.gsyvideoplayer.video;

import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import com.shuyu.gsyvideoplayer.model.GSYVideoModel;
import com.shuyu.gsyvideoplayer.video.GSYBaseVideoPlayer;
import com.shuyu.gsyvideoplayer.video.StandardGSYVideoPlayer;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class ListGSYVideoPlayer
extends StandardGSYVideoPlayer {
    protected List<GSYVideoModel> mUriList = new ArrayList<GSYVideoModel>();
    protected int mPlayPosition;

    public ListGSYVideoPlayer(Context context, Boolean fullFlag) {
        super(context, fullFlag);
    }

    public ListGSYVideoPlayer(Context context) {
        super(context);
    }

    public ListGSYVideoPlayer(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public boolean setUp(List<GSYVideoModel> url, boolean cacheWithPlay, int position, Object ... objects) {
        this.mUriList = url;
        this.mPlayPosition = position;
        GSYVideoModel gsyVideoModel = url.get(position);
        boolean set = this.setUp(gsyVideoModel.getUrl(), cacheWithPlay, objects);
        if (!TextUtils.isEmpty((CharSequence)gsyVideoModel.getTitle())) {
            this.mTitleTextView.setText((CharSequence)gsyVideoModel.getTitle());
        }
        return set;
    }

    public boolean setUp(List<GSYVideoModel> url, boolean cacheWithPlay, int position, File cachePath, Object ... objects) {
        this.mUriList = url;
        this.mPlayPosition = position;
        GSYVideoModel gsyVideoModel = url.get(position);
        boolean set = this.setUp(gsyVideoModel.getUrl(), cacheWithPlay, cachePath, objects);
        if (!TextUtils.isEmpty((CharSequence)gsyVideoModel.getTitle())) {
            this.mTitleTextView.setText((CharSequence)gsyVideoModel.getTitle());
        }
        return set;
    }

    @Override
    public GSYBaseVideoPlayer startWindowFullscreen(Context context, boolean actionBar, boolean statusBar) {
        GSYBaseVideoPlayer gsyBaseVideoPlayer = super.startWindowFullscreen(context, actionBar, statusBar);
        if (gsyBaseVideoPlayer != null) {
            ListGSYVideoPlayer listGSYVideoPlayer = (ListGSYVideoPlayer)gsyBaseVideoPlayer;
            listGSYVideoPlayer.mPlayPosition = this.mPlayPosition;
            listGSYVideoPlayer.mUriList = this.mUriList;
            GSYVideoModel gsyVideoModel = this.mUriList.get(this.mPlayPosition);
            if (!TextUtils.isEmpty((CharSequence)gsyVideoModel.getTitle())) {
                listGSYVideoPlayer.mTitleTextView.setText((CharSequence)gsyVideoModel.getTitle());
            }
        }
        return gsyBaseVideoPlayer;
    }

    @Override
    public void onCompletion() {
        if (this.mPlayPosition < this.mUriList.size() - 1) {
            return;
        }
        super.onCompletion();
    }

    @Override
    public void onAutoCompletion() {
        if (this.mPlayPosition < this.mUriList.size() - 1) {
            ++this.mPlayPosition;
            GSYVideoModel gsyVideoModel = this.mUriList.get(this.mPlayPosition);
            this.setUp(gsyVideoModel.getUrl(), this.mCache, this.mCachePath, this.mObjects);
            if (!TextUtils.isEmpty((CharSequence)gsyVideoModel.getTitle())) {
                this.mTitleTextView.setText((CharSequence)gsyVideoModel.getTitle());
            }
            this.startPlayLogic();
            return;
        }
        super.onAutoCompletion();
    }
}

