/*
 * Decompiled with CFR 0.152.
 */
package moe.codeest.enviews;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.LinearInterpolator;
import android.view.animation.OvershootInterpolator;
import com.shuyu.gsyvideoplayer.R;

public class ENDownloadView
extends View {
    public static final int STATE_PRE = 0;
    public static final int STATE_DOWNLOADING = 1;
    public static final int STATE_END = 2;
    public static final int STATE_RESET = 3;
    private static final int DEFAULT_LINE_COLOR = -1;
    private static final int DEFAULT_BG_LINE_COLOR = -12959931;
    private static final int DEFAULT_TEXT_COLOR = -1;
    private static final int DEFAULT_LINE_WIDTH = 9;
    private static final int DEFAULT_BG_LINE_WIDTH = 9;
    private static final int DEFAULT_TEXT_SIZE = 14;
    private static final int DEFAULT_STATE = 0;
    private static final int DEFAULT_RIPPLE_SPEED = 2;
    private static final int DEFAULT_DOWNLOAD_TIME = 2000;
    private static final DownloadUnit DEFAULT_DOWNLOAD_UNIT = DownloadUnit.B;
    private OnDownloadStateListener onDownloadStateListener;
    private int mCurrentState;
    private float mCurrentRippleX;
    private double mCurrentSize;
    private double mTotalSize;
    private int mTextSize;
    private int mDownloadTime;
    private DownloadUnit mUnit;
    private Paint mPaint;
    private Paint mBgPaint;
    private Paint mTextPaint;
    private Path mPath;
    private RectF mRectF;
    private RectF mClipRectF;
    ValueAnimator mValueAnimator;
    private float mFraction;
    private float mWidth;
    private float mHeight;
    private float mCenterX;
    private float mCenterY;
    private float mBaseLength;
    private float mCircleRadius;
    private float mBaseRippleLength;

    public ENDownloadView(Context context) {
        super(context);
    }

    public ENDownloadView(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.download);
        int lineColor = ta.getColor(R.styleable.download_download_line_color, -1);
        int bgLineColor = ta.getColor(R.styleable.download_download_bg_line_color, -12959931);
        int textColor = ta.getColor(R.styleable.download_download_text_color, -1);
        int lineWidth = ta.getInteger(R.styleable.download_download_line_width, 9);
        int bgLineWidth = ta.getInteger(R.styleable.download_download_bg_line_width, 9);
        int textSize = ta.getInteger(R.styleable.download_download_text_size, 14);
        ta.recycle();
        this.mPaint = new Paint(1);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mPaint.setStrokeWidth((float)lineWidth);
        this.mPaint.setColor(lineColor);
        this.mBgPaint = new Paint(1);
        this.mBgPaint.setStyle(Paint.Style.STROKE);
        this.mBgPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mBgPaint.setStrokeWidth((float)bgLineWidth);
        this.mBgPaint.setColor(bgLineColor);
        this.mTextPaint = new Paint(1);
        this.mTextPaint.setColor(textColor);
        this.mTextPaint.setTextSize((float)textSize);
        this.mTextPaint.setTextAlign(Paint.Align.CENTER);
        this.mPath = new Path();
        this.mTextSize = textSize;
        this.mCurrentState = 0;
        this.mUnit = DEFAULT_DOWNLOAD_UNIT;
        this.mDownloadTime = 2000;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mWidth = w;
        this.mHeight = h;
        this.mCenterX = this.mWidth / 2.0f;
        this.mCenterY = this.mHeight / 2.0f;
        this.mCircleRadius = this.mWidth * 5.0f / 12.0f;
        this.mBaseLength = this.mCircleRadius / 3.0f;
        this.mBaseRippleLength = 4.4f * this.mBaseLength / 12.0f;
        this.mCurrentRippleX = this.mCenterX - this.mBaseRippleLength * 10.0f;
        this.mRectF = new RectF(this.mCenterX - this.mCircleRadius, this.mCenterY - this.mCircleRadius, this.mCenterX + this.mCircleRadius, this.mCenterY + this.mCircleRadius);
        this.mClipRectF = new RectF(this.mCenterX - 6.0f * this.mBaseRippleLength, 0.0f, this.mCenterX + 6.0f * this.mBaseRippleLength, this.mHeight);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        switch (this.mCurrentState) {
            case 0: {
                if ((double)this.mFraction <= 0.4) {
                    canvas.drawCircle(this.mCenterX, this.mCenterY, this.mCircleRadius, this.mBgPaint);
                    canvas.drawLine(this.mCenterX - this.mBaseLength, this.mCenterY, this.mCenterX, this.mCenterY + this.mBaseLength, this.mPaint);
                    canvas.drawLine(this.mCenterX, this.mCenterY + this.mBaseLength, this.mCenterX + this.mBaseLength, this.mCenterY, this.mPaint);
                    canvas.drawLine(this.mCenterX, this.mCenterY + this.mBaseLength - 1.3f * this.mBaseLength / 0.4f * this.mFraction, this.mCenterX, this.mCenterY - 1.6f * this.mBaseLength + 1.3f * this.mBaseLength / 0.4f * this.mFraction, this.mPaint);
                    break;
                }
                if ((double)this.mFraction <= 0.6) {
                    canvas.drawCircle(this.mCenterX, this.mCenterY, this.mCircleRadius, this.mBgPaint);
                    canvas.drawCircle(this.mCenterX, this.mCenterY - 0.3f * this.mBaseLength, 2.0f, this.mPaint);
                    canvas.drawLine(this.mCenterX - this.mBaseLength - this.mBaseLength * 1.2f / 0.2f * (this.mFraction - 0.4f), this.mCenterY, this.mCenterX, this.mCenterY + this.mBaseLength - this.mBaseLength / 0.2f * (this.mFraction - 0.4f), this.mPaint);
                    canvas.drawLine(this.mCenterX, this.mCenterY + this.mBaseLength - this.mBaseLength / 0.2f * (this.mFraction - 0.4f), this.mCenterX + this.mBaseLength + this.mBaseLength * 1.2f / 0.2f * (this.mFraction - 0.4f), this.mCenterY, this.mPaint);
                    break;
                }
                if (this.mFraction <= 1.0f) {
                    canvas.drawCircle(this.mCenterX, this.mCenterY, this.mCircleRadius, this.mBgPaint);
                    canvas.drawCircle(this.mCenterX, this.mCenterY - 0.3f * this.mBaseLength - (this.mCircleRadius - 0.3f * this.mBaseLength) / 0.4f * (this.mFraction - 0.6f), 2.0f, this.mPaint);
                    canvas.drawLine(this.mCenterX - this.mBaseLength * 2.2f, this.mCenterY, this.mCenterX + this.mBaseLength * 2.2f, this.mCenterY, this.mPaint);
                    break;
                }
                canvas.drawCircle(this.mCenterX, this.mCenterY, this.mCircleRadius, this.mBgPaint);
                canvas.drawCircle(this.mCenterX, this.mCenterY - this.mCircleRadius - this.mBaseLength * 3.0f * (this.mFraction - 1.0f), 3.0f, this.mPaint);
                canvas.drawLine(this.mCenterX - this.mBaseLength * 2.2f, this.mCenterY, this.mCenterX + this.mBaseLength * 2.2f, this.mCenterY, this.mPaint);
                break;
            }
            case 1: {
                if ((double)this.mFraction <= 0.2) {
                    this.mTextPaint.setTextSize((float)this.mTextSize / 0.2f * this.mFraction);
                }
                canvas.drawCircle(this.mCenterX, this.mCenterY, this.mCircleRadius, this.mBgPaint);
                canvas.drawArc(this.mRectF, -90.0f, 359.99f * this.mFraction, false, this.mPaint);
                this.mPath.reset();
                this.mCurrentRippleX += 2.0f;
                if (this.mCurrentRippleX > this.mCenterX - this.mBaseRippleLength * 6.0f) {
                    this.mCurrentRippleX = this.mCenterX - this.mBaseRippleLength * 10.0f;
                }
                this.mPath.moveTo(this.mCurrentRippleX, this.mCenterY);
                for (int i = 0; i < 4; ++i) {
                    this.mPath.rQuadTo(this.mBaseRippleLength, -(1.0f - this.mFraction) * this.mBaseRippleLength, this.mBaseRippleLength * 2.0f, 0.0f);
                    this.mPath.rQuadTo(this.mBaseRippleLength, (1.0f - this.mFraction) * this.mBaseRippleLength, this.mBaseRippleLength * 2.0f, 0.0f);
                }
                canvas.save();
                canvas.clipRect(this.mClipRectF);
                canvas.drawPath(this.mPath, this.mPaint);
                canvas.restore();
                if (this.mUnit == DownloadUnit.NONE || !(this.mCurrentSize > 0.0)) break;
                break;
            }
            case 2: {
                canvas.drawCircle(this.mCenterX, this.mCenterY, this.mCircleRadius, this.mPaint);
                if ((double)this.mFraction <= 0.5) {
                    this.mTextPaint.setTextSize((float)this.mTextSize - (float)this.mTextSize / 0.2f * this.mFraction);
                } else {
                    this.mTextPaint.setTextSize(0.0f);
                }
                if (this.mUnit != DownloadUnit.NONE && this.mCurrentSize > 0.0) {
                    canvas.drawText(String.format("%.2f", this.mCurrentSize) + this.getUnitStr(this.mUnit), this.mCenterX, this.mCenterY + 1.4f * this.mBaseLength, this.mTextPaint);
                }
                canvas.drawLine(this.mCenterX - this.mBaseLength * 2.2f + this.mBaseLength * 1.2f * this.mFraction, this.mCenterY, this.mCenterX - this.mBaseLength * 0.5f, this.mCenterY + this.mBaseLength * 0.5f * this.mFraction * 1.3f, this.mPaint);
                canvas.drawLine(this.mCenterX - this.mBaseLength * 0.5f, this.mCenterY + this.mBaseLength * 0.5f * this.mFraction * 1.3f, this.mCenterX + this.mBaseLength * 2.2f - this.mBaseLength * this.mFraction, this.mCenterY - this.mBaseLength * this.mFraction * 1.3f, this.mPaint);
                break;
            }
            case 3: {
                canvas.drawCircle(this.mCenterX, this.mCenterY, this.mCircleRadius, this.mBgPaint);
                canvas.drawLine(this.mCenterX - this.mBaseLength, this.mCenterY, this.mCenterX - this.mBaseLength * 0.5f + this.mBaseLength * 0.5f * this.mFraction, this.mCenterY + this.mBaseLength * 0.65f + this.mBaseLength * 0.35f * this.mFraction, this.mPaint);
                canvas.drawLine(this.mCenterX - this.mBaseLength * 0.5f + this.mBaseLength * 0.5f * this.mFraction, this.mCenterY + this.mBaseLength * 0.65f + this.mBaseLength * 0.35f * this.mFraction, this.mCenterX + this.mBaseLength * 1.2f - this.mBaseLength * 0.2f * this.mFraction, this.mCenterY - 1.3f * this.mBaseLength + 1.3f * this.mBaseLength * this.mFraction, this.mPaint);
                canvas.drawLine(this.mCenterX - this.mBaseLength * 0.5f + this.mBaseLength * 0.5f * this.mFraction, this.mCenterY + this.mBaseLength * 0.65f + this.mBaseLength * 0.35f * this.mFraction, this.mCenterX - this.mBaseLength * 0.5f + this.mBaseLength * 0.5f * this.mFraction, this.mCenterY + this.mBaseLength * 0.65f - this.mBaseLength * 2.25f * this.mFraction, this.mPaint);
            }
        }
    }

    public void release() {
        if (this.mValueAnimator != null) {
            this.mValueAnimator.removeAllListeners();
            this.mValueAnimator.removeAllUpdateListeners();
            if (this.mValueAnimator.isRunning()) {
                this.mValueAnimator.cancel();
            }
            this.mValueAnimator = null;
        }
    }

    public void start() {
        if (this.mValueAnimator != null) {
            this.mValueAnimator.removeAllListeners();
            this.mValueAnimator.removeAllUpdateListeners();
            if (this.mValueAnimator.isRunning()) {
                this.mValueAnimator.cancel();
            }
            this.mValueAnimator = null;
        }
        this.mCurrentState = 1;
        this.mValueAnimator = ValueAnimator.ofFloat((float[])new float[]{1.0f, 100.0f});
        this.mValueAnimator.setDuration(1500L);
        this.mValueAnimator.setInterpolator((TimeInterpolator)new OvershootInterpolator());
        this.mValueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                ENDownloadView.this.mFraction = valueAnimator.getAnimatedFraction();
                ENDownloadView.this.invalidate();
            }
        });
        this.mValueAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                ENDownloadView.this.mCurrentState = 1;
                ENDownloadView.this.downloadAnim();
            }
        });
        this.mValueAnimator.start();
    }

    private void downloadAnim() {
        if (this.mValueAnimator != null) {
            this.mValueAnimator.removeAllListeners();
            this.mValueAnimator.removeAllUpdateListeners();
            if (this.mValueAnimator.isRunning()) {
                this.mValueAnimator.cancel();
            }
            this.mValueAnimator = null;
        }
        if (this.mCurrentState != 1) {
            return;
        }
        this.mValueAnimator = ValueAnimator.ofFloat((float[])new float[]{1.0f, 100.0f});
        this.mValueAnimator.setDuration((long)this.mDownloadTime);
        this.mValueAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        this.mValueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                ENDownloadView.this.mFraction = valueAnimator.getAnimatedFraction();
                if (ENDownloadView.this.mUnit != DownloadUnit.NONE && ENDownloadView.this.mTotalSize > 0.0) {
                    ENDownloadView.this.mCurrentSize = (double)ENDownloadView.this.mFraction * ENDownloadView.this.mTotalSize;
                }
                ENDownloadView.this.invalidate();
            }
        });
        this.mValueAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                ENDownloadView.this.mCurrentState = 1;
                ENDownloadView.this.downloadAnim();
            }
        });
        this.mValueAnimator.start();
    }

    private void endAnim() {
        if (this.mValueAnimator != null) {
            this.mValueAnimator.removeAllListeners();
            this.mValueAnimator.removeAllUpdateListeners();
            if (this.mValueAnimator.isRunning()) {
                this.mValueAnimator.cancel();
            }
            this.mValueAnimator = null;
        }
        this.mValueAnimator = ValueAnimator.ofFloat((float[])new float[]{1.0f, 100.0f});
        this.mValueAnimator.setDuration(700L);
        this.mValueAnimator.setInterpolator((TimeInterpolator)new OvershootInterpolator());
        this.mValueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                ENDownloadView.this.mFraction = valueAnimator.getAnimatedFraction();
                ENDownloadView.this.invalidate();
            }
        });
        this.mValueAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                ENDownloadView.this.mFraction = 0.0f;
                ENDownloadView.this.mCurrentState = 3;
                if (ENDownloadView.this.onDownloadStateListener != null) {
                    ENDownloadView.this.onDownloadStateListener.onDownloadFinish();
                }
            }
        });
        this.mValueAnimator.start();
    }

    public void reset() {
        this.mFraction = 0.0f;
        this.mCurrentState = 0;
        if (this.mValueAnimator != null) {
            this.mValueAnimator.removeAllListeners();
            this.mValueAnimator.removeAllUpdateListeners();
            if (this.mValueAnimator.isRunning()) {
                this.mValueAnimator.cancel();
            }
            this.mValueAnimator = null;
        }
    }

    private String getUnitStr(DownloadUnit unit) {
        switch (unit) {
            case GB: {
                return " gb";
            }
            case MB: {
                return " mb";
            }
            case KB: {
                return " kb";
            }
            case B: {
                return " b";
            }
        }
        return " b";
    }

    public void setDownloadConfig(int downloadTime, double downloadFileSize, DownloadUnit unit) {
        this.mDownloadTime = downloadTime;
        this.mTotalSize = downloadFileSize;
        this.mUnit = unit;
    }

    public int getCurrentState() {
        return this.mCurrentState;
    }

    public void setOnDownloadStateListener(OnDownloadStateListener onDownloadStateListener) {
        this.onDownloadStateListener = onDownloadStateListener;
    }

    static interface OnDownloadStateListener {
        public void onDownloadFinish();

        public void onResetFinish();
    }

    public static enum DownloadUnit {
        GB,
        MB,
        KB,
        B,
        NONE;

    }
}

