/*
 * Decompiled with CFR 0.152.
 */
package moe.codeest.enviews;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathMeasure;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.AnticipateInterpolator;
import com.shuyu.gsyvideoplayer.R;

public class ENPlayView
extends View {
    public static int STATE_PLAY = 0;
    public static int STATE_PAUSE = 1;
    public static int DEFAULT_LINE_COLOR = -1;
    public static int DEFAULT_BG_LINE_COLOR = -328966;
    public static int DEFAULT_LINE_WIDTH = 14;
    public static int DEFAULT_BG_LINE_WIDTH = 12;
    public static int DEFAULT_DURATION = 1200;
    private int mCurrentState = STATE_PAUSE;
    private Paint mPaint;
    private Paint mBgPaint;
    private int mWidth;
    private int mHeight;
    private int mCenterX;
    private int mCenterY;
    private int mCircleRadius;
    private RectF mRectF;
    private RectF mBgRectF;
    private float mFraction = 1.0f;
    private Path mPath;
    private Path mDstPath;
    private PathMeasure mPathMeasure;
    private float mPathLength;
    private int mDuration;

    public ENPlayView(Context context) {
        super(context);
    }

    public ENPlayView(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.play);
        int lineColor = ta.getColor(R.styleable.play_play_line_color, DEFAULT_LINE_COLOR);
        int bgLineColor = ta.getColor(R.styleable.play_play_bg_line_color, DEFAULT_BG_LINE_COLOR);
        int lineWidth = ta.getInteger(R.styleable.play_play_line_width, DEFAULT_LINE_WIDTH);
        int bgLineWidth = ta.getInteger(R.styleable.play_play_bg_line_width, DEFAULT_BG_LINE_WIDTH);
        ta.recycle();
        this.mPaint = new Paint(1);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mPaint.setColor(lineColor);
        this.mPaint.setStrokeWidth((float)lineWidth);
        this.mBgPaint = new Paint(1);
        this.mBgPaint.setStyle(Paint.Style.STROKE);
        this.mBgPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mBgPaint.setColor(bgLineColor);
        this.mBgPaint.setStrokeWidth((float)bgLineWidth);
        this.mPath = new Path();
        this.mDstPath = new Path();
        this.mPathMeasure = new PathMeasure();
        this.mDuration = DEFAULT_DURATION;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mWidth = w * 9 / 10;
        this.mHeight = h * 9 / 10;
        this.mCircleRadius = this.mWidth / 10;
        this.mCenterX = w / 2;
        this.mCenterY = h / 2;
        this.mRectF = new RectF((float)(this.mCenterX - this.mCircleRadius), (float)this.mCenterY + 0.6f * (float)this.mCircleRadius, (float)(this.mCenterX + this.mCircleRadius), (float)this.mCenterY + 2.6f * (float)this.mCircleRadius);
        this.mBgRectF = new RectF((float)(this.mCenterX - this.mWidth / 2), (float)(this.mCenterY - this.mHeight / 2), (float)(this.mCenterX + this.mWidth / 2), (float)(this.mCenterY + this.mHeight / 2));
        this.mPath.moveTo((float)(this.mCenterX - this.mCircleRadius), (float)this.mCenterY + 1.8f * (float)this.mCircleRadius);
        this.mPath.lineTo((float)(this.mCenterX - this.mCircleRadius), (float)this.mCenterY - 1.8f * (float)this.mCircleRadius);
        this.mPath.lineTo((float)(this.mCenterX + this.mCircleRadius), (float)this.mCenterY);
        this.mPath.close();
        this.mPathMeasure.setPath(this.mPath, false);
        this.mPathLength = this.mPathMeasure.getLength();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.drawCircle((float)this.mCenterX, (float)this.mCenterY, (float)(this.mWidth / 2), this.mBgPaint);
        if (this.mFraction < 0.0f) {
            canvas.drawLine((float)(this.mCenterX + this.mCircleRadius), (float)this.mCenterY - 1.6f * (float)this.mCircleRadius + (float)(10 * this.mCircleRadius) * this.mFraction, (float)(this.mCenterX + this.mCircleRadius), (float)this.mCenterY + 1.6f * (float)this.mCircleRadius + (float)(10 * this.mCircleRadius) * this.mFraction, this.mPaint);
            canvas.drawLine((float)(this.mCenterX - this.mCircleRadius), (float)this.mCenterY - 1.6f * (float)this.mCircleRadius, (float)(this.mCenterX - this.mCircleRadius), (float)this.mCenterY + 1.6f * (float)this.mCircleRadius, this.mPaint);
            canvas.drawArc(this.mBgRectF, -105.0f, 360.0f, false, this.mPaint);
        } else if ((double)this.mFraction <= 0.3) {
            canvas.drawLine((float)(this.mCenterX + this.mCircleRadius), (float)this.mCenterY - 1.6f * (float)this.mCircleRadius + (float)this.mCircleRadius * 3.2f / 0.3f * this.mFraction, (float)(this.mCenterX + this.mCircleRadius), (float)this.mCenterY + 1.6f * (float)this.mCircleRadius, this.mPaint);
            canvas.drawLine((float)(this.mCenterX - this.mCircleRadius), (float)this.mCenterY - 1.6f * (float)this.mCircleRadius, (float)(this.mCenterX - this.mCircleRadius), (float)this.mCenterY + 1.6f * (float)this.mCircleRadius, this.mPaint);
            canvas.drawArc(this.mRectF, 0.0f, 600.0f * this.mFraction, false, this.mPaint);
            canvas.drawArc(this.mBgRectF, -105.0f + 360.0f * this.mFraction, 360.0f * (1.0f - this.mFraction), false, this.mPaint);
        } else if ((double)this.mFraction <= 0.6) {
            canvas.drawArc(this.mRectF, 600.0f * (this.mFraction - 0.3f), 180.0f - 600.0f * (this.mFraction - 0.3f), false, this.mPaint);
            this.mDstPath.reset();
            this.mDstPath.lineTo(0.0f, 0.0f);
            this.mPathMeasure.getSegment(0.02f * this.mPathLength, 0.38f * this.mPathLength + 0.42f * this.mPathLength / 0.3f * (this.mFraction - 0.3f), this.mDstPath, true);
            canvas.drawPath(this.mDstPath, this.mPaint);
            canvas.drawArc(this.mBgRectF, -105.0f + 360.0f * this.mFraction, 360.0f * (1.0f - this.mFraction), false, this.mPaint);
        } else if ((double)this.mFraction <= 0.8) {
            this.mDstPath.reset();
            this.mDstPath.lineTo(0.0f, 0.0f);
            this.mPathMeasure.getSegment(0.02f * this.mPathLength + 0.2f * this.mPathLength / 0.2f * (this.mFraction - 0.6f), 0.8f * this.mPathLength + 0.2f * this.mPathLength / 0.2f * (this.mFraction - 0.6f), this.mDstPath, true);
            canvas.drawPath(this.mDstPath, this.mPaint);
            canvas.drawArc(this.mBgRectF, -105.0f + 360.0f * this.mFraction, 360.0f * (1.0f - this.mFraction), false, this.mPaint);
        } else {
            this.mDstPath.reset();
            this.mDstPath.lineTo(0.0f, 0.0f);
            this.mPathMeasure.getSegment((float)(10 * this.mCircleRadius) * (this.mFraction - 1.0f), this.mPathLength, this.mDstPath, true);
            canvas.drawPath(this.mDstPath, this.mPaint);
        }
    }

    public void play() {
        if (this.mCurrentState == STATE_PLAY) {
            return;
        }
        this.mCurrentState = STATE_PLAY;
        ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{1.0f, 100.0f});
        valueAnimator.setDuration((long)this.mDuration);
        valueAnimator.setInterpolator((TimeInterpolator)new AnticipateInterpolator());
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                ENPlayView.this.mFraction = 1.0f - valueAnimator.getAnimatedFraction();
                ENPlayView.this.invalidate();
            }
        });
        if (!valueAnimator.isRunning()) {
            valueAnimator.start();
        }
    }

    public void pause() {
        if (this.mCurrentState == STATE_PAUSE) {
            return;
        }
        this.mCurrentState = STATE_PAUSE;
        ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{1.0f, 100.0f});
        valueAnimator.setDuration((long)this.mDuration);
        valueAnimator.setInterpolator((TimeInterpolator)new AnticipateInterpolator());
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                ENPlayView.this.mFraction = valueAnimator.getAnimatedFraction();
                ENPlayView.this.invalidate();
            }
        });
        if (!valueAnimator.isRunning()) {
            valueAnimator.start();
        }
    }

    public int getCurrentState() {
        return this.mCurrentState;
    }

    public void setDuration(int duration) {
        this.mDuration = duration;
    }
}

