/*
 * Decompiled with CFR 0.152.
 */
package com.shuyu.gsyvideoplayer.video;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.SeekBar;
import android.widget.TextView;
import com.shuyu.gsyvideoplayer.GSYTextureView;
import com.shuyu.gsyvideoplayer.GSYVideoManager;
import com.shuyu.gsyvideoplayer.GSYVideoPlayer;
import com.shuyu.gsyvideoplayer.R;
import com.shuyu.gsyvideoplayer.SmallVideoTouch;
import com.shuyu.gsyvideoplayer.listener.GSYMediaPlayerListener;
import com.shuyu.gsyvideoplayer.listener.VideoAllCallBack;
import com.shuyu.gsyvideoplayer.utils.CommonUtil;
import com.shuyu.gsyvideoplayer.utils.Debuger;
import com.shuyu.gsyvideoplayer.utils.OrientationUtils;
import com.transitionseverywhere.TransitionManager;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;

public abstract class GSYBaseVideoPlayer
extends FrameLayout
implements GSYMediaPlayerListener {
    public static final int SMALL_ID = 84778;
    protected static final int FULLSCREEN_ID = 85597;
    protected static long CLICK_QUIT_FULLSCREEN_TIME = 0L;
    protected boolean mActionBar = false;
    protected boolean mStatusBar = false;
    protected boolean mHideKey = true;
    protected boolean mCache = false;
    private boolean mShowFullAnimation = true;
    protected boolean mNeedShowWifiTip = true;
    protected int[] mListItemRect;
    protected int[] mListItemSize;
    protected int mCurrentState = -1;
    protected int mRotate = 0;
    protected int mShrinkImageRes = -1;
    protected int mEnlargeImageRes = -1;
    private int mSystemUiVisibility;
    protected float mSpeed = 1.0f;
    protected boolean mRotateViewAuto = true;
    protected boolean mIfCurrentIsFullscreen = false;
    protected boolean mLockLand = false;
    protected boolean mLooping = false;
    protected boolean mHadPlay = false;
    protected boolean mCacheFile = false;
    protected Context mContext;
    protected String mOriginUrl;
    protected String mUrl;
    protected Object[] mObjects;
    protected File mCachePath;
    protected ViewGroup mTextureViewContainer;
    protected View mSmallClose;
    protected VideoAllCallBack mVideoAllCallBack;
    protected Map<String, String> mMapHeadData = new HashMap<String, String>();
    protected GSYTextureView mTextureView;
    protected ImageView mCoverImageView;
    protected View mStartButton;
    protected SeekBar mProgressBar;
    protected ImageView mFullscreenButton;
    protected TextView mCurrentTimeTextView;
    protected TextView mTotalTimeTextView;
    protected ViewGroup mTopContainer;
    protected ViewGroup mBottomContainer;
    protected ImageView mBackButton;
    protected Bitmap mFullPauseBitmap = null;
    protected OrientationUtils mOrientationUtils;
    private Handler mHandler = new Handler();

    public GSYBaseVideoPlayer(Context context, Boolean fullFlag) {
        super(context);
        this.mIfCurrentIsFullscreen = fullFlag;
    }

    public GSYBaseVideoPlayer(Context context) {
        super(context);
    }

    public GSYBaseVideoPlayer(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public GSYBaseVideoPlayer(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    private ViewGroup getViewGroup() {
        return (ViewGroup)CommonUtil.scanForActivity(this.getContext()).findViewById(0x1020002);
    }

    private void removeVideo(ViewGroup vp, int id2) {
        View old = vp.findViewById(id2);
        if (old != null && old.getParent() != null) {
            ViewGroup viewGroup = (ViewGroup)old.getParent();
            vp.removeView((View)viewGroup);
        }
    }

    private void saveLocationStatus(Context context, boolean statusBar, boolean actionBar) {
        this.getLocationOnScreen(this.mListItemRect);
        int statusBarH = CommonUtil.getStatusBarHeight(context);
        int actionBerH = CommonUtil.getActionBarHeight((Activity)context);
        if (statusBar) {
            this.mListItemRect[1] = this.mListItemRect[1] - statusBarH;
        }
        if (actionBar) {
            this.mListItemRect[1] = this.mListItemRect[1] - actionBerH;
        }
        this.mListItemSize[0] = this.getWidth();
        this.mListItemSize[1] = this.getHeight();
    }

    private void resolveFullVideoShow(Context context, final GSYBaseVideoPlayer gsyVideoPlayer, final FrameLayout frameLayout) {
        FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)gsyVideoPlayer.getLayoutParams();
        lp.setMargins(0, 0, 0, 0);
        lp.height = -1;
        lp.width = -1;
        lp.gravity = 17;
        gsyVideoPlayer.setLayoutParams((ViewGroup.LayoutParams)lp);
        gsyVideoPlayer.setIfCurrentIsFullscreen(true);
        this.mOrientationUtils = new OrientationUtils((Activity)context, gsyVideoPlayer);
        this.mOrientationUtils.setEnable(this.mRotateViewAuto);
        gsyVideoPlayer.mOrientationUtils = this.mOrientationUtils;
        if (this.isShowFullAnimation()) {
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (GSYBaseVideoPlayer.this.mLockLand && GSYBaseVideoPlayer.this.mOrientationUtils.getIsLand() != 1) {
                        GSYBaseVideoPlayer.this.mOrientationUtils.resolveByClick();
                    }
                    gsyVideoPlayer.setVisibility(0);
                    frameLayout.setVisibility(0);
                }
            }, 300L);
        } else {
            if (this.mLockLand) {
                this.mOrientationUtils.resolveByClick();
            }
            gsyVideoPlayer.setVisibility(0);
            frameLayout.setVisibility(0);
        }
        if (this.mVideoAllCallBack != null) {
            Debuger.printfError("onEnterFullscreen");
            this.mVideoAllCallBack.onEnterFullscreen(this.mUrl, this.mObjects);
        }
        this.mIfCurrentIsFullscreen = true;
    }

    protected void resolveNormalVideoShow(View oldF, ViewGroup vp, GSYVideoPlayer gsyVideoPlayer) {
        if (oldF != null && oldF.getParent() != null) {
            ViewGroup viewGroup = (ViewGroup)oldF.getParent();
            vp.removeView((View)viewGroup);
        }
        this.mCurrentState = GSYVideoManager.instance().getLastState();
        if (gsyVideoPlayer != null) {
            this.mCurrentState = gsyVideoPlayer.getCurrentState();
        }
        GSYVideoManager.instance().setListener(GSYVideoManager.instance().lastListener());
        GSYVideoManager.instance().setLastListener(null);
        this.setStateAndUi(this.mCurrentState);
        this.addTextureView();
        CLICK_QUIT_FULLSCREEN_TIME = System.currentTimeMillis();
        if (this.mVideoAllCallBack != null) {
            Debuger.printfError("onQuitFullscreen");
            this.mVideoAllCallBack.onQuitFullscreen(this.mUrl, this.mObjects);
        }
        this.mIfCurrentIsFullscreen = false;
        if (this.mHideKey) {
            CommonUtil.showNavKey(this.mContext, this.mSystemUiVisibility);
        }
        CommonUtil.showSupportActionBar(this.mContext, this.mActionBar, this.mStatusBar);
        this.getFullscreenButton().setImageResource(this.getEnlargeImageRes());
    }

    public GSYBaseVideoPlayer startWindowFullscreen(final Context context, boolean actionBar, boolean statusBar) {
        this.mSystemUiVisibility = ((Activity)context).getWindow().getDecorView().getSystemUiVisibility();
        CommonUtil.hideSupportActionBar(context, actionBar, statusBar);
        if (this.mHideKey) {
            CommonUtil.hideNavKey(context);
        }
        this.mActionBar = actionBar;
        this.mStatusBar = statusBar;
        this.mListItemRect = new int[2];
        this.mListItemSize = new int[2];
        final ViewGroup vp = this.getViewGroup();
        this.removeVideo(vp, 85597);
        this.pauseFullCoverLogic();
        if (this.mTextureViewContainer.getChildCount() > 0) {
            this.mTextureViewContainer.removeAllViews();
        }
        this.saveLocationStatus(context, statusBar, actionBar);
        boolean hadNewConstructor = true;
        try {
            this.getClass().getConstructor(Context.class, Boolean.class);
        }
        catch (Exception e) {
            hadNewConstructor = false;
        }
        try {
            GSYBaseVideoPlayer gsyVideoPlayer;
            if (!hadNewConstructor) {
                Constructor<?> constructor = this.getClass().getConstructor(Context.class);
                gsyVideoPlayer = (GSYBaseVideoPlayer)constructor.newInstance(this.getContext());
            } else {
                Constructor<?> constructor = this.getClass().getConstructor(Context.class, Boolean.class);
                gsyVideoPlayer = (GSYBaseVideoPlayer)constructor.newInstance(this.getContext(), true);
            }
            gsyVideoPlayer.setId(85597);
            gsyVideoPlayer.setIfCurrentIsFullscreen(true);
            gsyVideoPlayer.setVideoAllCallBack(this.mVideoAllCallBack);
            gsyVideoPlayer.setLooping(this.isLooping());
            gsyVideoPlayer.setSpeed(this.getSpeed());
            FrameLayout.LayoutParams lpParent = new FrameLayout.LayoutParams(-1, -1);
            final FrameLayout frameLayout = new FrameLayout(context);
            frameLayout.setBackgroundColor(-16777216);
            if (this.mShowFullAnimation) {
                FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(this.getWidth(), this.getHeight());
                lp.setMargins(this.mListItemRect[0], this.mListItemRect[1], 0, 0);
                frameLayout.addView((View)gsyVideoPlayer, (ViewGroup.LayoutParams)lp);
                vp.addView((View)frameLayout, (ViewGroup.LayoutParams)lpParent);
                this.mHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        TransitionManager.beginDelayedTransition((ViewGroup)vp);
                        GSYBaseVideoPlayer.this.resolveFullVideoShow(context, gsyVideoPlayer, frameLayout);
                    }
                }, 300L);
            } else {
                FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(this.getWidth(), this.getHeight());
                frameLayout.addView((View)gsyVideoPlayer, (ViewGroup.LayoutParams)lp);
                vp.addView((View)frameLayout, (ViewGroup.LayoutParams)lpParent);
                gsyVideoPlayer.setVisibility(4);
                frameLayout.setVisibility(4);
                this.resolveFullVideoShow(context, gsyVideoPlayer, frameLayout);
            }
            gsyVideoPlayer.mHadPlay = this.mHadPlay;
            gsyVideoPlayer.mCacheFile = this.mCacheFile;
            gsyVideoPlayer.mFullPauseBitmap = this.mFullPauseBitmap;
            gsyVideoPlayer.mNeedShowWifiTip = this.mNeedShowWifiTip;
            gsyVideoPlayer.mShrinkImageRes = this.mShrinkImageRes;
            gsyVideoPlayer.mEnlargeImageRes = this.mEnlargeImageRes;
            gsyVideoPlayer.setUp(this.mOriginUrl, this.mCache, this.mCachePath, this.mMapHeadData, this.mObjects);
            gsyVideoPlayer.setStateAndUi(this.mCurrentState);
            gsyVideoPlayer.addTextureView();
            gsyVideoPlayer.getFullscreenButton().setImageResource(this.getShrinkImageRes());
            gsyVideoPlayer.getFullscreenButton().setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    GSYBaseVideoPlayer.this.clearFullscreenLayout();
                }
            });
            gsyVideoPlayer.getBackButton().setVisibility(0);
            gsyVideoPlayer.getBackButton().setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    GSYBaseVideoPlayer.this.clearFullscreenLayout();
                }
            });
            GSYVideoManager.instance().setLastListener(this);
            GSYVideoManager.instance().setListener(gsyVideoPlayer);
            return gsyVideoPlayer;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void clearFullscreenLayout() {
        this.mIfCurrentIsFullscreen = false;
        int delay = 0;
        if (this.mOrientationUtils != null) {
            delay = this.mOrientationUtils.backToProtVideo();
            this.mOrientationUtils.setEnable(false);
            if (this.mOrientationUtils != null) {
                this.mOrientationUtils.releaseListener();
                this.mOrientationUtils = null;
            }
        }
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                GSYBaseVideoPlayer.this.backToNormal();
            }
        }, (long)delay);
    }

    private void backToNormal() {
        final ViewGroup vp = this.getViewGroup();
        final View oldF = vp.findViewById(85597);
        if (oldF != null) {
            final GSYVideoPlayer gsyVideoPlayer = (GSYVideoPlayer)oldF;
            this.pauseFullBackCoverLogic(gsyVideoPlayer);
            if (this.mShowFullAnimation) {
                TransitionManager.beginDelayedTransition((ViewGroup)vp);
                FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)gsyVideoPlayer.getLayoutParams();
                lp.setMargins(this.mListItemRect[0], this.mListItemRect[1], 0, 0);
                lp.width = this.mListItemSize[0];
                lp.height = this.mListItemSize[1];
                lp.gravity = 0;
                gsyVideoPlayer.setLayoutParams((ViewGroup.LayoutParams)lp);
                this.mHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        GSYBaseVideoPlayer.this.resolveNormalVideoShow(oldF, vp, gsyVideoPlayer);
                    }
                }, 400L);
            } else {
                this.resolveNormalVideoShow(oldF, vp, gsyVideoPlayer);
            }
        } else {
            this.resolveNormalVideoShow(null, vp, null);
        }
    }

    private void pauseFullCoverLogic() {
        if (this.mCurrentState == 5 && this.mTextureView != null && (this.mFullPauseBitmap == null || this.mFullPauseBitmap.isRecycled())) {
            try {
                this.mFullPauseBitmap = this.mTextureView.getBitmap(this.mTextureView.getSizeW(), this.mTextureView.getSizeH());
            }
            catch (Exception e) {
                e.printStackTrace();
                this.mFullPauseBitmap = null;
            }
        }
    }

    private void pauseFullBackCoverLogic(GSYBaseVideoPlayer gsyVideoPlayer) {
        if (gsyVideoPlayer.mCurrentState == 5 && gsyVideoPlayer.mTextureView != null) {
            if (gsyVideoPlayer.mFullPauseBitmap != null && !gsyVideoPlayer.mFullPauseBitmap.isRecycled()) {
                this.mFullPauseBitmap = gsyVideoPlayer.mFullPauseBitmap;
            } else {
                try {
                    this.mFullPauseBitmap = this.mTextureView.getBitmap(this.mTextureView.getSizeW(), this.mTextureView.getSizeH());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.mFullPauseBitmap = null;
                }
            }
        }
    }

    public GSYBaseVideoPlayer showSmallVideo(Point size, boolean actionBar, boolean statusBar) {
        ViewGroup vp = this.getViewGroup();
        this.removeVideo(vp, 84778);
        if (this.mTextureViewContainer.getChildCount() > 0) {
            this.mTextureViewContainer.removeAllViews();
        }
        try {
            Constructor<?> constructor = this.getClass().getConstructor(Context.class);
            GSYBaseVideoPlayer gsyVideoPlayer = (GSYBaseVideoPlayer)constructor.newInstance(this.getContext());
            gsyVideoPlayer.setId(84778);
            FrameLayout.LayoutParams lpParent = new FrameLayout.LayoutParams(-1, -1);
            FrameLayout frameLayout = new FrameLayout(this.mContext);
            FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(size.x, size.y);
            int marginLeft = CommonUtil.getScreenWidth(this.mContext) - size.x;
            int marginTop = CommonUtil.getScreenHeight(this.mContext) - size.y;
            if (actionBar) {
                marginTop -= CommonUtil.getActionBarHeight((Activity)this.mContext);
            }
            if (statusBar) {
                marginTop -= CommonUtil.getStatusBarHeight(this.mContext);
            }
            lp.setMargins(marginLeft, marginTop, 0, 0);
            frameLayout.addView((View)gsyVideoPlayer, (ViewGroup.LayoutParams)lp);
            vp.addView((View)frameLayout, (ViewGroup.LayoutParams)lpParent);
            gsyVideoPlayer.mHadPlay = this.mHadPlay;
            gsyVideoPlayer.setUp(this.mOriginUrl, this.mCache, this.mCachePath, this.mMapHeadData, this.mObjects);
            gsyVideoPlayer.setStateAndUi(this.mCurrentState);
            gsyVideoPlayer.addTextureView();
            gsyVideoPlayer.onClickUiToggle();
            gsyVideoPlayer.setVideoAllCallBack(this.mVideoAllCallBack);
            gsyVideoPlayer.setLooping(this.isLooping());
            gsyVideoPlayer.setSpeed(this.getSpeed());
            gsyVideoPlayer.setSmallVideoTextureView(new SmallVideoTouch(gsyVideoPlayer, marginLeft, marginTop));
            GSYVideoManager.instance().setLastListener(this);
            GSYVideoManager.instance().setListener(gsyVideoPlayer);
            if (this.mVideoAllCallBack != null) {
                Debuger.printfError("onEnterSmallWidget");
                this.mVideoAllCallBack.onEnterSmallWidget(this.mUrl, this.mObjects);
            }
            return gsyVideoPlayer;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void hideSmallVideo() {
        ViewGroup vp = this.getViewGroup();
        GSYVideoPlayer gsyVideoPlayer = (GSYVideoPlayer)vp.findViewById(84778);
        this.removeVideo(vp, 84778);
        this.mCurrentState = GSYVideoManager.instance().getLastState();
        if (gsyVideoPlayer != null) {
            this.mCurrentState = gsyVideoPlayer.getCurrentState();
        }
        GSYVideoManager.instance().setListener(GSYVideoManager.instance().lastListener());
        GSYVideoManager.instance().setLastListener(null);
        this.setStateAndUi(this.mCurrentState);
        this.addTextureView();
        CLICK_QUIT_FULLSCREEN_TIME = System.currentTimeMillis();
        if (this.mVideoAllCallBack != null) {
            Debuger.printfLog("onQuitSmallWidget");
            this.mVideoAllCallBack.onQuitSmallWidget(this.mUrl, this.mObjects);
        }
    }

    public abstract boolean setUp(String var1, boolean var2, File var3, Object ... var4);

    public abstract boolean setUp(String var1, boolean var2, File var3, Map<String, String> var4, Object ... var5);

    protected abstract void setStateAndUi(int var1);

    protected abstract void addTextureView();

    protected abstract void setSmallVideoTextureView(View.OnTouchListener var1);

    protected abstract void onClickUiToggle();

    public abstract ImageView getFullscreenButton();

    public abstract ImageView getBackButton();

    public boolean isIfCurrentIsFullscreen() {
        return this.mIfCurrentIsFullscreen;
    }

    public void setIfCurrentIsFullscreen(boolean ifCurrentIsFullscreen) {
        this.mIfCurrentIsFullscreen = ifCurrentIsFullscreen;
    }

    public boolean isShowFullAnimation() {
        return this.mShowFullAnimation;
    }

    public void setShowFullAnimation(boolean showFullAnimation) {
        this.mShowFullAnimation = showFullAnimation;
    }

    public boolean isLooping() {
        return this.mLooping;
    }

    public void setLooping(boolean looping) {
        this.mLooping = looping;
    }

    public void setVideoAllCallBack(VideoAllCallBack mVideoAllCallBack) {
        this.mVideoAllCallBack = mVideoAllCallBack;
    }

    public boolean isRotateViewAuto() {
        return this.mRotateViewAuto;
    }

    public void setRotateViewAuto(boolean rotateViewAuto) {
        this.mRotateViewAuto = rotateViewAuto;
        if (this.mOrientationUtils != null) {
            this.mOrientationUtils.setEnable(rotateViewAuto);
        }
    }

    public boolean isLockLand() {
        return this.mLockLand;
    }

    public void setLockLand(boolean lockLand) {
        this.mLockLand = lockLand;
    }

    public float getSpeed() {
        return this.mSpeed;
    }

    public void setSpeed(float speed) {
        this.mSpeed = speed;
    }

    public boolean isHideKey() {
        return this.mHideKey;
    }

    public void setHideKey(boolean hideKey) {
        this.mHideKey = hideKey;
    }

    public boolean isNeedShowWifiTip() {
        return this.mNeedShowWifiTip;
    }

    public void setNeedShowWifiTip(boolean needShowWifiTip) {
        this.mNeedShowWifiTip = needShowWifiTip;
    }

    public int getEnlargeImageRes() {
        if (this.mShrinkImageRes == -1) {
            return R.drawable.video_enlarge;
        }
        return this.mEnlargeImageRes;
    }

    public void setEnlargeImageRes(int mEnlargeImageRes) {
        this.mEnlargeImageRes = mEnlargeImageRes;
    }

    public int getShrinkImageRes() {
        if (this.mShrinkImageRes == -1) {
            return R.drawable.video_shrink;
        }
        return this.mShrinkImageRes;
    }

    public void setShrinkImageRes(int mShrinkImageRes) {
        this.mShrinkImageRes = mShrinkImageRes;
    }
}

