/*
 * Decompiled with CFR 0.152.
 */
package com.shuyu.gsyvideoplayer.utils;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.provider.Settings;
import android.view.OrientationEventListener;
import com.shuyu.gsyvideoplayer.video.GSYBaseVideoPlayer;

public class OrientationUtils {
    private Activity activity;
    private GSYBaseVideoPlayer gsyVideoPlayer;
    private int screenType = 1;
    private OrientationEventListener orientationEventListener;
    private boolean mClick;
    private boolean mClickLand;
    private boolean mClickPort;
    private int mIsLand;
    private boolean mEnable = true;

    public OrientationUtils(Activity activity, GSYBaseVideoPlayer gsyVideoPlayer) {
        this.activity = activity;
        this.gsyVideoPlayer = gsyVideoPlayer;
        this.init();
    }

    private void init() {
        this.orientationEventListener = new OrientationEventListener((Context)this.activity){

            public void onOrientationChanged(int rotation) {
                boolean autoRotateOn;
                boolean bl = autoRotateOn = Settings.System.getInt((ContentResolver)OrientationUtils.this.activity.getContentResolver(), (String)"accelerometer_rotation", (int)0) == 1;
                if (!autoRotateOn && OrientationUtils.this.mIsLand == 0) {
                    return;
                }
                if (rotation >= 0 && rotation <= 30 || rotation >= 330) {
                    if (OrientationUtils.this.mClick) {
                        if (OrientationUtils.this.mIsLand > 0 && !OrientationUtils.this.mClickLand) {
                            return;
                        }
                        OrientationUtils.this.mClickPort = true;
                        OrientationUtils.this.mClick = false;
                        OrientationUtils.this.mIsLand = 0;
                    } else if (OrientationUtils.this.mIsLand > 0) {
                        OrientationUtils.this.screenType = 1;
                        OrientationUtils.this.activity.setRequestedOrientation(1);
                        if (OrientationUtils.this.gsyVideoPlayer.isIfCurrentIsFullscreen()) {
                            OrientationUtils.this.gsyVideoPlayer.getFullscreenButton().setImageResource(OrientationUtils.this.gsyVideoPlayer.getShrinkImageRes());
                        } else {
                            OrientationUtils.this.gsyVideoPlayer.getFullscreenButton().setImageResource(OrientationUtils.this.gsyVideoPlayer.getEnlargeImageRes());
                        }
                        OrientationUtils.this.mIsLand = 0;
                        OrientationUtils.this.mClick = false;
                    }
                } else if (rotation >= 230 && rotation <= 310) {
                    if (OrientationUtils.this.mClick) {
                        if (OrientationUtils.this.mIsLand != 1 && !OrientationUtils.this.mClickPort) {
                            return;
                        }
                        OrientationUtils.this.mClickLand = true;
                        OrientationUtils.this.mClick = false;
                        OrientationUtils.this.mIsLand = 1;
                    } else if (OrientationUtils.this.mIsLand != 1) {
                        OrientationUtils.this.screenType = 0;
                        OrientationUtils.this.activity.setRequestedOrientation(0);
                        OrientationUtils.this.gsyVideoPlayer.getFullscreenButton().setImageResource(OrientationUtils.this.gsyVideoPlayer.getShrinkImageRes());
                        OrientationUtils.this.mIsLand = 1;
                        OrientationUtils.this.mClick = false;
                    }
                } else if (rotation > 30 && rotation < 95) {
                    if (OrientationUtils.this.mClick) {
                        if (OrientationUtils.this.mIsLand != 2 && !OrientationUtils.this.mClickPort) {
                            return;
                        }
                        OrientationUtils.this.mClickLand = true;
                        OrientationUtils.this.mClick = false;
                        OrientationUtils.this.mIsLand = 2;
                    } else if (OrientationUtils.this.mIsLand != 2) {
                        OrientationUtils.this.screenType = 0;
                        OrientationUtils.this.activity.setRequestedOrientation(8);
                        OrientationUtils.this.gsyVideoPlayer.getFullscreenButton().setImageResource(OrientationUtils.this.gsyVideoPlayer.getShrinkImageRes());
                        OrientationUtils.this.mIsLand = 2;
                        OrientationUtils.this.mClick = false;
                    }
                }
            }
        };
        this.orientationEventListener.enable();
    }

    public void resolveByClick() {
        this.mClick = true;
        if (this.mIsLand == 0) {
            this.screenType = 0;
            this.activity.setRequestedOrientation(0);
            this.gsyVideoPlayer.getFullscreenButton().setImageResource(this.gsyVideoPlayer.getShrinkImageRes());
            this.mIsLand = 1;
            this.mClickLand = false;
        } else {
            this.screenType = 1;
            this.activity.setRequestedOrientation(1);
            if (this.gsyVideoPlayer.isIfCurrentIsFullscreen()) {
                this.gsyVideoPlayer.getFullscreenButton().setImageResource(this.gsyVideoPlayer.getShrinkImageRes());
            } else {
                this.gsyVideoPlayer.getFullscreenButton().setImageResource(this.gsyVideoPlayer.getEnlargeImageRes());
            }
            this.mIsLand = 0;
            this.mClickPort = false;
        }
    }

    public int backToProtVideo() {
        if (this.mIsLand > 0) {
            this.mClick = true;
            this.activity.setRequestedOrientation(1);
            if (this.gsyVideoPlayer != null) {
                this.gsyVideoPlayer.getFullscreenButton().setImageResource(this.gsyVideoPlayer.getEnlargeImageRes());
            }
            this.mIsLand = 0;
            this.mClickPort = false;
            return 500;
        }
        return 0;
    }

    public boolean isEnable() {
        return this.mEnable;
    }

    public void setEnable(boolean enable) {
        this.mEnable = enable;
        if (this.mEnable) {
            this.orientationEventListener.enable();
        } else {
            this.orientationEventListener.disable();
        }
    }

    public void releaseListener() {
        if (this.orientationEventListener != null) {
            this.orientationEventListener.disable();
        }
    }

    public boolean isClick() {
        return this.mClick;
    }

    public void setClick(boolean Click) {
        this.mClick = this.mClick;
    }

    public boolean isClickLand() {
        return this.mClickLand;
    }

    public void setClickLand(boolean ClickLand) {
        this.mClickLand = ClickLand;
    }

    public int getIsLand() {
        return this.mIsLand;
    }

    public void setIsLand(int IsLand) {
        this.mIsLand = IsLand;
    }

    public boolean isClickPort() {
        return this.mClickPort;
    }

    public void setClickPort(boolean ClickPort) {
        this.mClickPort = ClickPort;
    }

    public int getScreenType() {
        return this.screenType;
    }

    public void setScreenType(int screenType) {
        this.screenType = screenType;
    }
}

