/*
 * Decompiled with CFR 0.152.
 */
package tv.danmaku.ijk.media.exo2;

import android.content.Context;
import android.net.Uri;
import com.shuyu.gsyvideoplayer.cache.ICacheManager;
import java.io.File;
import java.util.Map;
import tv.danmaku.ijk.media.exo2.ExoSourceManager;
import tv.danmaku.ijk.media.exo2.IjkExo2MediaPlayer;
import tv.danmaku.ijk.media.player.IMediaPlayer;

public class ExoPlayerCacheManager
implements ICacheManager {
    protected ExoSourceManager mExoSourceManager;

    public void doCacheLogic(Context context, IMediaPlayer mediaPlayer, String url, Map<String, String> header, File cachePath) {
        if (!(mediaPlayer instanceof IjkExo2MediaPlayer)) {
            throw new UnsupportedOperationException("ExoPlayerCacheManager only support IjkExo2MediaPlayer");
        }
        IjkExo2MediaPlayer exoPlayer = (IjkExo2MediaPlayer)mediaPlayer;
        this.mExoSourceManager = exoPlayer.getExoHelper();
        exoPlayer.setCache(true);
        exoPlayer.setCacheDir(cachePath);
        exoPlayer.setDataSource(context, Uri.parse((String)url), header);
    }

    public void clearCache(Context context, File cachePath, String url) {
        ExoSourceManager.clearCache(context, cachePath, url);
    }

    public void release() {
        this.mExoSourceManager = null;
    }

    public boolean hadCached() {
        return this.mExoSourceManager != null && this.mExoSourceManager.hadCached();
    }

    public boolean cachePreview(Context context, File cacheDir, String url) {
        return ExoSourceManager.cachePreView(context, cacheDir, url);
    }

    public void setCacheAvailableListener(ICacheManager.ICacheAvailableListener cacheAvailableListener) {
    }
}

