/*
 * Decompiled with CFR 0.152.
 */
package tv.danmaku.ijk.media.exo2;

import android.content.Context;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.view.Surface;
import android.view.SurfaceHolder;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import com.google.android.exoplayer2.DefaultLoadControl;
import com.google.android.exoplayer2.DefaultRenderersFactory;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.LoadControl;
import com.google.android.exoplayer2.PlaybackParameters;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.RenderersFactory;
import com.google.android.exoplayer2.SeekParameters;
import com.google.android.exoplayer2.SimpleExoPlayer;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.analytics.AnalyticsListener;
import com.google.android.exoplayer2.decoder.DecoderCounters;
import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.MediaSourceEventListener;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.trackselection.DefaultTrackSelector;
import com.google.android.exoplayer2.trackselection.MappingTrackSelector;
import com.google.android.exoplayer2.trackselection.TrackSelectionArray;
import com.google.android.exoplayer2.trackselection.TrackSelector;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import tv.danmaku.ijk.media.exo2.ExoSourceManager;
import tv.danmaku.ijk.media.exo2.demo.EventLogger;
import tv.danmaku.ijk.media.player.AbstractMediaPlayer;
import tv.danmaku.ijk.media.player.MediaInfo;
import tv.danmaku.ijk.media.player.misc.IjkTrackInfo;

public class IjkExo2MediaPlayer
extends AbstractMediaPlayer
implements Player.EventListener,
AnalyticsListener {
    public static int ON_POSITION_DISCOUNTINUITY = 2702;
    private static final String TAG = "IjkExo2MediaPlayer";
    protected Context mAppContext;
    protected SimpleExoPlayer mInternalPlayer;
    protected EventLogger mEventLogger;
    protected DefaultRenderersFactory mRendererFactory;
    protected MediaSource mMediaSource;
    protected MappingTrackSelector mTrackSelector;
    protected LoadControl mLoadControl;
    protected String mDataSource;
    protected Surface mSurface;
    protected Map<String, String> mHeaders = new HashMap<String, String>();
    protected PlaybackParameters mSpeedPlaybackParameters;
    protected int mVideoWidth;
    protected int mVideoHeight;
    protected int lastReportedPlaybackState;
    protected boolean isLastReportedPlayWhenReady;
    protected boolean isPreparing = true;
    protected boolean isBuffering = false;
    protected boolean isLooping = false;
    protected boolean isPreview = false;
    protected boolean isCache = false;
    protected ExoSourceManager mExoHelper;
    protected File mCacheDir;
    private String mOverrideExtension;
    protected int audioSessionId = 0;

    public IjkExo2MediaPlayer(Context context) {
        this.mAppContext = context.getApplicationContext();
        this.lastReportedPlaybackState = 1;
        this.mExoHelper = ExoSourceManager.newInstance(context, this.mHeaders);
    }

    private int getVideoRendererIndex() {
        if (this.mInternalPlayer != null) {
            for (int i = 0; i < this.mInternalPlayer.getRendererCount(); ++i) {
                if (this.mInternalPlayer.getRendererType(i) != 2) continue;
                return i;
            }
        }
        return 0;
    }

    public void setDisplay(SurfaceHolder sh) {
        if (sh == null) {
            this.setSurface(null);
        } else {
            this.setSurface(sh.getSurface());
        }
    }

    public void setSurface(Surface surface) {
        this.mSurface = surface;
        if (this.mInternalPlayer != null) {
            if (surface != null && !surface.isValid()) {
                this.mSurface = null;
            }
            this.mInternalPlayer.setVideoSurface(surface);
        }
    }

    public void setDataSource(Context context, Uri uri, Map<String, String> headers) {
        if (headers != null) {
            this.mHeaders.clear();
            this.mHeaders.putAll(headers);
        }
        this.setDataSource(context, uri);
    }

    public void setDataSource(String path) {
        this.setDataSource(this.mAppContext, Uri.parse((String)path));
    }

    public void setDataSource(Context context, Uri uri) {
        this.mDataSource = uri.toString();
        this.mMediaSource = this.mExoHelper.getMediaSource(this.mDataSource, this.isPreview, this.isCache, this.isLooping, this.mCacheDir, this.mOverrideExtension);
    }

    public void setDataSource(FileDescriptor fd) {
        throw new UnsupportedOperationException("no support");
    }

    public String getDataSource() {
        return this.mDataSource;
    }

    public void prepareAsync() throws IllegalStateException {
        if (this.mInternalPlayer != null) {
            throw new IllegalStateException("can't prepare a prepared player");
        }
        this.prepareAsyncInternal();
    }

    public void start() throws IllegalStateException {
        if (this.mInternalPlayer == null) {
            return;
        }
        this.mInternalPlayer.setPlayWhenReady(true);
    }

    public void stop() throws IllegalStateException {
        if (this.mInternalPlayer == null) {
            return;
        }
        this.mInternalPlayer.release();
    }

    public void pause() throws IllegalStateException {
        if (this.mInternalPlayer == null) {
            return;
        }
        this.mInternalPlayer.setPlayWhenReady(false);
    }

    public void setWakeMode(Context context, int mode) {
    }

    public void setScreenOnWhilePlaying(boolean screenOn) {
    }

    public IjkTrackInfo[] getTrackInfo() {
        return null;
    }

    public int getVideoWidth() {
        return this.mVideoWidth;
    }

    public int getVideoHeight() {
        return this.mVideoHeight;
    }

    public boolean isPlaying() {
        if (this.mInternalPlayer == null) {
            return false;
        }
        int state = this.mInternalPlayer.getPlaybackState();
        switch (state) {
            case 2: 
            case 3: {
                return this.mInternalPlayer.getPlayWhenReady();
            }
        }
        return false;
    }

    public void seekTo(long msec) throws IllegalStateException {
        if (this.mInternalPlayer == null) {
            return;
        }
        this.mInternalPlayer.seekTo(msec);
    }

    public long getCurrentPosition() {
        if (this.mInternalPlayer == null) {
            return 0L;
        }
        return this.mInternalPlayer.getCurrentPosition();
    }

    public long getDuration() {
        if (this.mInternalPlayer == null) {
            return 0L;
        }
        return this.mInternalPlayer.getDuration();
    }

    public int getVideoSarNum() {
        return 1;
    }

    public int getVideoSarDen() {
        return 1;
    }

    public void reset() {
        if (this.mInternalPlayer != null) {
            this.mInternalPlayer.release();
            this.mInternalPlayer = null;
        }
        if (this.mExoHelper != null) {
            this.mExoHelper.release();
        }
        this.mSurface = null;
        this.mDataSource = null;
        this.mVideoWidth = 0;
        this.mVideoHeight = 0;
    }

    public void setLooping(boolean looping) {
        this.isLooping = looping;
    }

    public boolean isLooping() {
        return this.isLooping;
    }

    public void setVolume(float leftVolume, float rightVolume) {
        if (this.mInternalPlayer != null) {
            this.mInternalPlayer.setVolume((leftVolume + rightVolume) / 2.0f);
        }
    }

    public int getAudioSessionId() {
        return this.audioSessionId;
    }

    public MediaInfo getMediaInfo() {
        return null;
    }

    public void setLogEnabled(boolean enable) {
    }

    public boolean isPlayable() {
        return true;
    }

    public void setAudioStreamType(int streamtype) {
    }

    public void setKeepInBackground(boolean keepInBackground) {
    }

    public void release() {
        if (this.mInternalPlayer != null) {
            this.reset();
            this.mEventLogger = null;
        }
    }

    protected void prepareAsyncInternal() {
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                int extensionRendererMode;
                if (IjkExo2MediaPlayer.this.mTrackSelector == null) {
                    IjkExo2MediaPlayer.this.mTrackSelector = new DefaultTrackSelector();
                }
                IjkExo2MediaPlayer.this.mEventLogger = new EventLogger(IjkExo2MediaPlayer.this.mTrackSelector);
                boolean preferExtensionDecoders = true;
                boolean useExtensionRenderers = true;
                int n = useExtensionRenderers ? (preferExtensionDecoders ? 2 : 1) : (extensionRendererMode = 0);
                if (IjkExo2MediaPlayer.this.mRendererFactory == null) {
                    IjkExo2MediaPlayer.this.mRendererFactory = new DefaultRenderersFactory(IjkExo2MediaPlayer.this.mAppContext);
                    IjkExo2MediaPlayer.this.mRendererFactory.setExtensionRendererMode(extensionRendererMode);
                }
                if (IjkExo2MediaPlayer.this.mLoadControl == null) {
                    IjkExo2MediaPlayer.this.mLoadControl = new DefaultLoadControl();
                }
                IjkExo2MediaPlayer.this.mInternalPlayer = new SimpleExoPlayer.Builder(IjkExo2MediaPlayer.this.mAppContext, (RenderersFactory)IjkExo2MediaPlayer.this.mRendererFactory).setLooper(Looper.getMainLooper()).setTrackSelector((TrackSelector)IjkExo2MediaPlayer.this.mTrackSelector).setLoadControl(IjkExo2MediaPlayer.this.mLoadControl).build();
                IjkExo2MediaPlayer.this.mInternalPlayer.addListener((Player.EventListener)IjkExo2MediaPlayer.this);
                IjkExo2MediaPlayer.this.mInternalPlayer.addAnalyticsListener((AnalyticsListener)IjkExo2MediaPlayer.this);
                IjkExo2MediaPlayer.this.mInternalPlayer.addListener((Player.EventListener)IjkExo2MediaPlayer.this.mEventLogger);
                if (IjkExo2MediaPlayer.this.mSpeedPlaybackParameters != null) {
                    IjkExo2MediaPlayer.this.mInternalPlayer.setPlaybackParameters(IjkExo2MediaPlayer.this.mSpeedPlaybackParameters);
                }
                if (IjkExo2MediaPlayer.this.mSurface != null) {
                    IjkExo2MediaPlayer.this.mInternalPlayer.setVideoSurface(IjkExo2MediaPlayer.this.mSurface);
                }
                IjkExo2MediaPlayer.this.mInternalPlayer.prepare(IjkExo2MediaPlayer.this.mMediaSource);
                IjkExo2MediaPlayer.this.mInternalPlayer.setPlayWhenReady(false);
            }
        });
    }

    public String getOverrideExtension() {
        return this.mOverrideExtension;
    }

    public void setOverrideExtension(String overrideExtension) {
        this.mOverrideExtension = overrideExtension;
    }

    public void stopPlayback() {
        this.mInternalPlayer.stop();
    }

    public void setPreview(boolean preview) {
        this.isPreview = preview;
    }

    public boolean isPreview() {
        return this.isPreview;
    }

    public boolean isCache() {
        return this.isCache;
    }

    public void setSeekParameter(@Nullable SeekParameters seekParameters) {
        this.mInternalPlayer.setSeekParameters(seekParameters);
    }

    public void setCache(boolean cache) {
        this.isCache = cache;
    }

    public File getCacheDir() {
        return this.mCacheDir;
    }

    public void setCacheDir(File cacheDir) {
        this.mCacheDir = cacheDir;
    }

    public MediaSource getMediaSource() {
        return this.mMediaSource;
    }

    public void setMediaSource(MediaSource mediaSource) {
        this.mMediaSource = mediaSource;
    }

    public ExoSourceManager getExoHelper() {
        return this.mExoHelper;
    }

    public void setSpeed(@Size(min=0L) float speed, @Size(min=0L) float pitch) {
        PlaybackParameters playbackParameters;
        this.mSpeedPlaybackParameters = playbackParameters = new PlaybackParameters(speed, pitch);
        if (this.mInternalPlayer != null) {
            this.mInternalPlayer.setPlaybackParameters(playbackParameters);
        }
    }

    public float getSpeed() {
        return this.mInternalPlayer.getPlaybackParameters().speed;
    }

    public int getBufferedPercentage() {
        if (this.mInternalPlayer == null) {
            return 0;
        }
        return this.mInternalPlayer.getBufferedPercentage();
    }

    public void onTimelineChanged(Timeline timeline, Object manifest, int reason) {
    }

    public MappingTrackSelector getTrackSelector() {
        return this.mTrackSelector;
    }

    public void setTrackSelector(MappingTrackSelector trackSelector) {
        this.mTrackSelector = trackSelector;
    }

    public LoadControl getLoadControl() {
        return this.mLoadControl;
    }

    public void setLoadControl(LoadControl loadControl) {
        this.mLoadControl = loadControl;
    }

    public DefaultRenderersFactory getRendererFactory() {
        return this.mRendererFactory;
    }

    public void setRendererFactory(DefaultRenderersFactory rendererFactory) {
        this.mRendererFactory = rendererFactory;
    }

    public void onTracksChanged(TrackGroupArray trackGroups, TrackSelectionArray trackSelections) {
    }

    public void onLoadingChanged(boolean isLoading) {
    }

    public void onPlayerStateChanged(boolean playWhenReady, int playbackState) {
        if (this.isLastReportedPlayWhenReady != playWhenReady || this.lastReportedPlaybackState != playbackState) {
            if (this.isBuffering) {
                switch (playbackState) {
                    case 3: 
                    case 4: {
                        this.notifyOnInfo(702, this.mInternalPlayer.getBufferedPercentage());
                        this.isBuffering = false;
                    }
                }
            }
            if (this.isPreparing) {
                switch (playbackState) {
                    case 3: {
                        this.notifyOnPrepared();
                        this.isPreparing = false;
                    }
                }
            }
            switch (playbackState) {
                case 2: {
                    this.notifyOnInfo(701, this.mInternalPlayer.getBufferedPercentage());
                    this.isBuffering = true;
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    this.notifyOnCompletion();
                    break;
                }
            }
        }
        this.isLastReportedPlayWhenReady = playWhenReady;
        this.lastReportedPlaybackState = playbackState;
    }

    public void onRepeatModeChanged(int repeatMode) {
    }

    public void onShuffleModeEnabledChanged(boolean shuffleModeEnabled) {
    }

    public void onPlayerError(ExoPlaybackException error) {
        this.notifyOnError(1, 1);
    }

    public void onPositionDiscontinuity(int reason) {
    }

    public void onPlaybackParametersChanged(PlaybackParameters playbackParameters) {
    }

    public void onSeekProcessed() {
        this.notifyOnSeekComplete();
    }

    public void onPlayerStateChanged(AnalyticsListener.EventTime eventTime, boolean playWhenReady, int playbackState) {
    }

    public void onTimelineChanged(AnalyticsListener.EventTime eventTime, int reason) {
    }

    public void onPositionDiscontinuity(AnalyticsListener.EventTime eventTime, int reason) {
        this.notifyOnInfo(ON_POSITION_DISCOUNTINUITY, reason);
    }

    public void onSeekStarted(AnalyticsListener.EventTime eventTime) {
    }

    public void onSeekProcessed(AnalyticsListener.EventTime eventTime) {
    }

    public void onPlaybackParametersChanged(AnalyticsListener.EventTime eventTime, PlaybackParameters playbackParameters) {
    }

    public void onRepeatModeChanged(AnalyticsListener.EventTime eventTime, int repeatMode) {
    }

    public void onShuffleModeChanged(AnalyticsListener.EventTime eventTime, boolean shuffleModeEnabled) {
    }

    public void onLoadingChanged(AnalyticsListener.EventTime eventTime, boolean isLoading) {
    }

    public void onPlayerError(AnalyticsListener.EventTime eventTime, ExoPlaybackException error) {
    }

    public void onTracksChanged(AnalyticsListener.EventTime eventTime, TrackGroupArray trackGroups, TrackSelectionArray trackSelections) {
    }

    public void onLoadStarted(AnalyticsListener.EventTime eventTime, MediaSourceEventListener.LoadEventInfo loadEventInfo, MediaSourceEventListener.MediaLoadData mediaLoadData) {
    }

    public void onLoadCompleted(AnalyticsListener.EventTime eventTime, MediaSourceEventListener.LoadEventInfo loadEventInfo, MediaSourceEventListener.MediaLoadData mediaLoadData) {
    }

    public void onLoadCanceled(AnalyticsListener.EventTime eventTime, MediaSourceEventListener.LoadEventInfo loadEventInfo, MediaSourceEventListener.MediaLoadData mediaLoadData) {
    }

    public void onLoadError(AnalyticsListener.EventTime eventTime, MediaSourceEventListener.LoadEventInfo loadEventInfo, MediaSourceEventListener.MediaLoadData mediaLoadData, IOException error, boolean wasCanceled) {
    }

    public void onDownstreamFormatChanged(AnalyticsListener.EventTime eventTime, MediaSourceEventListener.MediaLoadData mediaLoadData) {
    }

    public void onUpstreamDiscarded(AnalyticsListener.EventTime eventTime, MediaSourceEventListener.MediaLoadData mediaLoadData) {
    }

    public void onMediaPeriodCreated(AnalyticsListener.EventTime eventTime) {
    }

    public void onMediaPeriodReleased(AnalyticsListener.EventTime eventTime) {
    }

    public void onReadingStarted(AnalyticsListener.EventTime eventTime) {
    }

    public void onBandwidthEstimate(AnalyticsListener.EventTime eventTime, int totalLoadTimeMs, long totalBytesLoaded, long bitrateEstimate) {
    }

    public void onMetadata(AnalyticsListener.EventTime eventTime, Metadata metadata) {
    }

    public void onDecoderEnabled(AnalyticsListener.EventTime eventTime, int trackType, DecoderCounters decoderCounters) {
    }

    public void onDecoderInitialized(AnalyticsListener.EventTime eventTime, int trackType, String decoderName, long initializationDurationMs) {
    }

    public void onDecoderInputFormatChanged(AnalyticsListener.EventTime eventTime, int trackType, Format format) {
    }

    public void onDecoderDisabled(AnalyticsListener.EventTime eventTime, int trackType, DecoderCounters decoderCounters) {
        this.audioSessionId = 0;
    }

    public void onAudioSessionId(AnalyticsListener.EventTime eventTime, int audioSessionId) {
        this.audioSessionId = audioSessionId;
    }

    public void onAudioUnderrun(AnalyticsListener.EventTime eventTime, int bufferSize, long bufferSizeMs, long elapsedSinceLastFeedMs) {
    }

    public void onDroppedVideoFrames(AnalyticsListener.EventTime eventTime, int droppedFrames, long elapsedMs) {
    }

    public void onVideoSizeChanged(AnalyticsListener.EventTime eventTime, int width, int height, int unappliedRotationDegrees, float pixelWidthHeightRatio) {
        this.mVideoWidth = (int)((float)width * pixelWidthHeightRatio);
        this.mVideoHeight = height;
        this.notifyOnVideoSizeChanged((int)((float)width * pixelWidthHeightRatio), height, 1, 1);
        if (unappliedRotationDegrees > 0) {
            this.notifyOnInfo(10001, unappliedRotationDegrees);
        }
    }

    public void onRenderedFirstFrame(AnalyticsListener.EventTime eventTime, Surface surface) {
    }

    public void onDrmKeysLoaded(AnalyticsListener.EventTime eventTime) {
    }

    public void onDrmSessionManagerError(AnalyticsListener.EventTime eventTime, Exception error) {
    }

    public void onDrmKeysRestored(AnalyticsListener.EventTime eventTime) {
    }

    public void onDrmKeysRemoved(AnalyticsListener.EventTime eventTime) {
    }
}

