/*
 * Decompiled with CFR 0.152.
 */
package tv.danmaku.ijk.media.exo2;

import android.content.Context;
import android.net.TrafficStats;
import android.net.Uri;
import android.os.Message;
import android.view.Surface;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.SeekParameters;
import com.google.android.exoplayer2.video.DummySurface;
import com.shuyu.gsyvideoplayer.cache.ICacheManager;
import com.shuyu.gsyvideoplayer.model.GSYModel;
import com.shuyu.gsyvideoplayer.model.VideoOptionModel;
import com.shuyu.gsyvideoplayer.player.BasePlayerManager;
import java.util.List;
import tv.danmaku.ijk.media.exo2.IjkExo2MediaPlayer;
import tv.danmaku.ijk.media.player.IMediaPlayer;

public class Exo2PlayerManager
extends BasePlayerManager {
    private Context context;
    private IjkExo2MediaPlayer mediaPlayer;
    private Surface surface;
    private DummySurface dummySurface;
    private long lastTotalRxBytes = 0L;
    private long lastTimeStamp = 0L;

    public IMediaPlayer getMediaPlayer() {
        return this.mediaPlayer;
    }

    public void initVideoPlayer(Context context, Message msg, List<VideoOptionModel> optionModelList, ICacheManager cacheManager) {
        this.context = context.getApplicationContext();
        this.mediaPlayer = new IjkExo2MediaPlayer(context);
        this.mediaPlayer.setAudioStreamType(3);
        if (this.dummySurface == null) {
            this.dummySurface = DummySurface.newInstanceV17((Context)context, (boolean)false);
        }
        GSYModel gsyModel = (GSYModel)msg.obj;
        try {
            this.mediaPlayer.setLooping(gsyModel.isLooping());
            this.mediaPlayer.setPreview(gsyModel.getMapHeadData() != null && gsyModel.getMapHeadData().size() > 0);
            if (gsyModel.isCache() && cacheManager != null) {
                cacheManager.doCacheLogic(context, (IMediaPlayer)this.mediaPlayer, gsyModel.getUrl(), gsyModel.getMapHeadData(), gsyModel.getCachePath());
            } else {
                this.mediaPlayer.setCache(gsyModel.isCache());
                this.mediaPlayer.setCacheDir(gsyModel.getCachePath());
                this.mediaPlayer.setOverrideExtension(gsyModel.getOverrideExtension());
                this.mediaPlayer.setDataSource(context, Uri.parse((String)gsyModel.getUrl()), gsyModel.getMapHeadData());
            }
            if (gsyModel.getSpeed() != 1.0f && gsyModel.getSpeed() > 0.0f) {
                this.mediaPlayer.setSpeed(gsyModel.getSpeed(), 1.0f);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.initSuccess(gsyModel);
    }

    public void showDisplay(Message msg) {
        if (this.mediaPlayer == null) {
            return;
        }
        if (msg.obj == null) {
            this.mediaPlayer.setSurface((Surface)this.dummySurface);
        } else {
            Surface holder;
            this.surface = holder = (Surface)msg.obj;
            this.mediaPlayer.setSurface(holder);
        }
    }

    public void setSpeed(float speed, boolean soundTouch) {
        if (this.mediaPlayer != null) {
            try {
                this.mediaPlayer.setSpeed(speed, 1.0f);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void setNeedMute(boolean needMute) {
        if (this.mediaPlayer != null) {
            if (needMute) {
                this.mediaPlayer.setVolume(0.0f, 0.0f);
            } else {
                this.mediaPlayer.setVolume(1.0f, 1.0f);
            }
        }
    }

    public void setVolume(float left, float right) {
        if (this.mediaPlayer != null) {
            this.mediaPlayer.setVolume(left, right);
        }
    }

    public void releaseSurface() {
        if (this.surface != null) {
            this.surface = null;
        }
    }

    public void release() {
        if (this.mediaPlayer != null) {
            this.mediaPlayer.setSurface(null);
            this.mediaPlayer.release();
        }
        if (this.dummySurface != null) {
            this.dummySurface.release();
            this.dummySurface = null;
        }
        this.lastTotalRxBytes = 0L;
        this.lastTimeStamp = 0L;
    }

    public int getBufferedPercentage() {
        if (this.mediaPlayer != null) {
            return this.mediaPlayer.getBufferedPercentage();
        }
        return 0;
    }

    public long getNetSpeed() {
        if (this.mediaPlayer != null) {
            return this.getNetSpeed(this.context);
        }
        return 0L;
    }

    public void setSpeedPlaying(float speed, boolean soundTouch) {
    }

    public void start() {
        if (this.mediaPlayer != null) {
            this.mediaPlayer.start();
        }
    }

    public void stop() {
        if (this.mediaPlayer != null) {
            this.mediaPlayer.stop();
        }
    }

    public void pause() {
        if (this.mediaPlayer != null) {
            this.mediaPlayer.pause();
        }
    }

    public int getVideoWidth() {
        if (this.mediaPlayer != null) {
            return this.mediaPlayer.getVideoWidth();
        }
        return 0;
    }

    public int getVideoHeight() {
        if (this.mediaPlayer != null) {
            return this.mediaPlayer.getVideoHeight();
        }
        return 0;
    }

    public boolean isPlaying() {
        if (this.mediaPlayer != null) {
            return this.mediaPlayer.isPlaying();
        }
        return false;
    }

    public void seekTo(long time) {
        if (this.mediaPlayer != null) {
            this.mediaPlayer.seekTo(time);
        }
    }

    public long getCurrentPosition() {
        if (this.mediaPlayer != null) {
            return this.mediaPlayer.getCurrentPosition();
        }
        return 0L;
    }

    public long getDuration() {
        if (this.mediaPlayer != null) {
            return this.mediaPlayer.getDuration();
        }
        return 0L;
    }

    public int getVideoSarNum() {
        if (this.mediaPlayer != null) {
            return this.mediaPlayer.getVideoSarNum();
        }
        return 1;
    }

    public int getVideoSarDen() {
        if (this.mediaPlayer != null) {
            return this.mediaPlayer.getVideoSarDen();
        }
        return 1;
    }

    public boolean isSurfaceSupportLockCanvas() {
        return false;
    }

    public void setSeekParameter(@Nullable SeekParameters seekParameters) {
        if (this.mediaPlayer != null) {
            this.mediaPlayer.setSeekParameter(seekParameters);
        }
    }

    private long getNetSpeed(Context context) {
        if (context == null) {
            return 0L;
        }
        long nowTotalRxBytes = TrafficStats.getUidRxBytes((int)context.getApplicationInfo().uid) == -1L ? 0L : TrafficStats.getTotalRxBytes() / 1024L;
        long nowTimeStamp = System.currentTimeMillis();
        long calculationTime = nowTimeStamp - this.lastTimeStamp;
        if (calculationTime == 0L) {
            return calculationTime;
        }
        long speed = (nowTotalRxBytes - this.lastTotalRxBytes) * 1000L / calculationTime;
        this.lastTimeStamp = nowTimeStamp;
        this.lastTotalRxBytes = nowTotalRxBytes;
        return speed;
    }
}

