/*
 * Decompiled with CFR 0.152.
 */
package tv.danmaku.ijk.media.exo2;

import android.content.Context;
import android.net.Uri;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.exoplayer2.ext.rtmp.RtmpDataSourceFactory;
import com.google.android.exoplayer2.extractor.DefaultExtractorsFactory;
import com.google.android.exoplayer2.extractor.ExtractorsFactory;
import com.google.android.exoplayer2.source.ExtractorMediaSource;
import com.google.android.exoplayer2.source.LoopingMediaSource;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.dash.DashChunkSource;
import com.google.android.exoplayer2.source.dash.DashMediaSource;
import com.google.android.exoplayer2.source.dash.DefaultDashChunkSource;
import com.google.android.exoplayer2.source.hls.HlsMediaSource;
import com.google.android.exoplayer2.source.smoothstreaming.DefaultSsChunkSource;
import com.google.android.exoplayer2.source.smoothstreaming.SsChunkSource;
import com.google.android.exoplayer2.source.smoothstreaming.SsMediaSource;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DefaultBandwidthMeter;
import com.google.android.exoplayer2.upstream.DefaultDataSourceFactory;
import com.google.android.exoplayer2.upstream.DefaultHttpDataSourceFactory;
import com.google.android.exoplayer2.upstream.TransferListener;
import com.google.android.exoplayer2.upstream.cache.Cache;
import com.google.android.exoplayer2.upstream.cache.CacheDataSourceFactory;
import com.google.android.exoplayer2.upstream.cache.CacheEvictor;
import com.google.android.exoplayer2.upstream.cache.CacheSpan;
import com.google.android.exoplayer2.upstream.cache.CacheUtil;
import com.google.android.exoplayer2.upstream.cache.LeastRecentlyUsedCacheEvictor;
import com.google.android.exoplayer2.upstream.cache.SimpleCache;
import com.google.android.exoplayer2.util.Util;
import java.io.File;
import java.util.Map;
import java.util.NavigableSet;
import tv.danmaku.ijk.media.exo2.ExoMediaSourceInterceptListener;

public class ExoSourceManager {
    private static final String TAG = "ExoSourceManager";
    private static final long DEFAULT_MAX_SIZE = 0x20000000L;
    public static final int TYPE_RTMP = 4;
    private static Cache mCache;
    private Context mAppContext;
    private Map<String, String> mMapHeadData;
    private String mDataSource;
    private static ExoMediaSourceInterceptListener sExoMediaSourceInterceptListener;
    private boolean isCached = false;

    public static ExoSourceManager newInstance(Context context, @Nullable Map<String, String> mapHeadData) {
        return new ExoSourceManager(context, mapHeadData);
    }

    private ExoSourceManager(Context context, Map<String, String> mapHeadData) {
        this.mAppContext = context.getApplicationContext();
        this.mMapHeadData = mapHeadData;
    }

    public MediaSource getMediaSource(String dataSource, boolean preview, boolean cacheEnable, boolean isLooping, File cacheDir) {
        MediaSource mediaSource = null;
        if (sExoMediaSourceInterceptListener != null) {
            mediaSource = sExoMediaSourceInterceptListener.getMediaSource(dataSource, preview, cacheEnable, isLooping, cacheDir);
        }
        if (mediaSource != null) {
            return mediaSource;
        }
        this.mDataSource = dataSource;
        Uri contentUri = Uri.parse((String)dataSource);
        int contentType = ExoSourceManager.inferContentType(dataSource);
        switch (contentType) {
            case 1: {
                mediaSource = new SsMediaSource.Factory((SsChunkSource.Factory)new DefaultSsChunkSource.Factory(this.getDataSourceFactoryCache(this.mAppContext, cacheEnable, preview, cacheDir)), (DataSource.Factory)new DefaultDataSourceFactory(this.mAppContext, null, this.getHttpDataSourceFactory(this.mAppContext, preview))).createMediaSource(contentUri);
                break;
            }
            case 0: {
                mediaSource = new DashMediaSource.Factory((DashChunkSource.Factory)new DefaultDashChunkSource.Factory(this.getDataSourceFactoryCache(this.mAppContext, cacheEnable, preview, cacheDir)), (DataSource.Factory)new DefaultDataSourceFactory(this.mAppContext, null, this.getHttpDataSourceFactory(this.mAppContext, preview))).createMediaSource(contentUri);
                break;
            }
            case 2: {
                mediaSource = new HlsMediaSource.Factory(this.getDataSourceFactoryCache(this.mAppContext, cacheEnable, preview, cacheDir)).createMediaSource(contentUri);
                break;
            }
            case 4: {
                RtmpDataSourceFactory rtmpDataSourceFactory = new RtmpDataSourceFactory(null);
                mediaSource = new ExtractorMediaSource.Factory((DataSource.Factory)rtmpDataSourceFactory).setExtractorsFactory((ExtractorsFactory)new DefaultExtractorsFactory()).createMediaSource(contentUri);
                break;
            }
            default: {
                mediaSource = new ExtractorMediaSource.Factory(this.getDataSourceFactoryCache(this.mAppContext, cacheEnable, preview, cacheDir)).setExtractorsFactory((ExtractorsFactory)new DefaultExtractorsFactory()).createMediaSource(contentUri);
            }
        }
        if (isLooping) {
            return new LoopingMediaSource(mediaSource);
        }
        return mediaSource;
    }

    public static void setExoMediaSourceInterceptListener(ExoMediaSourceInterceptListener exoMediaSourceInterceptListener) {
        sExoMediaSourceInterceptListener = exoMediaSourceInterceptListener;
    }

    public static void resetExoMediaSourceInterceptListener() {
        sExoMediaSourceInterceptListener = null;
    }

    public static ExoMediaSourceInterceptListener getExoMediaSourceInterceptListener() {
        return sExoMediaSourceInterceptListener;
    }

    public static int inferContentType(String fileName) {
        if ((fileName = Util.toLowerInvariant((String)fileName)).endsWith(".mpd")) {
            return 0;
        }
        if (fileName.endsWith(".m3u8")) {
            return 2;
        }
        if (fileName.endsWith(".ism") || fileName.endsWith(".isml") || fileName.endsWith(".ism/manifest") || fileName.endsWith(".isml/manifest")) {
            return 1;
        }
        if (fileName.startsWith("rtmp:")) {
            return 4;
        }
        return 3;
    }

    public static synchronized Cache getCacheSingleInstance(Context context, File cacheDir) {
        String path;
        boolean isLocked;
        String dirs = context.getCacheDir().getAbsolutePath();
        if (cacheDir != null) {
            dirs = cacheDir.getAbsolutePath();
        }
        if (mCache == null && !(isLocked = SimpleCache.isCacheFolderLocked((File)new File(path = dirs + File.separator + "exo")))) {
            mCache = new SimpleCache(new File(path), (CacheEvictor)new LeastRecentlyUsedCacheEvictor(0x20000000L));
        }
        return mCache;
    }

    public void release() {
        this.isCached = false;
        if (mCache != null) {
            try {
                mCache.release();
                mCache = null;
            }
            catch (Cache.CacheException e) {
                e.printStackTrace();
            }
        }
    }

    public static void clearCache(Context context, File cacheDir, String url) {
        try {
            Cache cache = ExoSourceManager.getCacheSingleInstance(context, cacheDir);
            if (!TextUtils.isEmpty((CharSequence)url)) {
                if (cache != null) {
                    CacheUtil.remove((Cache)cache, (String)CacheUtil.generateKey((Uri)Uri.parse((String)url)));
                }
            } else if (cache != null) {
                for (String key : cache.getKeys()) {
                    CacheUtil.remove((Cache)cache, (String)key);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean cachePreView(Context context, File cacheDir, String url) {
        return ExoSourceManager.resolveCacheState(ExoSourceManager.getCacheSingleInstance(context, cacheDir), url);
    }

    public boolean hadCached() {
        return this.isCached;
    }

    private DataSource.Factory getDataSourceFactoryCache(Context context, boolean cacheEnable, boolean preview, File cacheDir) {
        Cache cache;
        if (cacheEnable && (cache = ExoSourceManager.getCacheSingleInstance(context, cacheDir)) != null) {
            this.isCached = ExoSourceManager.resolveCacheState(cache, this.mDataSource);
            return new CacheDataSourceFactory(cache, this.getDataSourceFactory(context, preview), 2);
        }
        return this.getDataSourceFactory(context, preview);
    }

    private DataSource.Factory getDataSourceFactory(Context context, boolean preview) {
        return new DefaultDataSourceFactory(context, (TransferListener)(preview ? null : new DefaultBandwidthMeter()), this.getHttpDataSourceFactory(context, preview));
    }

    private DataSource.Factory getHttpDataSourceFactory(Context context, boolean preview) {
        DefaultHttpDataSourceFactory dataSourceFactory = new DefaultHttpDataSourceFactory(Util.getUserAgent((Context)context, (String)TAG), (TransferListener)(preview ? null : new DefaultBandwidthMeter()));
        if (this.mMapHeadData != null && this.mMapHeadData.size() > 0) {
            for (Map.Entry<String, String> header : this.mMapHeadData.entrySet()) {
                dataSourceFactory.getDefaultRequestProperties().set(header.getKey(), header.getValue());
            }
        }
        return dataSourceFactory;
    }

    private static boolean resolveCacheState(Cache cache, String url) {
        boolean isCache = true;
        if (!TextUtils.isEmpty((CharSequence)url)) {
            String key = CacheUtil.generateKey((Uri)Uri.parse((String)url));
            if (!TextUtils.isEmpty((CharSequence)key)) {
                NavigableSet cachedSpans = cache.getCachedSpans(key);
                if (cachedSpans.size() == 0) {
                    isCache = false;
                } else {
                    long contentLength = cache.getContentLength(key);
                    long currentLength = 0L;
                    for (CacheSpan cachedSpan : cachedSpans) {
                        currentLength += cache.getCachedLength(key, cachedSpan.position, cachedSpan.length);
                    }
                    isCache = currentLength >= contentLength;
                }
            } else {
                isCache = false;
            }
        }
        return isCache;
    }
}

