/*
 * Decompiled with CFR 0.152.
 */
package com.shunan.circularprogressbar;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.PathEffect;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.LinearInterpolator;
import com.shunan.circularprogressbar.CircularProgressOptions;
import com.shunan.circularprogressbar.R;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u001f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u0000 q2\u00020\u0001:\u0001qB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010`\u001a\u00020a2\u0006\u0010b\u001a\u00020cH\u0002J\u0010\u0010d\u001a\u00020a2\u0006\u0010b\u001a\u00020cH\u0002J\u0006\u0010e\u001a\u00020aJ\u001a\u0010f\u001a\u00020a2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\b\u0010g\u001a\u00020aH\u0014J\b\u0010h\u001a\u00020aH\u0014J\u0010\u0010i\u001a\u00020a2\u0006\u0010b\u001a\u00020cH\u0014J\u0018\u0010j\u001a\u00020a2\u0006\u0010k\u001a\u00020\t2\u0006\u0010l\u001a\u00020\tH\u0014J\u0006\u0010m\u001a\u00020aJ\b\u0010n\u001a\u00020aH\u0002J\u0006\u0010o\u001a\u00020aJ\u0006\u0010p\u001a\u00020aR$\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001e\u0010\u000f\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u0010\u0010\u000eR\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0013\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\u00128F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R$\u0010\u0018\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\u00128F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0019\u0010\u0015\"\u0004\b\u001a\u0010\u0017R$\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\b\u001a\u00020\u001b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R$\u0010!\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\"\u0010\f\"\u0004\b#\u0010\u000eR\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010&\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\u00128F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b'\u0010\u0015\"\u0004\b(\u0010\u0017R$\u0010)\u001a\u00020\u001b2\u0006\u0010\b\u001a\u00020\u001b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b*\u0010\u001e\"\u0004\b+\u0010 R$\u0010,\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b-\u0010\f\"\u0004\b.\u0010\u000eR$\u0010/\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b0\u0010\f\"\u0004\b1\u0010\u000eR\u000e\u00102\u001a\u000203X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u000203X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010:\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b;\u0010\f\"\u0004\b<\u0010\u000eR$\u0010=\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b>\u0010\f\"\u0004\b?\u0010\u000eR\u000e\u0010@\u001a\u00020AX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010B\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bC\u0010\f\"\u0004\bD\u0010\u000eR$\u0010E\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bF\u0010\f\"\u0004\bG\u0010\u000eR$\u0010H\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\u00128F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bI\u0010\u0015\"\u0004\bJ\u0010\u0017R$\u0010K\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bL\u0010\f\"\u0004\bM\u0010\u000eR$\u0010N\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bO\u0010\f\"\u0004\bP\u0010\u000eR$\u0010Q\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\u00128F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bR\u0010\u0015\"\u0004\bS\u0010\u0017R$\u0010T\u001a\u00020\u001b2\u0006\u0010\b\u001a\u00020\u001b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bU\u0010\u001e\"\u0004\bV\u0010 R$\u0010W\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bX\u0010\f\"\u0004\bY\u0010\u000eR$\u0010Z\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b[\u0010\f\"\u0004\b\\\u0010\u000eR$\u0010]\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\u00128B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b^\u0010\u0015\"\u0004\b_\u0010\u0017\u00a8\u0006r"}, d2={"Lcom/shunan/circularprogressbar/CircularProgressBar;", "Landroid/view/View;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "value", "", "animationDuration", "getAnimationDuration", "()I", "setAnimationDuration", "(I)V", "circularProgressBarAlpha", "setCircularProgressBarAlpha", "currentAnimatedProgress", "", "dashLineLength", "getDashLineLength", "()F", "setDashLineLength", "(F)V", "dashLineOffset", "getDashLineOffset", "setDashLineOffset", "", "disableDefaultSweep", "getDisableDefaultSweep", "()Z", "setDisableDefaultSweep", "(Z)V", "dotColor", "getDotColor", "setDotColor", "dotPaint", "Landroid/graphics/Paint;", "dotWidth", "getDotWidth", "setDotWidth", "enableBackgroundDashEffect", "getEnableBackgroundDashEffect", "setEnableBackgroundDashEffect", "fadeRepeatCount", "getFadeRepeatCount", "setFadeRepeatCount", "interpolator", "getInterpolator", "setInterpolator", "mAlphaAnimator", "Landroid/animation/ValueAnimator;", "mBackgroundStrokePaint", "mDefaultSize", "mForegroundStrokePaint", "mProgressAnimator", "mRadius", "mSize", "maxProgress", "getMaxProgress", "setMaxProgress", "minFadeAlpha", "getMinFadeAlpha", "setMinFadeAlpha", "options", "Lcom/shunan/circularprogressbar/CircularProgressOptions;", "progress", "getProgress", "setProgress", "progressBackgroundColor", "getProgressBackgroundColor", "setProgressBackgroundColor", "progressBackgroundWidth", "getProgressBackgroundWidth", "setProgressBackgroundWidth", "progressCap", "getProgressCap", "setProgressCap", "progressColor", "getProgressColor", "setProgressColor", "progressWidth", "getProgressWidth", "setProgressWidth", "showDot", "getShowDot", "setShowDot", "startAngle", "getStartAngle", "setStartAngle", "textColor", "getTextColor", "setTextColor", "textSize", "getTextSize", "setTextSize", "drawDot", "", "canvas", "Landroid/graphics/Canvas;", "drawOutlineArc", "fade", "init", "onAttachedToWindow", "onDetachedFromWindow", "onDraw", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "refresh", "setAnimators", "stopAnimation", "sweep", "Companion", "circularprogressbar_release"})
public final class CircularProgressBar
extends View {
    private final ValueAnimator mProgressAnimator;
    private final ValueAnimator mAlphaAnimator;
    private float currentAnimatedProgress;
    private CircularProgressOptions options;
    private int circularProgressBarAlpha;
    private int mSize;
    private float mRadius;
    private int mDefaultSize;
    private final Paint mForegroundStrokePaint;
    private final Paint mBackgroundStrokePaint;
    private final Paint dotPaint;
    public static final int ROUND = 0;
    public static final int FLAT = 1;
    public static final int LINEAR = 0;
    public static final int ACCELERATE = 1;
    public static final int DECELERATE = 2;
    private static final int DEFAULT_PROGRESS = 25;
    private static final int DEFAULT_MAX_PROGRESS = 100;
    private static final int DEFAULT_PROGRESS_COLOR = -16776961;
    private static final float DEFAULT_PROGRESS_WIDTH = 16.0f;
    private static final float DEFAULT_PROGRESS_BACKGROUND_WIDTH = 4.0f;
    private static final int DEFAULT_PROGRESS_BACKGROUND_COLOR = -3355444;
    private static final int DEFAULT_TEXT_COLOR = -16777216;
    private static final float DEFAULT_TEXT_SIZE = 14.0f;
    private static final int DEFAULT_START_ANGLE = 0;
    private static final boolean DEFAULT_ENABLE_BACKGROUND_DASH_EFFECT = false;
    private static final boolean DEFAULT_SHOW_DOT = true;
    private static final int DEFAULT_PROGRESS_CAP = 0;
    private static final float DEFAULT_DOT_WIDTH = 20.0f;
    private static final float DEFAULT_DASH_LINE_LENGTH = 8.0f;
    private static final float DEFAULT_DASH_LINE_OFFSET = 3.0f;
    private static final int DEFAULT_ANIMATION_DURATION = 1000;
    private static final int DEFAULT_INTERPOLATOR = 0;
    private static final float DEFAULT_SIZE_DP = 128.0f;
    private static final int DEFAULT_ALPHA = 255;
    private static final int DEFAULT_FADE_REPEAT_COUNT = 3;
    private static final int DEFAULT_MIN_FADE_ALPHA = 32;
    public static final Companion Companion = new Companion(null);

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.currentAnimatedProgress = 0.0f;
        this.refresh();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.stopAnimation();
    }

    public final int getProgress() {
        return this.options.getProgress();
    }

    public final void setProgress(int value) {
        this.options.setProgress(value < 0 ? 0 : value);
        this.refresh();
    }

    public final int getMaxProgress() {
        return this.options.getMaxProgress();
    }

    public final void setMaxProgress(int value) {
        if (value < 0) {
            throw (Throwable)new IllegalArgumentException("Maximum Progress can't be negative");
        }
        this.options.setMaxProgress(value);
        this.currentAnimatedProgress = 0.0f;
        this.refresh();
    }

    public final int getProgressColor() {
        return this.options.getProgressColor();
    }

    public final void setProgressColor(int value) {
        this.options.setProgressColor(value);
        this.refresh();
    }

    public final float getProgressWidth() {
        return this.options.getProgressWidth();
    }

    public final void setProgressWidth(float value) {
        if (value < 0.0f) {
            throw (Throwable)new IllegalArgumentException("Progress Width can't be negative");
        }
        this.options.setProgressWidth(value);
        this.refresh();
    }

    public final float getProgressBackgroundWidth() {
        return this.options.getProgressBackgroundWidth();
    }

    public final void setProgressBackgroundWidth(float value) {
        if (value < 0.0f) {
            throw (Throwable)new IllegalArgumentException("Progress Background Width can't be negative");
        }
        this.options.setProgressBackgroundWidth(value);
        this.refresh();
    }

    public final int getProgressBackgroundColor() {
        return this.options.getProgressBackgroundColor();
    }

    public final void setProgressBackgroundColor(int value) {
        this.options.setProgressBackgroundColor(value);
        this.refresh();
    }

    private final int getTextColor() {
        return this.options.getTextColor();
    }

    private final void setTextColor(int value) {
        this.options.setTextColor(value);
        this.refresh();
    }

    private final float getTextSize() {
        return this.options.getTextSize();
    }

    private final void setTextSize(float value) {
        this.options.setTextSize(value);
        this.refresh();
    }

    public final int getStartAngle() {
        return this.options.getStartAngle();
    }

    public final void setStartAngle(int value) {
        this.options.setStartAngle(value);
        this.refresh();
    }

    public final boolean getEnableBackgroundDashEffect() {
        return this.options.getEnableBackgroundDashEffect();
    }

    public final void setEnableBackgroundDashEffect(boolean value) {
        this.options.setEnableBackgroundDashEffect(value);
        this.refresh();
    }

    public final boolean getShowDot() {
        return this.options.getShowDot();
    }

    public final void setShowDot(boolean value) {
        this.options.setShowDot(value);
        this.refresh();
    }

    public final int getProgressCap() {
        return this.options.getProgressCap();
    }

    public final void setProgressCap(int value) {
        if (value != 0 && value != 1) {
            throw (Throwable)new IllegalArgumentException("Invalid Progress Cap");
        }
        this.options.setProgressCap(value);
        this.refresh();
    }

    public final float getDotWidth() {
        return this.options.getDotWidth();
    }

    public final void setDotWidth(float value) {
        if (value < 0.0f) {
            throw (Throwable)new IllegalArgumentException("Dot Width can't be negative");
        }
        this.options.setDotWidth(value);
        this.refresh();
    }

    public final int getDotColor() {
        return this.options.getDotColor();
    }

    public final void setDotColor(int value) {
        this.options.setDotColor(value);
        this.refresh();
    }

    public final float getDashLineLength() {
        return this.options.getDashLineLength();
    }

    public final void setDashLineLength(float value) {
        if (value < 0.0f) {
            throw (Throwable)new IllegalArgumentException("Dash Line Length can't be negative");
        }
        this.options.setDashLineLength(value);
        this.refresh();
    }

    public final float getDashLineOffset() {
        return this.options.getDashLineOffset();
    }

    public final void setDashLineOffset(float value) {
        if (value < 0.0f) {
            throw (Throwable)new IllegalArgumentException("Dash Line Offset can't be negative");
        }
        this.options.setDashLineOffset(value);
        this.refresh();
    }

    public final int getInterpolator() {
        return this.options.getInterpolator();
    }

    public final void setInterpolator(int value) {
        if (value != 0 && value != 1 && value != 2) {
            throw (Throwable)new IllegalArgumentException("Invalid Interpolator");
        }
        this.options.setInterpolator(value);
    }

    public final int getAnimationDuration() {
        return this.options.getAnimationDuration();
    }

    public final void setAnimationDuration(int value) {
        if (value < 0) {
            throw (Throwable)new IllegalArgumentException("Animation Duration can't be negative");
        }
        this.options.setAnimationDuration(value);
    }

    public final int getFadeRepeatCount() {
        return this.options.getFadeRepeatCount();
    }

    public final void setFadeRepeatCount(int value) {
        this.options.setFadeRepeatCount(value);
    }

    public final boolean getDisableDefaultSweep() {
        return this.options.getDisableDefaultSweep();
    }

    public final void setDisableDefaultSweep(boolean value) {
        this.options.setDisableDefaultSweep(value);
    }

    public final int getMinFadeAlpha() {
        return this.options.getMinFadeAlpha();
    }

    public final void setMinFadeAlpha(int value) {
        if (value < 0 || value > 255) {
            throw (Throwable)new IllegalArgumentException("Alpha value should be in range of 0 to 255 inclusive");
        }
        this.options.setMinFadeAlpha(value);
    }

    private final void setCircularProgressBarAlpha(int value) {
        this.circularProgressBarAlpha = value < 0 ? 0 : (value > 255 ? 255 : value);
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        this.drawOutlineArc(canvas);
        if (this.getShowDot()) {
            this.drawDot(canvas);
        }
    }

    private final void drawOutlineArc(Canvas canvas) {
        this.mBackgroundStrokePaint.setAlpha(this.circularProgressBarAlpha);
        this.mForegroundStrokePaint.setAlpha(this.circularProgressBarAlpha);
        this.dotPaint.setAlpha(this.circularProgressBarAlpha);
        canvas.drawCircle((float)this.mSize / 2.0f, (float)this.mSize / 2.0f, this.mRadius, this.mBackgroundStrokePaint);
        float pad = (float)(this.mSize / 2) - this.mRadius;
        RectF outerOval = new RectF(pad, pad, (float)this.mSize - pad, (float)this.mSize - pad);
        this.mForegroundStrokePaint.setStrokeCap(this.getProgressCap() == 0 ? Paint.Cap.ROUND : Paint.Cap.BUTT);
        float angle = this.currentAnimatedProgress * (float)360 / (float)this.getMaxProgress();
        canvas.drawArc(outerOval, (float)this.getStartAngle() - (float)90, angle, false, this.mForegroundStrokePaint);
    }

    private final void drawDot(Canvas canvas) {
        double angle = (double)(this.currentAnimatedProgress * (float)360) / (double)this.getMaxProgress() + (double)this.getStartAngle();
        double x = (double)(this.mSize / 2) + (double)this.mRadius * Math.sin(Math.toRadians(angle));
        double y = (double)(this.mSize / 2) - (double)this.mRadius * Math.cos(Math.toRadians(angle));
        canvas.drawCircle((float)x, (float)y, this.getDotWidth() / (float)2, this.dotPaint);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int n;
        int n2;
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int defaultSize = this.mDefaultSize;
        int defaultWidth = Math.max(this.getSuggestedMinimumWidth(), defaultSize);
        int defaultHeight = Math.max(this.getSuggestedMinimumHeight(), defaultSize);
        switch (widthMode) {
            case 0x40000000: {
                n2 = widthSize;
                break;
            }
            case -2147483648: {
                n2 = Math.min(defaultWidth, widthSize);
                break;
            }
            case 0: {
                n2 = defaultWidth;
                break;
            }
            default: {
                n2 = defaultWidth;
            }
        }
        int width = n2;
        switch (heightMode) {
            case 0x40000000: {
                n = heightSize;
                break;
            }
            case -2147483648: {
                n = width;
                break;
            }
            case 0: {
                n = width;
                break;
            }
            default: {
                n = width;
            }
        }
        int height = n;
        this.mSize = Math.min(width, height);
        this.mRadius = ((float)this.mSize - Math.max(Math.max(this.getProgressBackgroundWidth(), this.getProgressWidth()), this.getDotWidth())) / 2.0f;
        this.setMeasuredDimension(this.mSize, this.mSize);
    }

    /*
     * WARNING - void declaration
     */
    private final void init(Context context, AttributeSet attrs) {
        Float[] typedArray;
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        this.mDefaultSize = Math.round(128.0f * displayMetrics.density);
        this.mForegroundStrokePaint.setAntiAlias(true);
        this.mBackgroundStrokePaint.setAntiAlias(true);
        this.dotPaint.setAntiAlias(true);
        this.mForegroundStrokePaint.setStyle(Paint.Style.STROKE);
        this.mBackgroundStrokePaint.setStyle(Paint.Style.STROKE);
        this.dotPaint.setStyle(Paint.Style.FILL);
        if (attrs == null) {
            this.options.setProgress(25);
            this.options.setMaxProgress(100);
            this.options.setProgressColor(-16776961);
            this.options.setProgressWidth(16.0f * displayMetrics.density);
            this.options.setProgressBackgroundColor(-3355444);
            this.options.setProgressBackgroundWidth(4.0f * displayMetrics.density);
            this.options.setTextColor(-16777216);
            this.options.setTextSize(14.0f);
            this.options.setStartAngle(0);
            this.options.setDotWidth(20.0f * displayMetrics.density);
            this.options.setDotColor(-16776961);
            this.options.setEnableBackgroundDashEffect(false);
            this.options.setShowDot(true);
            this.options.setProgressCap(0);
            this.options.setAnimationDuration(1000);
            this.options.setInterpolator(0);
        } else {
            typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.CircularProgressBar, 0, 0);
            this.options.setProgress(typedArray.getInt(R.styleable.CircularProgressBar_progress, 25));
            this.options.setMaxProgress(typedArray.getInt(R.styleable.CircularProgressBar_maxProgress, 100));
            this.options.setProgressColor(typedArray.getColor(R.styleable.CircularProgressBar_progressColor, -16776961));
            this.options.setProgressWidth(typedArray.getDimension(R.styleable.CircularProgressBar_progressWidth, 16.0f * displayMetrics.density));
            this.options.setProgressBackgroundWidth(typedArray.getDimension(R.styleable.CircularProgressBar_progressBackgroundWidth, 4.0f * displayMetrics.density));
            this.options.setProgressBackgroundColor(typedArray.getInt(R.styleable.CircularProgressBar_progressBackgroundColor, -3355444));
            this.options.setStartAngle(typedArray.getInteger(R.styleable.CircularProgressBar_startAngle, 0));
            this.options.setEnableBackgroundDashEffect(typedArray.getBoolean(R.styleable.CircularProgressBar_enableBackgroundDashEffect, false));
            this.options.setShowDot(typedArray.getBoolean(R.styleable.CircularProgressBar_showDot, true));
            this.options.setDotWidth(typedArray.getDimension(R.styleable.CircularProgressBar_dotWidth, 20.0f * displayMetrics.density));
            this.options.setDotColor(typedArray.getColor(R.styleable.CircularProgressBar_progressColor, -16776961));
            this.options.setAnimationDuration(typedArray.getInteger(R.styleable.CircularProgressBar_animationDuration, 1000));
            this.options.setProgressCap(typedArray.getInt(R.styleable.CircularProgressBar_progressCap, 0));
            this.options.setInterpolator(typedArray.getInt(R.styleable.CircularProgressBar_interpolator, 0));
            typedArray.recycle();
        }
        this.setCircularProgressBarAlpha(255);
        this.options.setDashLineLength(8.0f * displayMetrics.density);
        this.options.setDashLineOffset(3.0f * displayMetrics.density);
        if (this.getEnableBackgroundDashEffect()) {
            void elements$iv;
            DashPathEffect dashPathEffect;
            typedArray = new Float[]{Float.valueOf(this.getDashLineLength() * displayMetrics.density), Float.valueOf(this.getDashLineOffset() * displayMetrics.density)};
            DashPathEffect dashPathEffect2 = dashPathEffect;
            DashPathEffect dashPathEffect3 = dashPathEffect;
            Paint paint = this.mBackgroundStrokePaint;
            void var8_8 = elements$iv;
            dashPathEffect2(ArraysKt.toFloatArray((Float[])var8_8), 1.0f);
            paint.setPathEffect((PathEffect)dashPathEffect3);
        } else {
            this.mBackgroundStrokePaint.setPathEffect((PathEffect)null);
        }
        this.options.setFadeRepeatCount(3);
        this.options.setMinFadeAlpha(32);
        this.mBackgroundStrokePaint.setColor(this.getProgressBackgroundColor());
        this.mForegroundStrokePaint.setColor(this.getProgressColor());
        this.dotPaint.setColor(this.getDotColor());
        this.mBackgroundStrokePaint.setStrokeWidth(this.getProgressBackgroundWidth());
        this.mForegroundStrokePaint.setStrokeWidth(this.getProgressWidth());
        this.dotPaint.setStrokeWidth(this.getDotWidth());
    }

    private final void setAnimators() {
        this.mProgressAnimator.setFloatValues(new float[]{0.0f, this.getProgress()});
        this.mProgressAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(this){
            final /* synthetic */ CircularProgressBar this$0;

            public final void onAnimationUpdate(ValueAnimator animation) {
                String string = animation.getAnimatedValue().toString();
                CircularProgressBar circularProgressBar = this.this$0;
                float f = Float.parseFloat(string);
                CircularProgressBar.access$setCurrentAnimatedProgress$p(circularProgressBar, f);
                this.this$0.invalidate();
            }
            {
                this.this$0 = circularProgressBar;
            }
        });
        this.mAlphaAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(this){
            final /* synthetic */ CircularProgressBar this$0;

            public final void onAnimationUpdate(ValueAnimator animation) {
                String string = animation.getAnimatedValue().toString();
                CircularProgressBar circularProgressBar = this.this$0;
                float f = Float.parseFloat(string);
                CircularProgressBar.access$setCircularProgressBarAlpha$p(circularProgressBar, (int)(Math.abs(f * (float)2 / (float)this.this$0.getAnimationDuration() - 1.0f) * (float)(255 - this.this$0.getMinFadeAlpha()) + (float)this.this$0.getMinFadeAlpha()));
                this.this$0.invalidate();
            }
            {
                this.this$0 = circularProgressBar;
            }
        });
    }

    public final void refresh() {
        this.setCircularProgressBarAlpha(255);
        this.mBackgroundStrokePaint.setColor(this.getProgressBackgroundColor());
        this.mForegroundStrokePaint.setColor(this.getProgressColor());
        this.dotPaint.setColor(this.getDotColor());
        this.mBackgroundStrokePaint.setStrokeWidth(this.getProgressBackgroundWidth());
        this.mForegroundStrokePaint.setStrokeWidth(this.getProgressWidth());
        this.dotPaint.setStrokeWidth(this.getDotWidth());
        this.mRadius = ((float)this.mSize - Math.max(Math.max(this.getProgressBackgroundWidth(), this.getProgressWidth()), this.getDotWidth())) / 2.0f;
        DisplayMetrics displayMetrics = this.getContext().getResources().getDisplayMetrics();
        if (this.getEnableBackgroundDashEffect()) {
            DashPathEffect dashPathEffect;
            Float[] floatArray = new Float[]{Float.valueOf(this.getDashLineLength() * displayMetrics.density), Float.valueOf(this.getDashLineOffset() * displayMetrics.density)};
            DashPathEffect dashPathEffect2 = dashPathEffect;
            DashPathEffect dashPathEffect3 = dashPathEffect;
            Paint paint = this.mBackgroundStrokePaint;
            Float[] floatArray2 = floatArray;
            dashPathEffect2(ArraysKt.toFloatArray((Float[])floatArray2), 1.0f);
            paint.setPathEffect((PathEffect)dashPathEffect3);
        } else {
            this.mBackgroundStrokePaint.setPathEffect((PathEffect)null);
        }
        if (this.getProgress() != (int)this.currentAnimatedProgress && !this.getDisableDefaultSweep()) {
            this.sweep();
        } else {
            this.currentAnimatedProgress = this.getProgress();
            this.invalidate();
        }
    }

    public final void stopAnimation() {
        this.setCircularProgressBarAlpha(255);
        this.currentAnimatedProgress = this.getProgress();
        if (this.mProgressAnimator.isRunning()) {
            this.mProgressAnimator.cancel();
        }
        if (this.mAlphaAnimator.isRunning()) {
            this.mAlphaAnimator.cancel();
        }
        this.invalidate();
    }

    public final void sweep() {
        TimeInterpolator timeInterpolator;
        if ((int)this.currentAnimatedProgress == this.getProgress()) {
            this.currentAnimatedProgress = 0.0f;
        }
        this.mProgressAnimator.setFloatValues(new float[]{this.currentAnimatedProgress, this.getProgress()});
        this.mProgressAnimator.setDuration((long)this.getAnimationDuration());
        switch (this.getInterpolator()) {
            case 1: {
                timeInterpolator = (TimeInterpolator)new AccelerateInterpolator();
                break;
            }
            case 2: {
                timeInterpolator = (TimeInterpolator)new DecelerateInterpolator();
                break;
            }
            default: {
                timeInterpolator = (TimeInterpolator)new LinearInterpolator();
            }
        }
        this.mProgressAnimator.setInterpolator(timeInterpolator);
        this.mProgressAnimator.start();
    }

    public final void fade() {
        TimeInterpolator timeInterpolator;
        this.currentAnimatedProgress = this.getProgress();
        this.mAlphaAnimator.setDuration((long)this.getAnimationDuration());
        switch (this.getInterpolator()) {
            case 1: {
                timeInterpolator = (TimeInterpolator)new AccelerateInterpolator();
                break;
            }
            case 2: {
                timeInterpolator = (TimeInterpolator)new DecelerateInterpolator();
                break;
            }
            default: {
                timeInterpolator = (TimeInterpolator)new LinearInterpolator();
            }
        }
        this.mAlphaAnimator.setInterpolator(timeInterpolator);
        this.mAlphaAnimator.setFloatValues(new float[]{0.0f, this.getAnimationDuration()});
        this.mAlphaAnimator.setRepeatCount(this.getFadeRepeatCount());
        this.mAlphaAnimator.start();
    }

    public CircularProgressBar(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
        this.mProgressAnimator = new ValueAnimator();
        this.mAlphaAnimator = new ValueAnimator();
        this.options = new CircularProgressOptions();
        this.circularProgressBarAlpha = 255;
        this.mForegroundStrokePaint = new Paint(1);
        this.mBackgroundStrokePaint = new Paint(1);
        this.dotPaint = new Paint(1);
        this.init(context, null);
    }

    public CircularProgressBar(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        super(context, attrs);
        this.mProgressAnimator = new ValueAnimator();
        this.mAlphaAnimator = new ValueAnimator();
        this.options = new CircularProgressOptions();
        this.circularProgressBarAlpha = 255;
        this.mForegroundStrokePaint = new Paint(1);
        this.mBackgroundStrokePaint = new Paint(1);
        this.dotPaint = new Paint(1);
        this.init(context, attrs);
        this.setAnimators();
    }

    public static final /* synthetic */ float access$getCurrentAnimatedProgress$p(CircularProgressBar $this) {
        return $this.currentAnimatedProgress;
    }

    public static final /* synthetic */ void access$setCurrentAnimatedProgress$p(CircularProgressBar $this, float f) {
        $this.currentAnimatedProgress = f;
    }

    public static final /* synthetic */ int access$getCircularProgressBarAlpha$p(CircularProgressBar $this) {
        return $this.circularProgressBarAlpha;
    }

    public static final /* synthetic */ void access$setCircularProgressBarAlpha$p(CircularProgressBar $this, int n) {
        $this.setCircularProgressBarAlpha(n);
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0013\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/shunan/circularprogressbar/CircularProgressBar$Companion;", "", "()V", "ACCELERATE", "", "DECELERATE", "DEFAULT_ALPHA", "DEFAULT_ANIMATION_DURATION", "DEFAULT_DASH_LINE_LENGTH", "", "DEFAULT_DASH_LINE_OFFSET", "DEFAULT_DOT_WIDTH", "DEFAULT_ENABLE_BACKGROUND_DASH_EFFECT", "", "DEFAULT_FADE_REPEAT_COUNT", "DEFAULT_INTERPOLATOR", "DEFAULT_MAX_PROGRESS", "DEFAULT_MIN_FADE_ALPHA", "DEFAULT_PROGRESS", "DEFAULT_PROGRESS_BACKGROUND_COLOR", "DEFAULT_PROGRESS_BACKGROUND_WIDTH", "DEFAULT_PROGRESS_CAP", "DEFAULT_PROGRESS_COLOR", "DEFAULT_PROGRESS_WIDTH", "DEFAULT_SHOW_DOT", "DEFAULT_SIZE_DP", "DEFAULT_START_ANGLE", "DEFAULT_TEXT_COLOR", "DEFAULT_TEXT_SIZE", "FLAT", "LINEAR", "ROUND", "circularprogressbar_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

