/*
 * Decompiled with CFR 0.152.
 */
package com.shunan.circularprogressbar;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.PathEffect;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.LinearInterpolator;
import com.shunan.circularprogressbar.R;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u0007\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b*\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 m2\u00020\u0001:\u0001mB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010^\u001a\u00020_J\u0010\u0010`\u001a\u00020_2\u0006\u0010a\u001a\u00020bH\u0002J\u0010\u0010c\u001a\u00020_2\u0006\u0010a\u001a\u00020bH\u0002J\u001a\u0010d\u001a\u00020_2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\b\u0010e\u001a\u00020_H\u0014J\u0010\u0010f\u001a\u00020_2\u0006\u0010a\u001a\u00020bH\u0014J\u0018\u0010g\u001a\u00020_2\u0006\u0010h\u001a\u00020\t2\u0006\u0010i\u001a\u00020\tH\u0014J\u0006\u0010j\u001a\u00020_J\b\u0010k\u001a\u00020_H\u0002J\u0006\u0010l\u001a\u00020_R$\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR$\u0010\u000f\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR$\u0010\u0012\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\f\"\u0004\b\u0014\u0010\u000eR\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0017\u001a\u00020\u00162\u0006\u0010\b\u001a\u00020\u0016@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR$\u0010\u001c\u001a\u00020\u00162\u0006\u0010\b\u001a\u00020\u0016@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0019\"\u0004\b\u001e\u0010\u001bR\u001a\u0010\u001f\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\f\"\u0004\b!\u0010\u000eR\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010$\u001a\u00020\u00162\u0006\u0010\b\u001a\u00020\u0016@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u0019\"\u0004\b&\u0010\u001bR\u001a\u0010'\u001a\u00020(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R$\u0010-\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010\f\"\u0004\b/\u0010\u000eR$\u00100\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010\f\"\u0004\b2\u0010\u000eR\u000e\u00103\u001a\u000204X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u000204X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010:\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010;\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010\f\"\u0004\b=\u0010\u000eR$\u0010>\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u0010\f\"\u0004\b@\u0010\u000eR$\u0010A\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bB\u0010\f\"\u0004\bC\u0010\u000eR\u001a\u0010D\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bE\u0010\f\"\u0004\bF\u0010\u000eR$\u0010G\u001a\u00020\u00162\u0006\u0010\b\u001a\u00020\u0016@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bH\u0010\u0019\"\u0004\bI\u0010\u001bR$\u0010J\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bK\u0010\f\"\u0004\bL\u0010\u000eR\u001a\u0010M\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bN\u0010\f\"\u0004\bO\u0010\u000eR$\u0010P\u001a\u00020\u00162\u0006\u0010\b\u001a\u00020\u0016@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bQ\u0010\u0019\"\u0004\bR\u0010\u001bR\u001a\u0010S\u001a\u00020(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bT\u0010*\"\u0004\bU\u0010,R\u001a\u0010V\u001a\u00020(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bW\u0010*\"\u0004\bX\u0010,R&\u0010Y\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t8F@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bZ\u0010\f\"\u0004\b[\u0010\u000eR\u000e\u0010\\\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010]\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006n"}, d2={"Lcom/shunan/circularprogressbar/CircularProgressBar;", "Landroid/view/View;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "value", "", "animationDuration", "getAnimationDuration", "()I", "setAnimationDuration", "(I)V", "animationEffect", "getAnimationEffect", "setAnimationEffect", "circularProgressBarAlpha", "getCircularProgressBarAlpha", "setCircularProgressBarAlpha", "currentAnimatedProgress", "", "dashLineLength", "getDashLineLength", "()F", "setDashLineLength", "(F)V", "dashLineOffset", "getDashLineOffset", "setDashLineOffset", "dotColor", "getDotColor", "setDotColor", "dotPaint", "Landroid/graphics/Paint;", "dotWidth", "getDotWidth", "setDotWidth", "enableBackgroundDashEffect", "", "getEnableBackgroundDashEffect", "()Z", "setEnableBackgroundDashEffect", "(Z)V", "fadeRepeatCount", "getFadeRepeatCount", "setFadeRepeatCount", "interpolator", "getInterpolator", "setInterpolator", "mAlphaAnimator", "Landroid/animation/ValueAnimator;", "mBackgroundStrokePaint", "mDefaultSize", "mForegroundStrokePaint", "mProgressAnimator", "mRadius", "mSize", "maxProgress", "getMaxProgress", "setMaxProgress", "minFadeAlpha", "getMinFadeAlpha", "setMinFadeAlpha", "progress", "getProgress", "setProgress", "progressBackgroundColor", "getProgressBackgroundColor", "setProgressBackgroundColor", "progressBackgroundWidth", "getProgressBackgroundWidth", "setProgressBackgroundWidth", "progressCap", "getProgressCap", "setProgressCap", "progressColor", "getProgressColor", "setProgressColor", "progressWidth", "getProgressWidth", "setProgressWidth", "showDot", "getShowDot", "setShowDot", "showProgressBackground", "getShowProgressBackground", "setShowProgressBackground", "startAngle", "getStartAngle", "setStartAngle", "textColor", "textSize", "animateView", "", "drawDot", "canvas", "Landroid/graphics/Canvas;", "drawOutlineArc", "init", "onAttachedToWindow", "onDraw", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "refresh", "setAnimators", "stopAnimation", "Companion", "circularprogressbar_release"})
public final class CircularProgressBar
extends View {
    private final ValueAnimator mProgressAnimator;
    private final ValueAnimator mAlphaAnimator;
    private float currentAnimatedProgress;
    private int progress;
    private int maxProgress;
    private int progressColor;
    private float progressWidth;
    private float progressBackgroundWidth;
    private int progressBackgroundColor;
    private int textColor;
    private float textSize;
    private int startAngle;
    private boolean showProgressBackground;
    private boolean enableBackgroundDashEffect;
    private boolean showDot;
    private int progressCap;
    private float dotWidth;
    private int dotColor;
    private float dashLineLength;
    private float dashLineOffset;
    private int interpolator;
    private int animationDuration;
    private int animationEffect;
    private int fadeRepeatCount;
    private int circularProgressBarAlpha;
    private int minFadeAlpha;
    private int mSize;
    private float mRadius;
    private int mDefaultSize;
    private final Paint mForegroundStrokePaint;
    private final Paint mBackgroundStrokePaint;
    private final Paint dotPaint;
    public static final int NONE = 0;
    public static final int SWEEP = 1;
    public static final int FADE = 2;
    public static final int ROUND = 0;
    public static final int FLAT = 1;
    public static final int LINEAR = 0;
    public static final int ACCELERATE = 1;
    public static final int DECELERATE = 2;
    private static final int DEFAULT_PROGRESS = 25;
    private static final int DEFAULT_MAX_PROGRESS = 100;
    private static final int DEFAULT_PROGRESS_COLOR = -16776961;
    private static final float DEFAULT_PROGRESS_WIDTH = 32.0f;
    private static final float DEFAULT_PROGRESS_BACKGROUND_WIDTH = 16.0f;
    private static final int DEFAULT_PROGRESS_BACKGROUND_COLOR = -3355444;
    private static final int DEFAULT_TEXT_COLOR = -16777216;
    private static final float DEFAULT_TEXT_SIZE = 14.0f;
    private static final int DEFAULT_START_ANGLE = 0;
    private static final boolean DEFAULT_SHOW_PROGRESS_BACKGROUND = true;
    private static final boolean DEFAULT_ENABLE_BACKGROUND_DASH_EFFECT = false;
    private static final boolean DEFAULT_SHOW_DOT = true;
    private static final int DEFAULT_PROGRESS_CAP = 0;
    private static final float DEFAULT_DOT_WIDTH = 20.0f;
    private static final float DEFAULT_DASH_LINE_LENGTH = 12.0f;
    private static final float DEFAULT_DASH_LINE_OFFSET = 4.0f;
    private static final int DEFAULT_ANIMATION_DURATION = 500;
    private static final int DEFAULT_INTERPOLATOR = 0;
    private static final int DEFAULT_ANIMATION_EFFECT = 0;
    private static final float DEFAULT_SIZE_DP = 48.0f;
    private static final int DEFAULT_ALPHA = 255;
    private static final int DEFAULT_FADE_REPEAT_COUNT = 3;
    private static final int DEFAULT_MIN_FADE_ALPHA = 85;
    public static final Companion Companion = new Companion(null);

    public final int getProgress() {
        return this.progress;
    }

    public final void setProgress(int value) {
        if (value < 0) {
            throw (Throwable)new IllegalArgumentException("Progress can't be negative");
        }
        this.progress = value;
        this.currentAnimatedProgress = value;
    }

    public final int getMaxProgress() {
        return this.maxProgress;
    }

    public final void setMaxProgress(int value) {
        if (value < 0) {
            throw (Throwable)new IllegalArgumentException("Maximum Progress can't be negative");
        }
        this.maxProgress = value;
    }

    public final int getProgressColor() {
        return this.progressColor;
    }

    public final void setProgressColor(int n) {
        this.progressColor = n;
    }

    public final float getProgressWidth() {
        return this.progressWidth;
    }

    public final void setProgressWidth(float value) {
        if (value < 0.0f) {
            throw (Throwable)new IllegalArgumentException("Progress Width can't be negative");
        }
        this.progressWidth = value;
    }

    public final float getProgressBackgroundWidth() {
        return this.progressBackgroundWidth;
    }

    public final void setProgressBackgroundWidth(float value) {
        if (value < 0.0f) {
            throw (Throwable)new IllegalArgumentException("Progress Background Width can't be negative");
        }
        this.progressBackgroundWidth = value;
    }

    public final int getProgressBackgroundColor() {
        return this.progressBackgroundColor;
    }

    public final void setProgressBackgroundColor(int n) {
        this.progressBackgroundColor = n;
    }

    public final int getStartAngle() {
        return this.startAngle + 90;
    }

    public final void setStartAngle(int value) {
        this.startAngle = value - 90;
    }

    public final boolean getShowProgressBackground() {
        return this.showProgressBackground;
    }

    public final void setShowProgressBackground(boolean bl) {
        this.showProgressBackground = bl;
    }

    public final boolean getEnableBackgroundDashEffect() {
        return this.enableBackgroundDashEffect;
    }

    public final void setEnableBackgroundDashEffect(boolean bl) {
        this.enableBackgroundDashEffect = bl;
    }

    public final boolean getShowDot() {
        return this.showDot;
    }

    public final void setShowDot(boolean bl) {
        this.showDot = bl;
    }

    public final int getProgressCap() {
        return this.progressCap;
    }

    public final void setProgressCap(int value) {
        if (value != 0 && value != 1) {
            throw (Throwable)new IllegalArgumentException("Invalid Progress Cap");
        }
        this.progressCap = value;
    }

    public final float getDotWidth() {
        return this.dotWidth;
    }

    public final void setDotWidth(float value) {
        if (value < 0.0f) {
            throw (Throwable)new IllegalArgumentException("Dot Width can't be negative");
        }
        this.dotWidth = value;
    }

    public final int getDotColor() {
        return this.dotColor;
    }

    public final void setDotColor(int n) {
        this.dotColor = n;
    }

    public final float getDashLineLength() {
        return this.dashLineLength;
    }

    public final void setDashLineLength(float value) {
        if (value < 0.0f) {
            throw (Throwable)new IllegalArgumentException("Dash Line Length can't be negative");
        }
        this.dashLineLength = value;
    }

    public final float getDashLineOffset() {
        return this.dashLineOffset;
    }

    public final void setDashLineOffset(float value) {
        if (value < 0.0f) {
            throw (Throwable)new IllegalArgumentException("Dash Line Offset can't be negative");
        }
        this.dashLineOffset = value;
    }

    public final int getInterpolator() {
        return this.interpolator;
    }

    public final void setInterpolator(int value) {
        if (value != 0 && value != 1 && value != 2) {
            throw (Throwable)new IllegalArgumentException("Invalid Interpolator");
        }
        this.interpolator = value;
    }

    public final int getAnimationDuration() {
        return this.animationDuration;
    }

    public final void setAnimationDuration(int value) {
        if (value < 0) {
            throw (Throwable)new IllegalArgumentException("Animation Duration can't be negative");
        }
        this.animationDuration = value;
    }

    public final int getAnimationEffect() {
        return this.animationEffect;
    }

    public final void setAnimationEffect(int value) {
        if (value != 0 && value != 1 && value != 2) {
            throw (Throwable)new IllegalArgumentException("Invalid Animation Effect");
        }
        this.animationEffect = value;
    }

    public final int getFadeRepeatCount() {
        return this.fadeRepeatCount;
    }

    public final void setFadeRepeatCount(int value) {
        if (value < 1) {
            throw (Throwable)new IllegalArgumentException("Fade Repeat Count should be greater than or equal to 1");
        }
        this.fadeRepeatCount = value;
    }

    public final int getCircularProgressBarAlpha() {
        return this.circularProgressBarAlpha;
    }

    public final void setCircularProgressBarAlpha(int value) {
        if (value < 0 || value > 255) {
            throw (Throwable)new IllegalArgumentException("Alpha value should be in range of 0 to 255 inclusive");
        }
        this.circularProgressBarAlpha = value;
    }

    public final int getMinFadeAlpha() {
        return this.minFadeAlpha;
    }

    public final void setMinFadeAlpha(int value) {
        if (value < 0 || value > 255) {
            throw (Throwable)new IllegalArgumentException("Alpha value should be in range of 0 to 255 inclusive");
        }
        this.minFadeAlpha = value;
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        this.drawOutlineArc(canvas);
        this.drawDot(canvas);
    }

    private final void drawOutlineArc(Canvas canvas) {
        this.mBackgroundStrokePaint.setAlpha(this.circularProgressBarAlpha);
        this.mForegroundStrokePaint.setAlpha(this.circularProgressBarAlpha);
        this.dotPaint.setAlpha(this.circularProgressBarAlpha);
        canvas.drawCircle((float)this.mSize / 2.0f, (float)this.mSize / 2.0f, this.mRadius, this.mBackgroundStrokePaint);
        float pad = (float)(this.mSize / 2) - this.mRadius;
        RectF outerOval = new RectF(pad, pad, (float)this.mSize - pad, (float)this.mSize - pad);
        this.mForegroundStrokePaint.setStrokeCap(Paint.Cap.ROUND);
        float angle = this.currentAnimatedProgress * (float)360 / (float)this.maxProgress;
        canvas.drawArc(outerOval, (float)this.getStartAngle() - (float)90, angle, false, this.mForegroundStrokePaint);
    }

    private final void drawDot(Canvas canvas) {
        double angle = (double)(this.currentAnimatedProgress * (float)360) / (double)this.maxProgress + (double)this.getStartAngle();
        double x = (double)(this.mSize / 2) + (double)this.mRadius * Math.sin(Math.toRadians(angle));
        double y = (double)(this.mSize / 2) - (double)this.mRadius * Math.cos(Math.toRadians(angle));
        canvas.drawCircle((float)x, (float)y, this.dotWidth / (float)2, this.dotPaint);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int n;
        int n2;
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int defaultSize = this.mDefaultSize;
        int defaultWidth = Math.max(this.getSuggestedMinimumWidth(), defaultSize);
        int defaultHeight = Math.max(this.getSuggestedMinimumHeight(), defaultSize);
        switch (widthMode) {
            case 0x40000000: {
                n2 = widthSize;
                break;
            }
            case -2147483648: {
                n2 = Math.min(defaultWidth, widthSize);
                break;
            }
            case 0: {
                n2 = defaultWidth;
                break;
            }
            default: {
                n2 = defaultWidth;
            }
        }
        int width = n2;
        switch (heightMode) {
            case 0x40000000: {
                n = heightSize;
                break;
            }
            case -2147483648: {
                n = width;
                break;
            }
            case 0: {
                n = width;
                break;
            }
            default: {
                n = width;
            }
        }
        int height = n;
        this.mSize = Math.min(width, height);
        this.mRadius = ((float)this.mSize - Math.max(Math.max(this.progressBackgroundWidth, this.progressWidth), this.dotWidth)) / 2.0f;
        this.setMeasuredDimension(this.mSize, this.mSize);
    }

    /*
     * WARNING - void declaration
     */
    private final void init(Context context, AttributeSet attrs) {
        void elements$iv;
        DashPathEffect dashPathEffect;
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        this.mDefaultSize = Math.round(48.0f * displayMetrics.density);
        Float[] floatArray = new Float[]{Float.valueOf(12.0f * displayMetrics.density), Float.valueOf(4.0f * displayMetrics.density)};
        DashPathEffect dashPathEffect2 = dashPathEffect;
        DashPathEffect dashPathEffect3 = dashPathEffect;
        void var8_7 = elements$iv;
        dashPathEffect2(ArraysKt.toFloatArray((Float[])var8_7), 1.0f);
        DashPathEffect dashPath = dashPathEffect3;
        this.mBackgroundStrokePaint.setPathEffect((PathEffect)dashPath);
        this.mForegroundStrokePaint.setAntiAlias(true);
        this.mBackgroundStrokePaint.setAntiAlias(true);
        this.dotPaint.setAntiAlias(true);
        this.mForegroundStrokePaint.setStyle(Paint.Style.STROKE);
        this.mBackgroundStrokePaint.setStyle(Paint.Style.STROKE);
        this.dotPaint.setStyle(Paint.Style.FILL);
        if (attrs == null) {
            this.setProgress(25);
            this.setMaxProgress(100);
            this.progressColor = -16776961;
            this.setProgressWidth(32.0f * displayMetrics.density);
            this.progressBackgroundColor = -3355444;
            this.setProgressBackgroundWidth(16.0f * displayMetrics.density);
            this.textColor = -16777216;
            this.textSize = 14.0f;
            this.setStartAngle(0);
            this.setDotWidth(20.0f * displayMetrics.density);
            this.dotColor = -16776961;
            this.showProgressBackground = true;
            this.enableBackgroundDashEffect = false;
            this.showDot = true;
            this.setCircularProgressBarAlpha(255);
            this.setProgressCap(0);
            this.setAnimationDuration(500);
            this.setInterpolator(0);
            this.setAnimationEffect(0);
        } else {
            TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.CircularProgressBar, 0, 0);
            this.setProgress(typedArray.getInt(R.styleable.CircularProgressBar_progress, 25));
            this.setMaxProgress(typedArray.getInt(R.styleable.CircularProgressBar_maxProgress, 100));
            this.progressColor = typedArray.getColor(R.styleable.CircularProgressBar_progressColor, -16776961);
            this.setProgressWidth(typedArray.getDimension(R.styleable.CircularProgressBar_progressWidth, 32.0f * displayMetrics.density));
            this.setProgressBackgroundWidth(typedArray.getDimension(R.styleable.CircularProgressBar_progressBackgroundWidth, 16.0f * displayMetrics.density));
            this.progressBackgroundColor = typedArray.getInt(R.styleable.CircularProgressBar_progressBackgroundColor, -3355444);
            this.setStartAngle(typedArray.getInteger(R.styleable.CircularProgressBar_startAngle, 0));
            this.setAnimationEffect(typedArray.getInt(R.styleable.CircularProgressBar_animationEffect, 0));
            this.showProgressBackground = typedArray.getBoolean(R.styleable.CircularProgressBar_showProgressBackground, true);
            this.enableBackgroundDashEffect = typedArray.getBoolean(R.styleable.CircularProgressBar_enableBackgroundDashEffect, false);
            this.showDot = typedArray.getBoolean(R.styleable.CircularProgressBar_showDot, true);
            this.setDotWidth(typedArray.getDimension(R.styleable.CircularProgressBar_dotWidth, 20.0f * displayMetrics.density));
            this.dotColor = typedArray.getColor(R.styleable.CircularProgressBar_progressColor, -16776961);
            this.setAnimationDuration(typedArray.getInteger(R.styleable.CircularProgressBar_animationDuration, 500));
            this.setProgressCap(typedArray.getInt(R.styleable.CircularProgressBar_progressCap, 0));
            this.setInterpolator(typedArray.getInt(R.styleable.CircularProgressBar_interpolator, 0));
            this.setCircularProgressBarAlpha(typedArray.getInt(R.styleable.CircularProgressBar_cir_alpha, 255));
            typedArray.recycle();
        }
        this.setDashLineLength(12.0f * displayMetrics.density);
        this.setDashLineOffset(4.0f * displayMetrics.density);
        this.setFadeRepeatCount(3);
        this.setMinFadeAlpha(85);
        this.mBackgroundStrokePaint.setColor(this.progressBackgroundColor);
        this.mForegroundStrokePaint.setColor(this.progressColor);
        this.dotPaint.setColor(this.dotColor);
        this.mBackgroundStrokePaint.setStrokeWidth(this.progressBackgroundWidth);
        this.mForegroundStrokePaint.setStrokeWidth(this.progressWidth);
        this.dotPaint.setStrokeWidth(this.dotWidth);
    }

    private final void setAnimators() {
        this.mProgressAnimator.setFloatValues(new float[]{0.0f, this.progress});
        this.mProgressAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(this){
            final /* synthetic */ CircularProgressBar this$0;

            public final void onAnimationUpdate(ValueAnimator animation) {
                String string = animation.getAnimatedValue().toString();
                CircularProgressBar circularProgressBar = this.this$0;
                float f = Float.parseFloat(string);
                CircularProgressBar.access$setCurrentAnimatedProgress$p(circularProgressBar, f);
                this.this$0.invalidate();
            }
            {
                this.this$0 = circularProgressBar;
            }
        });
        this.mAlphaAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(this){
            final /* synthetic */ CircularProgressBar this$0;

            public final void onAnimationUpdate(ValueAnimator animation) {
                String string = animation.getAnimatedValue().toString();
                CircularProgressBar circularProgressBar = this.this$0;
                float f = Float.parseFloat(string);
                circularProgressBar.setCircularProgressBarAlpha((int)(Math.abs(f * (float)2 / (float)this.this$0.getAnimationDuration() - 1.0f) * (float)(255 - this.this$0.getMinFadeAlpha()) + (float)this.this$0.getMinFadeAlpha()));
                this.this$0.invalidate();
            }
            {
                this.this$0 = circularProgressBar;
            }
        });
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
    }

    public final void refresh() {
        this.setCircularProgressBarAlpha(255);
        this.currentAnimatedProgress = this.progress;
        if (this.mProgressAnimator.isRunning()) {
            this.mProgressAnimator.cancel();
        }
        if (this.mAlphaAnimator.isRunning()) {
            this.mAlphaAnimator.cancel();
        }
        this.invalidate();
    }

    public final void stopAnimation() {
        this.refresh();
    }

    public final void animateView() {
        this.setCircularProgressBarAlpha(255);
        if (this.mProgressAnimator.isRunning()) {
            this.mProgressAnimator.cancel();
            this.setCircularProgressBarAlpha(this.progress);
        }
        if (this.mAlphaAnimator.isRunning()) {
            this.mAlphaAnimator.cancel();
        }
        switch (this.animationEffect) {
            case 1: {
                TimeInterpolator timeInterpolator;
                this.mProgressAnimator.setFloatValues(new float[]{0.0f, this.progress});
                this.mProgressAnimator.setDuration((long)this.animationDuration);
                switch (this.interpolator) {
                    case 1: {
                        timeInterpolator = (TimeInterpolator)new AccelerateInterpolator();
                        break;
                    }
                    case 2: {
                        timeInterpolator = (TimeInterpolator)new DecelerateInterpolator();
                        break;
                    }
                    default: {
                        timeInterpolator = (TimeInterpolator)new LinearInterpolator();
                    }
                }
                this.mProgressAnimator.setInterpolator(timeInterpolator);
                this.mProgressAnimator.start();
                break;
            }
            case 2: {
                TimeInterpolator timeInterpolator;
                this.mAlphaAnimator.setDuration((long)this.animationDuration * (long)this.fadeRepeatCount);
                switch (this.interpolator) {
                    case 1: {
                        timeInterpolator = (TimeInterpolator)new AccelerateInterpolator();
                        break;
                    }
                    case 2: {
                        timeInterpolator = (TimeInterpolator)new DecelerateInterpolator();
                        break;
                    }
                    default: {
                        timeInterpolator = (TimeInterpolator)new LinearInterpolator();
                    }
                }
                this.mAlphaAnimator.setInterpolator(timeInterpolator);
                this.mAlphaAnimator.setFloatValues(new float[]{0.0f, this.animationDuration});
                this.mAlphaAnimator.setRepeatCount(this.fadeRepeatCount);
                this.mAlphaAnimator.start();
                break;
            }
            case 0: {
                this.invalidate();
            }
        }
    }

    public CircularProgressBar(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
        this.mProgressAnimator = new ValueAnimator();
        this.mAlphaAnimator = new ValueAnimator();
        this.progressColor = -16776961;
        this.progressBackgroundColor = -3355444;
        this.textColor = -16777216;
        this.dotColor = -16776961;
        this.dashLineLength = 8.0f;
        this.circularProgressBarAlpha = 255;
        this.minFadeAlpha = 85;
        this.mForegroundStrokePaint = new Paint(1);
        this.mBackgroundStrokePaint = new Paint(1);
        this.dotPaint = new Paint(1);
        this.init(context, null);
    }

    public CircularProgressBar(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        super(context, attrs);
        this.mProgressAnimator = new ValueAnimator();
        this.mAlphaAnimator = new ValueAnimator();
        this.progressColor = -16776961;
        this.progressBackgroundColor = -3355444;
        this.textColor = -16777216;
        this.dotColor = -16776961;
        this.dashLineLength = 8.0f;
        this.circularProgressBarAlpha = 255;
        this.minFadeAlpha = 85;
        this.mForegroundStrokePaint = new Paint(1);
        this.mBackgroundStrokePaint = new Paint(1);
        this.dotPaint = new Paint(1);
        this.init(context, attrs);
        this.setAnimators();
    }

    public static final /* synthetic */ float access$getCurrentAnimatedProgress$p(CircularProgressBar $this) {
        return $this.currentAnimatedProgress;
    }

    public static final /* synthetic */ void access$setCurrentAnimatedProgress$p(CircularProgressBar $this, float f) {
        $this.currentAnimatedProgress = f;
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0017\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/shunan/circularprogressbar/CircularProgressBar$Companion;", "", "()V", "ACCELERATE", "", "DECELERATE", "DEFAULT_ALPHA", "DEFAULT_ANIMATION_DURATION", "DEFAULT_ANIMATION_EFFECT", "DEFAULT_DASH_LINE_LENGTH", "", "DEFAULT_DASH_LINE_OFFSET", "DEFAULT_DOT_WIDTH", "DEFAULT_ENABLE_BACKGROUND_DASH_EFFECT", "", "DEFAULT_FADE_REPEAT_COUNT", "DEFAULT_INTERPOLATOR", "DEFAULT_MAX_PROGRESS", "DEFAULT_MIN_FADE_ALPHA", "DEFAULT_PROGRESS", "DEFAULT_PROGRESS_BACKGROUND_COLOR", "DEFAULT_PROGRESS_BACKGROUND_WIDTH", "DEFAULT_PROGRESS_CAP", "DEFAULT_PROGRESS_COLOR", "DEFAULT_PROGRESS_WIDTH", "DEFAULT_SHOW_DOT", "DEFAULT_SHOW_PROGRESS_BACKGROUND", "DEFAULT_SIZE_DP", "DEFAULT_START_ANGLE", "DEFAULT_TEXT_COLOR", "DEFAULT_TEXT_SIZE", "FADE", "FLAT", "LINEAR", "NONE", "ROUND", "SWEEP", "circularprogressbar_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

