/*
 * Decompiled with CFR 0.152.
 */
package com.shreyaspatil.material.navigationview;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.core.graphics.drawable.DrawableCompat;
import com.google.android.material.navigation.NavigationView;
import com.shreyaspatil.MaterialNavigationView.R;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB!\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\n\u001a\u00020\u0007J\n\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u0007R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/shreyaspatil/material/navigationview/MaterialNavigationView;", "Lcom/google/android/material/navigation/NavigationView;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "itemStyle", "getItemStyle", "navigationItemBackground", "Landroid/graphics/drawable/Drawable;", "setItemStyle", "", "Companion", "MaterialNavigationView_release"})
public final class MaterialNavigationView
extends NavigationView {
    private int itemStyle;
    public static final int ITEM_STYLE_DEFAULT = 1;
    public static final int ITEM_STYLE_ROUND_RIGHT = 2;
    public static final int ITEM_STYLE_ROUND_RECTANGLE = 3;
    public static final Companion Companion = new Companion(null);
    private HashMap _$_findViewCache;

    public final int getItemStyle() {
        return this.itemStyle;
    }

    public final void setItemStyle(int itemStyle) {
        if (itemStyle == 2 || itemStyle == 3 || itemStyle == 1) {
            this.itemStyle = itemStyle;
            this.setItemBackground(this.navigationItemBackground());
        } else {
            Log.e((String)((Object)((Object)this)).getClass().getName(), (String)this.getContext().getString(R.string.illegal_arg_message));
        }
    }

    private final Drawable navigationItemBackground() {
        int n;
        switch (this.itemStyle) {
            case 1: {
                n = R.drawable.navigation_item_background_default;
                break;
            }
            case 2: {
                n = R.drawable.navigation_item_background_rounded_right;
                break;
            }
            default: {
                n = R.drawable.navigation_item_background_rounded_rect;
            }
        }
        int resource = n;
        Drawable background = AppCompatResources.getDrawable((Context)this.getContext(), (int)resource);
        if (background != null) {
            ColorStateList tint = AppCompatResources.getColorStateList((Context)this.getContext(), (int)R.color.navigation_item_background_tint);
            background = DrawableCompat.wrap((Drawable)background.mutate());
            if (Build.VERSION.SDK_INT >= 21) {
                background.setTintList(tint);
            } else {
                DrawableCompat.setTintList((Drawable)background, (ColorStateList)tint);
            }
        }
        return background;
    }

    @JvmOverloads
    public MaterialNavigationView(@NotNull Context context, @NotNull AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        super(context, attrs, defStyleAttr);
        this.itemStyle = 1;
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.MaterialNavigationView, 0, 0);
        this.itemStyle = a.getInteger(R.styleable.MaterialNavigationView_itemStyle, 1);
        a.recycle();
        this.setItemBackground(this.navigationItemBackground());
    }

    public /* synthetic */ MaterialNavigationView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = R.style.Widget_NavigationView;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public MaterialNavigationView(@NotNull Context context, @NotNull AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/shreyaspatil/material/navigationview/MaterialNavigationView$Companion;", "", "()V", "ITEM_STYLE_DEFAULT", "", "ITEM_STYLE_ROUND_RECTANGLE", "ITEM_STYLE_ROUND_RIGHT", "MaterialNavigationView_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

