/*
 * Decompiled with CFR 0.152.
 */
package com.shreyaspatil.easyupipayment;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.util.Log;
import androidx.annotation.VisibleForTesting;
import androidx.appcompat.app.AppCompatActivity;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.OnLifecycleEvent;
import com.shreyaspatil.easyupipayment.Singleton;
import com.shreyaspatil.easyupipayment.exception.AppNotFoundException;
import com.shreyaspatil.easyupipayment.listener.PaymentStatusListener;
import com.shreyaspatil.easyupipayment.model.Payment;
import com.shreyaspatil.easyupipayment.model.PaymentApp;
import com.shreyaspatil.easyupipayment.ui.PaymentUiActivity;
import java.io.Serializable;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00192\u00020\u0001:\u0002\u0018\u0019B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0006\u0010\u0013\u001a\u00020\u0010J\u000e\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u0010R$\u0010\u0007\u001a\u00020\b8@@\u0000X\u0081.\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/shreyaspatil/easyupipayment/EasyUpiPayment;", "", "mActivity", "Landroid/app/Activity;", "mPayment", "Lcom/shreyaspatil/easyupipayment/model/Payment;", "(Landroid/app/Activity;Lcom/shreyaspatil/easyupipayment/model/Payment;)V", "activityLifecycleObserver", "Landroidx/lifecycle/LifecycleObserver;", "getActivityLifecycleObserver$EasyUpiPayment_release$annotations", "()V", "getActivityLifecycleObserver$EasyUpiPayment_release", "()Landroidx/lifecycle/LifecycleObserver;", "setActivityLifecycleObserver$EasyUpiPayment_release", "(Landroidx/lifecycle/LifecycleObserver;)V", "registerLifecycleObserver", "", "mLifecycleOwner", "Landroidx/lifecycle/LifecycleOwner;", "removePaymentStatusListener", "setPaymentStatusListener", "mListener", "Lcom/shreyaspatil/easyupipayment/listener/PaymentStatusListener;", "startPayment", "Builder", "Companion", "EasyUpiPayment_release"})
public final class EasyUpiPayment {
    @NotNull
    public LifecycleObserver activityLifecycleObserver;
    private final Activity mActivity;
    private final Payment mPayment;
    @NotNull
    public static final String TAG = "EasyUpiPayment";
    public static final Companion Companion = new Companion(null);

    @VisibleForTesting
    public static /* synthetic */ void getActivityLifecycleObserver$EasyUpiPayment_release$annotations() {
    }

    @NotNull
    public final /* synthetic */ LifecycleObserver getActivityLifecycleObserver$EasyUpiPayment_release() {
        LifecycleObserver lifecycleObserver = this.activityLifecycleObserver;
        if (lifecycleObserver == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"activityLifecycleObserver");
        }
        return lifecycleObserver;
    }

    public final void setActivityLifecycleObserver$EasyUpiPayment_release(@NotNull LifecycleObserver lifecycleObserver) {
        Intrinsics.checkNotNullParameter((Object)lifecycleObserver, (String)"<set-?>");
        this.activityLifecycleObserver = lifecycleObserver;
    }

    public final void startPayment() {
        Intent intent = new Intent((Context)this.mActivity, PaymentUiActivity.class);
        boolean bl = false;
        boolean bl2 = false;
        Intent $this$apply = intent;
        boolean bl3 = false;
        $this$apply.putExtra("payment", (Serializable)this.mPayment);
        Intent payIntent = intent;
        this.mActivity.startActivity(payIntent);
    }

    public final void setPaymentStatusListener(@NotNull PaymentStatusListener mListener) {
        Intrinsics.checkNotNullParameter((Object)mListener, (String)"mListener");
        Singleton.INSTANCE.setListener$EasyUpiPayment_release(mListener);
    }

    public final void removePaymentStatusListener() {
        Singleton.INSTANCE.setListener$EasyUpiPayment_release(null);
    }

    private final void registerLifecycleObserver(LifecycleOwner mLifecycleOwner) {
        Lifecycle lifecycle = mLifecycleOwner.getLifecycle();
        LifecycleObserver lifecycleObserver = this.activityLifecycleObserver;
        if (lifecycleObserver == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"activityLifecycleObserver");
        }
        lifecycle.addObserver(lifecycleObserver);
    }

    public EasyUpiPayment(@NotNull Activity mActivity, @NotNull Payment mPayment) {
        Intrinsics.checkNotNullParameter((Object)mActivity, (String)"mActivity");
        Intrinsics.checkNotNullParameter((Object)mPayment, (String)"mPayment");
        this.mActivity = mActivity;
        this.mPayment = mPayment;
        if (this.mActivity instanceof AppCompatActivity) {
            this.activityLifecycleObserver = new LifecycleObserver(){

                @OnLifecycleEvent(value=Lifecycle.Event.ON_DESTROY)
                public final void onDestroyed() {
                    Log.d((String)EasyUpiPayment.TAG, (String)"onDestroyed");
                    Singleton.INSTANCE.setListener$EasyUpiPayment_release(null);
                }
            };
            this.registerLifecycleObserver((LifecycleOwner)this.mActivity);
        } else {
            Log.w((String)TAG, (String)"Current Activity isn't AppCompatActivity.\nYou'll need to call EasyUpiPayment#detachListener() to remove listener.");
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010$\u001a\u00020%J\u0015\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0006H\u0001\u00a2\u0006\u0002\b)J\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0006J\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u0006J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010*\u001a\u00020\u0006J\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u0006J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\u0006J\u000e\u0010 \u001a\u00020\u00002\u0006\u0010-\u001a\u00020\u0006J\u000e\u0010#\u001a\u00020\u00002\u0006\u0010.\u001a\u00020\u0006J\b\u0010/\u001a\u000200H\u0002J\u0012\u00101\u001a\u00020\u00002\b\b\u0002\u0010\u0019\u001a\u00020\u0018H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0007\u001a\u0004\u0018\u00010\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR(\u0010\f\u001a\u0004\u0018\u00010\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\t\"\u0004\b\u000e\u0010\u000bR(\u0010\u000f\u001a\u0004\u0018\u00010\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\t\"\u0004\b\u0011\u0010\u000bR(\u0010\u0012\u001a\u0004\u0018\u00010\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\t\"\u0004\b\u0014\u0010\u000bR(\u0010\u0015\u001a\u0004\u0018\u00010\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\t\"\u0004\b\u0017\u0010\u000bR$\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0005\u001a\u00020\u0018@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR(\u0010\u001e\u001a\u0004\u0018\u00010\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\t\"\u0004\b \u0010\u000bR(\u0010!\u001a\u0004\u0018\u00010\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\t\"\u0004\b#\u0010\u000b\u00a8\u00062"}, d2={"Lcom/shreyaspatil/easyupipayment/EasyUpiPayment$Builder;", "", "activity", "Landroid/app/Activity;", "(Landroid/app/Activity;)V", "<set-?>", "", "amount", "getAmount", "()Ljava/lang/String;", "setAmount", "(Ljava/lang/String;)V", "description", "getDescription", "setDescription", "payeeMerchantCode", "getPayeeMerchantCode", "setPayeeMerchantCode", "payeeName", "getPayeeName", "setPayeeName", "payeeVpa", "getPayeeVpa", "setPayeeVpa", "Lcom/shreyaspatil/easyupipayment/model/PaymentApp;", "paymentApp", "getPaymentApp", "()Lcom/shreyaspatil/easyupipayment/model/PaymentApp;", "setPaymentApp", "(Lcom/shreyaspatil/easyupipayment/model/PaymentApp;)V", "transactionId", "getTransactionId", "setTransactionId", "transactionRefId", "getTransactionRefId", "setTransactionRefId", "build", "Lcom/shreyaspatil/easyupipayment/EasyUpiPayment;", "isPackageInstalled", "", "packageName", "isPackageInstalled$EasyUpiPayment_release", "merchantCode", "name", "vpa", "id", "refId", "validate", "", "with", "EasyUpiPayment_release"})
    public static final class Builder {
        @NotNull
        private PaymentApp paymentApp;
        @Nullable
        private String payeeVpa;
        @Nullable
        private String payeeName;
        @Nullable
        private String payeeMerchantCode;
        @Nullable
        private String transactionId;
        @Nullable
        private String transactionRefId;
        @Nullable
        private String description;
        @Nullable
        private String amount;
        private final Activity activity;

        @NotNull
        public final PaymentApp getPaymentApp() {
            return this.paymentApp;
        }

        public final /* synthetic */ void setPaymentApp(@NotNull PaymentApp paymentApp) {
            Intrinsics.checkNotNullParameter((Object)((Object)paymentApp), (String)"<set-?>");
            this.paymentApp = paymentApp;
        }

        @Nullable
        public final String getPayeeVpa() {
            return this.payeeVpa;
        }

        public final /* synthetic */ void setPayeeVpa(@Nullable String string) {
            this.payeeVpa = string;
        }

        @Nullable
        public final String getPayeeName() {
            return this.payeeName;
        }

        public final /* synthetic */ void setPayeeName(@Nullable String string) {
            this.payeeName = string;
        }

        @Nullable
        public final String getPayeeMerchantCode() {
            return this.payeeMerchantCode;
        }

        public final /* synthetic */ void setPayeeMerchantCode(@Nullable String string) {
            this.payeeMerchantCode = string;
        }

        @Nullable
        public final String getTransactionId() {
            return this.transactionId;
        }

        public final /* synthetic */ void setTransactionId(@Nullable String string) {
            this.transactionId = string;
        }

        @Nullable
        public final String getTransactionRefId() {
            return this.transactionRefId;
        }

        public final /* synthetic */ void setTransactionRefId(@Nullable String string) {
            this.transactionRefId = string;
        }

        @Nullable
        public final String getDescription() {
            return this.description;
        }

        public final /* synthetic */ void setDescription(@Nullable String string) {
            this.description = string;
        }

        @Nullable
        public final String getAmount() {
            return this.amount;
        }

        public final /* synthetic */ void setAmount(@Nullable String string) {
            this.amount = string;
        }

        @JvmOverloads
        @NotNull
        public final Builder with(@NotNull PaymentApp paymentApp) {
            Intrinsics.checkNotNullParameter((Object)((Object)paymentApp), (String)"paymentApp");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.paymentApp = paymentApp;
            return builder;
        }

        public static /* synthetic */ Builder with$default(Builder builder, PaymentApp paymentApp, int n, Object object) {
            if ((n & 1) != 0) {
                paymentApp = PaymentApp.ALL;
            }
            return builder.with(paymentApp);
        }

        @JvmOverloads
        @NotNull
        public final Builder with() {
            return Builder.with$default(this, null, 1, null);
        }

        @NotNull
        public final Builder setPayeeVpa(@NotNull String vpa) {
            Intrinsics.checkNotNullParameter((Object)vpa, (String)"vpa");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.payeeVpa = vpa;
            return builder;
        }

        @NotNull
        public final Builder setPayeeName(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.payeeName = name;
            return builder;
        }

        @NotNull
        public final Builder setPayeeMerchantCode(@NotNull String merchantCode) {
            Intrinsics.checkNotNullParameter((Object)merchantCode, (String)"merchantCode");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.payeeMerchantCode = merchantCode;
            return builder;
        }

        @NotNull
        public final Builder setTransactionId(@NotNull String id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.transactionId = id;
            return builder;
        }

        @NotNull
        public final Builder setTransactionRefId(@NotNull String refId) {
            Intrinsics.checkNotNullParameter((Object)refId, (String)"refId");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.transactionRefId = refId;
            return builder;
        }

        @NotNull
        public final Builder setDescription(@NotNull String description) {
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.description = description;
            return builder;
        }

        @NotNull
        public final Builder setAmount(@NotNull String amount) {
            Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.amount = amount;
            return builder;
        }

        @NotNull
        public final EasyUpiPayment build() throws IllegalStateException, AppNotFoundException {
            this.validate();
            String string = this.payeeVpa;
            Intrinsics.checkNotNull((Object)string);
            String string2 = this.payeeName;
            Intrinsics.checkNotNull((Object)string2);
            String string3 = this.payeeMerchantCode;
            Intrinsics.checkNotNull((Object)string3);
            String string4 = this.transactionId;
            Intrinsics.checkNotNull((Object)string4);
            String string5 = this.transactionRefId;
            Intrinsics.checkNotNull((Object)string5);
            String string6 = this.description;
            Intrinsics.checkNotNull((Object)string6);
            String string7 = this.amount;
            Intrinsics.checkNotNull((Object)string7);
            Payment payment = new Payment("INR", string, string2, string3, string4, string5, string6, string7, this.paymentApp != PaymentApp.ALL ? this.paymentApp.getPackageName() : null);
            return new EasyUpiPayment(this.activity, payment);
        }

        private final void validate() {
            boolean bl29;
            boolean bl25;
            boolean bl32;
            boolean bl42;
            if (this.paymentApp != PaymentApp.ALL && !this.isPackageInstalled$EasyUpiPayment_release(this.paymentApp.getPackageName())) {
                throw (Throwable)new AppNotFoundException(this.paymentApp.getPackageName());
            }
            String string = this.payeeVpa;
            boolean bl5 = false;
            boolean bl6 = false;
            String $this$run = string;
            boolean bl7 = false;
            boolean bl8 = false;
            boolean bl9 = false;
            if ($this$run == null) {
                boolean bl102 = false;
                String string2 = "Must call setPayeeVpa() before build().";
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            CharSequence charSequence = $this$run;
            String string3 = "^[\\w-.]+@([\\w-])+";
            boolean bl102 = false;
            string3 = new Regex(string3);
            bl102 = false;
            boolean bl11 = string3.matches(charSequence);
            boolean bl12 = false;
            bl102 = false;
            if (!bl11) {
                boolean bl13 = false;
                String bl102 = "Payee VPA address should be valid (For e.g. example@vpa)";
                throw (Throwable)new IllegalStateException(bl102.toString());
            }
            String string4 = this.payeeMerchantCode;
            if (string4 != null) {
                string = string4;
                bl5 = false;
                bl6 = false;
                $this$run = string;
                boolean bl14 = false;
                bl11 = false;
                bl12 = false;
                if ($this$run == null) {
                    boolean bl15 = false;
                    String string5 = "Payee Merchant Code Should be Valid!";
                    throw (Throwable)new IllegalStateException(string5.toString());
                }
            }
            string = this.transactionId;
            bl5 = false;
            bl6 = false;
            $this$run = string;
            boolean bl16 = false;
            bl11 = false;
            bl12 = false;
            if ($this$run == null) {
                bl42 = false;
                String string6 = "Must call setTransactionId() before build";
                throw (Throwable)new IllegalStateException(string6.toString());
            }
            CharSequence charSequence2 = $this$run;
            bl12 = false;
            boolean bl17 = !StringsKt.isBlank((CharSequence)charSequence2);
            bl12 = false;
            bl42 = false;
            if (!bl17) {
                boolean bl18 = false;
                String bl42 = "Transaction ID Should be Valid!";
                throw (Throwable)new IllegalStateException(bl42.toString());
            }
            string = this.transactionRefId;
            bl5 = false;
            bl6 = false;
            $this$run = string;
            boolean bl19 = false;
            bl17 = false;
            bl12 = false;
            if ($this$run == null) {
                bl32 = false;
                String string7 = "Must call setTransactionRefId() before build";
                throw (Throwable)new IllegalStateException(string7.toString());
            }
            CharSequence charSequence3 = $this$run;
            bl12 = false;
            boolean bl20 = !StringsKt.isBlank((CharSequence)charSequence3);
            bl12 = false;
            bl32 = false;
            if (!bl20) {
                boolean bl21 = false;
                String bl32 = "RefId Should be Valid!";
                throw (Throwable)new IllegalStateException(bl32.toString());
            }
            string = this.payeeName;
            bl5 = false;
            bl6 = false;
            $this$run = string;
            boolean bl22 = false;
            bl20 = false;
            bl12 = false;
            if ($this$run == null) {
                bl25 = false;
                String string8 = "Must call setPayeeName() before build().";
                throw (Throwable)new IllegalStateException(string8.toString());
            }
            CharSequence charSequence4 = $this$run;
            bl12 = false;
            boolean bl23 = !StringsKt.isBlank((CharSequence)charSequence4);
            bl12 = false;
            bl25 = false;
            if (!bl23) {
                boolean bl24 = false;
                String bl25 = "Payee name Should be Valid!";
                throw (Throwable)new IllegalStateException(bl25.toString());
            }
            string = this.amount;
            bl5 = false;
            bl6 = false;
            $this$run = string;
            boolean bl25 = false;
            bl23 = false;
            bl12 = false;
            if ($this$run == null) {
                bl29 = false;
                String string9 = "Must call setAmount() before build().";
                throw (Throwable)new IllegalStateException(string9.toString());
            }
            CharSequence charSequence5 = $this$run;
            String string10 = "\\d+\\.\\d*";
            bl29 = false;
            string10 = new Regex(string10);
            bl29 = false;
            boolean bl26 = string10.matches(charSequence5);
            boolean bl27 = false;
            bl29 = false;
            if (!bl26) {
                boolean bl28 = false;
                String bl29 = "Amount should be valid positive number and in decimal format (For e.g. 100.00)";
                throw (Throwable)new IllegalStateException(bl29.toString());
            }
            string = this.description;
            bl5 = false;
            bl6 = false;
            $this$run = string;
            boolean bl30 = false;
            bl26 = false;
            bl27 = false;
            if ($this$run == null) {
                boolean bl31 = false;
                String string11 = "Must call setDescription() before build().";
                throw (Throwable)new IllegalStateException(string11.toString());
            }
            CharSequence charSequence6 = $this$run;
            bl27 = false;
            boolean bl32 = !StringsKt.isBlank((CharSequence)charSequence6);
            bl27 = false;
            boolean bl33 = false;
            if (!bl32) {
                boolean bl34 = false;
                String string12 = "Description Should be Valid!";
                throw (Throwable)new IllegalStateException(string12.toString());
            }
        }

        @VisibleForTesting
        public final /* synthetic */ boolean isPackageInstalled$EasyUpiPayment_release(@NotNull String packageName) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            Builder builder = this;
            boolean bl = false;
            try {
                object = Result.Companion;
                Builder $this$runCatching = builder;
                boolean bl2 = false;
                $this$runCatching.activity.getPackageManager().getPackageInfo(packageName, 0);
                Boolean bl3 = true;
                boolean bl4 = false;
                object = Result.constructor-impl((Object)bl3);
            }
            catch (Throwable throwable) {
                Result.Companion companion = Result.Companion;
                boolean bl5 = false;
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            builder = object;
            Boolean bl6 = false;
            boolean bl7 = false;
            return (Boolean)(Result.isFailure-impl((Object)builder) ? bl6 : builder);
        }

        public Builder(@NotNull Activity activity) {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            this.activity = activity;
            this.paymentApp = PaymentApp.ALL;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/shreyaspatil/easyupipayment/EasyUpiPayment$Companion;", "", "()V", "TAG", "", "EasyUpiPayment_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

