/*
 * Decompiled with CFR 0.152.
 */
package com.shreyaspatil.EasyUpiPayment.ui;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;
import com.shreyaspatil.EasyUpiPayment.R;
import com.shreyaspatil.EasyUpiPayment.Singleton;
import com.shreyaspatil.EasyUpiPayment.model.Payment;
import com.shreyaspatil.EasyUpiPayment.model.TransactionDetails;
import java.util.HashMap;
import java.util.Map;

public final class PaymentUiActivity
extends AppCompatActivity {
    private static final String TAG = PaymentUiActivity.class.getSimpleName();
    public static final int PAYMENT_REQUEST = 4400;
    public static final String EXTRA_KEY_PAYMENT = "payment";
    private Singleton singleton;
    private Payment payment;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_upipay);
        this.singleton = Singleton.getInstance();
        Intent intent = this.getIntent();
        this.payment = (Payment)intent.getSerializableExtra(EXTRA_KEY_PAYMENT);
        Uri.Builder payUri = new Uri.Builder();
        payUri.scheme("upi").authority("pay");
        payUri.appendQueryParameter("pa", this.payment.getVpa());
        payUri.appendQueryParameter("pn", this.payment.getName());
        payUri.appendQueryParameter("tid", this.payment.getTxnId());
        if (this.payment.getPayeeMerchantCode() != null) {
            payUri.appendQueryParameter("mc", this.payment.getPayeeMerchantCode());
        }
        payUri.appendQueryParameter("tr", this.payment.getTxnRefId());
        payUri.appendQueryParameter("tn", this.payment.getDescription());
        payUri.appendQueryParameter("am", this.payment.getAmount());
        payUri.appendQueryParameter("cu", this.payment.getCurrency());
        Uri uri = payUri.build();
        Intent paymentIntent = new Intent("android.intent.action.VIEW");
        paymentIntent.setData(uri);
        if (this.payment.getDefaultPackage() != null) {
            paymentIntent.setPackage(this.payment.getDefaultPackage());
        }
        Intent appChooser = Intent.createChooser((Intent)paymentIntent, (CharSequence)"Pay using");
        if (paymentIntent.resolveActivity(this.getPackageManager()) != null) {
            this.startActivityForResult(appChooser, 4400);
        } else {
            Toast.makeText((Context)this, (CharSequence)"No UPI app found! Please Install to Proceed!", (int)0).show();
            this.callbackOnAppNotFound();
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 4400) {
            block9: {
                if (data != null) {
                    String response = data.getStringExtra("response");
                    if (response == null) {
                        this.callbackTransactionCancelled();
                        Log.d((String)TAG, (String)"Payment Response is null");
                    } else {
                        try {
                            TransactionDetails transactionDetails = this.getTransactionDetails(response);
                            this.callbackTransactionComplete(transactionDetails);
                            String status = transactionDetails.getStatus().toLowerCase();
                            if (status.equals("success")) {
                                this.callbackTransactionSuccess();
                                break block9;
                            }
                            if (status.equals("submitted")) {
                                this.callbackTransactionSubmitted();
                                break block9;
                            }
                            this.callbackTransactionFailed();
                        }
                        catch (Exception e) {
                            this.callbackTransactionCancelled();
                            this.callbackTransactionFailed();
                        }
                    }
                } else {
                    Log.e((String)TAG, (String)"Intent Data is null. User cancelled");
                    this.callbackTransactionCancelled();
                }
            }
            this.finish();
        }
    }

    private Map<String, String> getQueryString(String url) {
        String[] params = url.split("&");
        HashMap<String, String> map = new HashMap<String, String>();
        for (String param : params) {
            String name = param.split("=")[0];
            String value = param.split("=")[1];
            map.put(name, value);
        }
        return map;
    }

    private TransactionDetails getTransactionDetails(String response) {
        Map<String, String> map = this.getQueryString(response);
        String transactionId = map.get("txnId");
        String responseCode = map.get("responseCode");
        String approvalRefNo = map.get("ApprovalRefNo");
        String status = map.get("Status");
        String transactionRefId = map.get("txnRef");
        return new TransactionDetails(transactionId, responseCode, approvalRefNo, status, transactionRefId, this.payment.getAmount());
    }

    private boolean isListenerRegistered() {
        return Singleton.getInstance().isListenerRegistered();
    }

    private void callbackOnAppNotFound() {
        Log.e((String)TAG, (String)"No UPI app found on device.");
        if (this.isListenerRegistered()) {
            this.singleton.getListener().onAppNotFound();
        }
        this.finish();
    }

    private void callbackTransactionSuccess() {
        if (this.isListenerRegistered()) {
            this.singleton.getListener().onTransactionSuccess();
        }
    }

    private void callbackTransactionSubmitted() {
        if (this.isListenerRegistered()) {
            this.singleton.getListener().onTransactionSubmitted();
        }
    }

    private void callbackTransactionFailed() {
        if (this.isListenerRegistered()) {
            this.singleton.getListener().onTransactionFailed();
        }
    }

    private void callbackTransactionCancelled() {
        if (this.isListenerRegistered()) {
            this.singleton.getListener().onTransactionCancelled();
        }
    }

    private void callbackTransactionComplete(TransactionDetails transactionDetails) {
        if (this.isListenerRegistered()) {
            this.singleton.getListener().onTransactionCompleted(transactionDetails);
        }
    }
}

