/*
 * Decompiled with CFR 0.152.
 */
package com.shreyaspatil.EasyUpiPayment;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.util.Log;
import androidx.annotation.NonNull;
import com.shreyaspatil.EasyUpiPayment.Singleton;
import com.shreyaspatil.EasyUpiPayment.listener.PaymentStatusListener;
import com.shreyaspatil.EasyUpiPayment.model.Payment;
import com.shreyaspatil.EasyUpiPayment.model.PaymentApp;
import com.shreyaspatil.EasyUpiPayment.ui.PaymentUiActivity;
import java.io.Serializable;

public final class EasyUpiPayment {
    public static final String APP_NOT_FOUND = "AppNotFound";
    private Activity mActivity;
    private Payment mPayment;

    private EasyUpiPayment(@NonNull Activity mActivity, @NonNull Payment mPayment) {
        this.mActivity = mActivity;
        this.mPayment = mPayment;
    }

    public void startPayment() {
        boolean isInstalled;
        if (this.mPayment.getDefaultPackage() != null && !(isInstalled = this.isPackageInstalled(this.mPayment.getDefaultPackage(), this.mActivity.getPackageManager()))) {
            Log.e((String)APP_NOT_FOUND, (String)("UPI App with package '" + this.mPayment.getDefaultPackage() + "' is not installed on this device."));
            if (Singleton.getInstance().isListenerRegistered()) {
                Singleton.getInstance().getListener().onAppNotFound();
            }
            return;
        }
        Intent payIntent = new Intent((Context)this.mActivity, PaymentUiActivity.class);
        payIntent.putExtra("payment", (Serializable)this.mPayment);
        this.mActivity.startActivity(payIntent);
    }

    public void setPaymentStatusListener(@NonNull PaymentStatusListener mListener) {
        Singleton singleton = Singleton.getInstance();
        singleton.setListener(mListener);
    }

    public void setDefaultPaymentApp(@NonNull PaymentApp mPaymentApp) {
        boolean isInstalled = this.isPackageInstalled(mPaymentApp.getPackageName(), this.mActivity.getPackageManager());
        if (mPaymentApp == PaymentApp.NONE) {
            this.mPayment.setDefaultPackage(null);
            return;
        }
        if (!isInstalled) {
            Log.e((String)APP_NOT_FOUND, (String)("UPI App with package '" + this.mPayment.getDefaultPackage() + "' is not installed on this device."));
            if (Singleton.getInstance().isListenerRegistered()) {
                Singleton.getInstance().getListener().onAppNotFound();
            }
            this.mPayment.setDefaultPackage(PaymentApp.NONE.getPackageName());
            return;
        }
        this.mPayment.setDefaultPackage(mPaymentApp.getPackageName());
    }

    public void detachListener() {
        Singleton.getInstance().detachListener();
    }

    private boolean isPackageInstalled(String packageName, PackageManager packageManager) {
        try {
            packageManager.getPackageInfo(packageName, 0);
            return true;
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }

    public boolean isDefaultAppExist() {
        if (this.mPayment.getDefaultPackage() != null) {
            return !this.isPackageInstalled(this.mPayment.getDefaultPackage(), this.mActivity.getPackageManager());
        }
        Log.w((String)"Unpecified", (String)"Default app is not speified. Specify it using 'setDefaultApp()' method of Builder class");
        return false;
    }

    public static final class Builder {
        private Activity activity;
        private Payment payment;

        @NonNull
        public Builder with(@NonNull Activity activity) {
            this.activity = activity;
            this.payment = new Payment();
            return this;
        }

        @NonNull
        public Builder setPayeeVpa(@NonNull String vpa) {
            if (!vpa.contains("@")) {
                throw new IllegalStateException("Payee VPA address should be valid (For e.g. example@vpa)");
            }
            this.payment.setVpa(vpa);
            return this;
        }

        @NonNull
        public Builder setPayeeName(@NonNull String name) {
            if (name.trim().length() == 0) {
                throw new IllegalStateException("Payee Name Should be Valid!");
            }
            this.payment.setName(name);
            return this;
        }

        @NonNull
        public Builder setPayeeMerchantCode(@NonNull String merchantCode) {
            if (merchantCode.trim().length() == 0) {
                throw new IllegalStateException("Merchant Code Should be Valid!");
            }
            this.payment.setPayeeMerchantCode(merchantCode);
            return this;
        }

        @NonNull
        public Builder setTransactionId(@NonNull String id) {
            if (id.trim().length() == 0) {
                throw new IllegalStateException("Transaction ID Should be Valid!");
            }
            this.payment.setTxnId(id);
            return this;
        }

        @NonNull
        public Builder setTransactionRefId(@NonNull String refId) {
            if (refId.trim().length() == 0) {
                throw new IllegalStateException("RefId Should be Valid!");
            }
            this.payment.setTxnRefId(refId);
            return this;
        }

        @NonNull
        public Builder setDescription(@NonNull String description) {
            if (description.trim().length() == 0) {
                throw new IllegalStateException("Description Should be Valid!");
            }
            this.payment.setDescription(description);
            return this;
        }

        @NonNull
        public Builder setAmount(@NonNull String amount) {
            if (!amount.contains(".")) {
                throw new IllegalStateException("Amount should be in decimal format XX.XX (For e.g. 100.00)");
            }
            this.payment.setAmount(amount);
            return this;
        }

        @NonNull
        public EasyUpiPayment build() {
            if (this.activity == null) {
                throw new IllegalStateException("Activity must be specified using with() call begore build()");
            }
            if (this.payment == null) {
                throw new IllegalStateException("Payment Details must be initialized before build()");
            }
            if (this.payment.getVpa() == null) {
                throw new IllegalStateException("Must call setPayeeVpa() before build().");
            }
            if (this.payment.getTxnId() == null) {
                throw new IllegalStateException("Must call setTransactionId() before build");
            }
            if (this.payment.getTxnRefId() == null) {
                throw new IllegalStateException("Must call setTransactionRefId() before build");
            }
            if (this.payment.getName() == null) {
                throw new IllegalStateException("Must call setPayeeName() before build().");
            }
            if (this.payment.getAmount() == null) {
                throw new IllegalStateException("Must call setAmount() before build().");
            }
            if (this.payment.getDescription() == null) {
                throw new IllegalStateException("Must call setDescription() before build().");
            }
            return new EasyUpiPayment(this.activity, this.payment);
        }
    }
}

