/*
 * Decompiled with CFR 0.152.
 */
package com.shreyaspatil.EasyUpiPayment.ui;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;
import com.shreyaspatil.EasyUpiPayment.R;
import com.shreyaspatil.EasyUpiPayment.Singleton;
import com.shreyaspatil.EasyUpiPayment.model.Payment;
import com.shreyaspatil.EasyUpiPayment.model.TransactionDetails;
import com.shreyaspatil.EasyUpiPayment.ui.AppsBottomSheet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class PaymentUiActivity
extends AppCompatActivity {
    private static final String TAG = "PaymentUiActivity";
    public static final int PAYMENT_REQUEST = 4400;
    private Singleton singleton;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_upipay);
        this.singleton = Singleton.getInstance();
        Intent intent = this.getIntent();
        Payment payment = (Payment)intent.getSerializableExtra("payment");
        Uri.Builder payUri = new Uri.Builder();
        payUri.scheme("upi").authority("pay");
        payUri.appendQueryParameter("pa", payment.getVpa());
        payUri.appendQueryParameter("pn", payment.getName());
        payUri.appendQueryParameter("tid", payment.getTxnId());
        if (payment.getPayeeMerchantCode() != null) {
            payUri.appendQueryParameter("mc", payment.getPayeeMerchantCode());
        }
        payUri.appendQueryParameter("tr", payment.getTxnRefId());
        payUri.appendQueryParameter("tn", payment.getDescription());
        payUri.appendQueryParameter("am", payment.getAmount());
        payUri.appendQueryParameter("cu", payment.getCurrency());
        Uri uri = payUri.build();
        Intent paymentIntent = new Intent("android.intent.action.VIEW");
        paymentIntent.setData(uri);
        if (payment.getDefaultPackage() != null) {
            paymentIntent.setPackage(payment.getDefaultPackage());
        }
        if (paymentIntent.resolveActivity(this.getPackageManager()) != null) {
            List intentList = this.getPackageManager().queryIntentActivities(paymentIntent, 0);
            this.showApps(intentList, paymentIntent);
        } else {
            Toast.makeText((Context)this, (CharSequence)"No UPI app found! Please Install to Proceed!", (int)0).show();
            this.callbackOnAppNotFound();
        }
    }

    private void showApps(List<ResolveInfo> appsList, Intent intent) {
        View.OnClickListener onCancelListener = new View.OnClickListener(){

            public void onClick(View v) {
                PaymentUiActivity.this.callbackTransactionCancelled();
                PaymentUiActivity.this.finish();
            }
        };
        AppsBottomSheet appsBottomSheet = new AppsBottomSheet(appsList, intent, onCancelListener);
        appsBottomSheet.show(this.getSupportFragmentManager(), "Pay Using");
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 4400) {
            block9: {
                if (data != null) {
                    String response = data.getStringExtra("response");
                    if (response == null) {
                        this.callbackTransactionCancelled();
                        Log.d((String)TAG, (String)"Response is null");
                    } else {
                        TransactionDetails transactionDetails = this.getTransactionDetails(response);
                        this.callbackTransactionComplete(transactionDetails);
                        try {
                            if (transactionDetails.getStatus().toLowerCase().equals("success")) {
                                this.callbackTransactionSuccess();
                                break block9;
                            }
                            if (transactionDetails.getStatus().toLowerCase().equals("submitted")) {
                                this.callbackTransactionSubmitted();
                                break block9;
                            }
                            this.callbackTransactionFailed();
                        }
                        catch (Exception e) {
                            this.callbackTransactionCancelled();
                            this.callbackTransactionFailed();
                        }
                    }
                } else {
                    Log.e((String)TAG, (String)"Intent Data is null. User cancelled");
                    this.callbackTransactionCancelled();
                }
            }
            this.finish();
        }
    }

    private Map<String, String> getQueryString(String url) {
        String[] params = url.split("&");
        HashMap<String, String> map = new HashMap<String, String>();
        for (String param : params) {
            String name = param.split("=")[0];
            String value = param.split("=")[1];
            map.put(name, value);
        }
        return map;
    }

    private TransactionDetails getTransactionDetails(String response) {
        Map<String, String> map = this.getQueryString(response);
        String transactionId = map.get("txnId");
        String responseCode = map.get("responseCode");
        String approvalRefNo = map.get("ApprovalRefNo");
        String status = map.get("Status");
        String transactionRefId = map.get("txnRef");
        return new TransactionDetails(transactionId, responseCode, approvalRefNo, status, transactionRefId);
    }

    private boolean isListenerRegistered() {
        return Singleton.getInstance().isListenerRegistered();
    }

    private void callbackOnAppNotFound() {
        Log.e((String)"AppNotFound", (String)"No UPI app found on device.");
        if (this.isListenerRegistered()) {
            this.singleton.getListener().onAppNotFound();
        }
        this.finish();
    }

    private void callbackTransactionSuccess() {
        if (this.isListenerRegistered()) {
            this.singleton.getListener().onTransactionSuccess();
        }
    }

    private void callbackTransactionSubmitted() {
        if (this.isListenerRegistered()) {
            this.singleton.getListener().onTransactionSubmitted();
        }
    }

    private void callbackTransactionFailed() {
        if (this.isListenerRegistered()) {
            this.singleton.getListener().onTransactionFailed();
        }
    }

    private void callbackTransactionCancelled() {
        if (this.isListenerRegistered()) {
            this.singleton.getListener().onTransactionCancelled();
        }
    }

    private void callbackTransactionComplete(TransactionDetails transactionDetails) {
        if (this.isListenerRegistered()) {
            this.singleton.getListener().onTransactionCompleted(transactionDetails);
        }
    }
}

