/*
 * Decompiled with CFR 0.152.
 */
package com.shreyaspatil.EasyUpiPayment.ui;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;
import com.shreyaspatil.EasyUpiPayment.R;
import com.shreyaspatil.EasyUpiPayment.Singleton;
import com.shreyaspatil.EasyUpiPayment.model.Payment;
import com.shreyaspatil.EasyUpiPayment.model.TransactionDetails;
import java.util.HashMap;
import java.util.Map;

public final class PaymentUiActivity
extends AppCompatActivity {
    private static final String TAG = "PaymentUiActivity";
    private static final int PAYMENT_REQUEST = 4400;
    private Singleton singleton;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_upipay);
        this.singleton = Singleton.getInstance();
        Intent intent = this.getIntent();
        Payment payment = (Payment)intent.getSerializableExtra("payment");
        Uri.Builder payUri = new Uri.Builder();
        payUri.scheme("upi").authority("pay");
        payUri.appendQueryParameter("pa", payment.getVpa());
        payUri.appendQueryParameter("pn", payment.getName());
        if (payment.getPayeeMerchantCode() != null) {
            payUri.appendQueryParameter("mc", payment.getPayeeMerchantCode());
        }
        if (payment.getTxnId() != null) {
            payUri.appendQueryParameter("tid", payment.getTxnId());
        }
        if (payment.getTxnRefId() != null) {
            payUri.appendQueryParameter("tr", payment.getTxnRefId());
        }
        payUri.appendQueryParameter("tn", payment.getDescription());
        payUri.appendQueryParameter("am", payment.getAmount());
        payUri.appendQueryParameter("cu", "INR");
        Uri uri = payUri.build();
        Intent paymentIntent = new Intent("android.intent.action.VIEW");
        paymentIntent.setData(uri);
        Intent appChooser = Intent.createChooser((Intent)paymentIntent, (CharSequence)"Pay");
        if (appChooser.resolveActivity(this.getPackageManager()) != null) {
            this.startActivityForResult(appChooser, 4400);
        } else {
            Toast.makeText((Context)this, (CharSequence)"No UPI app found! Please Install to Proceed!", (int)0).show();
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 4400) {
            if (resultCode == -1 || resultCode == 11) {
                if (data != null) {
                    String response = data.getStringExtra("response");
                    TransactionDetails transactionDetails = this.getTransactionDetails(response);
                    this.singleton.getListener().onTransactionCompleted(transactionDetails);
                    if (transactionDetails.getStatus().toLowerCase().equals("success")) {
                        this.singleton.getListener().onTransactionSuccess();
                    } else {
                        this.singleton.getListener().onTransactionFailed();
                    }
                } else {
                    Log.e((String)TAG, (String)"Data is null");
                    this.singleton.getListener().onTransactionFailed();
                }
            } else {
                Log.e((String)TAG, (String)"Transaction Cancelled by User");
                this.singleton.getListener().onTransactionCancelled();
            }
            this.finish();
        }
    }

    private Map<String, String> getQueryString(String url) {
        String[] params = url.split("&");
        HashMap<String, String> map = new HashMap<String, String>();
        for (String param : params) {
            String name = param.split("=")[0];
            String value = param.split("=")[1];
            map.put(name, value);
        }
        return map;
    }

    private TransactionDetails getTransactionDetails(String response) {
        TransactionDetails transactionDetails = new TransactionDetails();
        Map<String, String> map = this.getQueryString(response);
        transactionDetails.setTransactionId(map.get("txnId"));
        transactionDetails.setResponseCode(map.get("responseCode"));
        transactionDetails.setApprovalRefNo(map.get("ApprovalRefNo"));
        transactionDetails.setStatus(map.get("Status"));
        transactionDetails.setTransactionRefId(map.get("txnRef"));
        return transactionDetails;
    }
}

