/*
 * Decompiled with CFR 0.152.
 */
package com.shreyaspatil.EasyUpiPayment;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import androidx.annotation.NonNull;
import com.shreyaspatil.EasyUpiPayment.Singleton;
import com.shreyaspatil.EasyUpiPayment.listener.PaymentStatusListener;
import com.shreyaspatil.EasyUpiPayment.model.Payment;
import com.shreyaspatil.EasyUpiPayment.ui.PaymentUiActivity;
import java.io.Serializable;

public final class EasyUpiPayment {
    private Activity mActivity;
    private Payment mPayment;

    private EasyUpiPayment(@NonNull Activity mActivity, @NonNull Payment mPayment) {
        this.mActivity = mActivity;
        this.mPayment = mPayment;
    }

    public void startPayment() {
        Intent payIntent = new Intent((Context)this.mActivity, PaymentUiActivity.class);
        payIntent.putExtra("payment", (Serializable)this.mPayment);
        this.mActivity.startActivity(payIntent);
    }

    public void setPaymentStatusListener(@NonNull PaymentStatusListener mListener) {
        Singleton singleton = Singleton.getInstance();
        singleton.setListener(mListener);
    }

    public static final class Builder {
        private Activity activity;
        private Payment payment;

        @NonNull
        public Builder with(@NonNull Activity activity) {
            this.activity = activity;
            this.payment = new Payment();
            return this;
        }

        @NonNull
        public Builder setPayeeVpa(@NonNull String vpa) {
            this.payment.setVpa(vpa);
            return this;
        }

        @NonNull
        public Builder setPayeeName(@NonNull String name) {
            this.payment.setName(name);
            return this;
        }

        @NonNull
        public Builder setPayeeMerchantCode(@NonNull String merchantCode) {
            this.payment.setPayeeMerchantCode(merchantCode);
            return this;
        }

        @NonNull
        public Builder setTransactionId(@NonNull String id) {
            this.payment.setTxnRefId(id);
            return this;
        }

        @NonNull
        public Builder setTransactionRefId(@NonNull String refId) {
            this.payment.setTxnRefId(refId);
            return this;
        }

        @NonNull
        public Builder setDescription(@NonNull String description) {
            this.payment.setDescription(description);
            return this;
        }

        @NonNull
        public Builder setAmount(@NonNull String amount) {
            if (!amount.contains(".")) {
                throw new IllegalStateException("Amount should be in decimal format XX.XX");
            }
            this.payment.setAmount(amount);
            return this;
        }

        @NonNull
        public EasyUpiPayment build() {
            if (this.activity == null) {
                throw new IllegalStateException("Activity must be specified using with() call.");
            }
            if (this.payment == null) {
                throw new IllegalStateException("Payment Details must be initialized!");
            }
            if (this.payment.getVpa() == null) {
                throw new IllegalStateException("Must call setPayeeVpa() before build().");
            }
            if (this.payment.getName() == null) {
                throw new IllegalStateException("Must call setPayeeName() before build().");
            }
            if (this.payment.getAmount() == null) {
                throw new IllegalStateException("Must call setAmount() before build().");
            }
            if (this.payment.getDescription() == null) {
                throw new IllegalStateException("Must call setDescription() before build().");
            }
            return new EasyUpiPayment(this.activity, this.payment);
        }
    }
}

