/*
 * Decompiled with CFR 0.152.
 */
package com.shopify.buy.utils;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.util.Log;

public class NetworkUtility {
    protected static NetworkUtility instance;
    protected ConnectivityManager connectivityManager;

    public static NetworkUtility getInstance() {
        if (instance == null) {
            instance = new NetworkUtility();
        }
        return instance;
    }

    public static boolean isConnectedToNetwork(Context context) {
        return NetworkUtility.getInstance().isValidNetworkConnection(context);
    }

    protected ConnectivityManager getConnectivityManager(Context context) {
        if (this.connectivityManager == null) {
            this.connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        }
        return this.connectivityManager;
    }

    protected boolean isValidNetworkConnection(Context context) {
        boolean isConnected = false;
        try {
            NetworkInfo activeNetworkInfo = this.getConnectivityManager(context).getActiveNetworkInfo();
            if (activeNetworkInfo != null && activeNetworkInfo.isConnected()) {
                isConnected = true;
            }
        }
        catch (Exception e) {
            Log.e((String)NetworkUtility.class.getSimpleName(), (String)Log.getStackTraceString((Throwable)e));
        }
        return isConnected;
    }
}

