/*
 * Decompiled with CFR 0.152.
 */
package com.shopify.buy.utils;

public class ImageUtility {
    public static String getImageSuffixForDimensions(int width, int height) {
        int pixels = Math.max(width, height);
        if (pixels <= 16) {
            return "_pico";
        }
        if (pixels <= 32) {
            return "_icon";
        }
        if (pixels <= 50) {
            return "_thumb";
        }
        if (pixels <= 100) {
            return "_small";
        }
        if (pixels <= 160) {
            return "_compact";
        }
        if (pixels <= 240) {
            return "_medium";
        }
        if (pixels <= 480) {
            return "_large";
        }
        if (pixels <= 600) {
            return "_grande";
        }
        if (pixels <= 1024) {
            return "_1024x1024";
        }
        return "_2048x2048";
    }

    public static String stripQueryFromUrl(String url) {
        if (url == null || !url.contains("?")) {
            return url;
        }
        return url.substring(0, url.lastIndexOf(63));
    }
}

